/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import org.jdom.AttributeType;
import org.jdom.CloneBase;
import org.jdom.Element;
import org.jdom.Namespace;

public class Attribute
extends CloneBase
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 200L;
    public static final AttributeType UNDECLARED_TYPE = AttributeType.UNDECLARED;
    public static final AttributeType CDATA_TYPE = AttributeType.CDATA;
    public static final AttributeType ID_TYPE = AttributeType.ID;
    public static final AttributeType IDREF_TYPE = AttributeType.IDREF;
    public static final AttributeType IDREFS_TYPE = AttributeType.IDREFS;
    public static final AttributeType ENTITY_TYPE = AttributeType.ENTITY;
    public static final AttributeType ENTITIES_TYPE = AttributeType.ENTITIES;
    public static final AttributeType NMTOKEN_TYPE = AttributeType.NMTOKEN;
    public static final AttributeType NMTOKENS_TYPE = AttributeType.NMTOKENS;
    public static final AttributeType NOTATION_TYPE = AttributeType.NOTATION;
    public static final AttributeType ENUMERATED_TYPE = AttributeType.ENUMERATION;
    protected String name;
    protected Namespace namespace;
    protected String value;
    protected AttributeType type = AttributeType.UNDECLARED;
    protected boolean specified = true;
    protected transient Element parent;

    protected Attribute() {
    }

    public Element getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        String prefix = this.namespace.getPrefix();
        if ("".equals(prefix)) {
            return this.getName();
        }
        return prefix + ':' + this.getName();
    }

    public String getNamespacePrefix() {
        return this.namespace.getPrefix();
    }

    public String getNamespaceURI() {
        return this.namespace.getURI();
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "[Attribute: " + this.getQualifiedName() + "=\"" + this.value + "\"" + "]";
    }

    @Override
    public Attribute clone() {
        Attribute clone = (Attribute)super.clone();
        clone.parent = null;
        return clone;
    }

    protected Attribute setParent(Element parent2) {
        this.parent = parent2;
        return this;
    }
}

