/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import java.util.EnumSet;
import java.util.Set;
import kotlin.text.StringsKt;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.fusesource.jansi.internal.CLibrary;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CompilerSystemProperties;
import org.jetbrains.kotlin.cli.common.PropertiesKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

public abstract class PlainTextMessageRenderer
implements MessageRenderer {
    private static final boolean IS_STDERR_A_TTY;
    private static final String LINE_SEPARATOR;
    private static final Set<CompilerMessageSeverity> IMPORTANT_MESSAGE_SEVERITIES;
    private final boolean colorEnabled;

    public PlainTextMessageRenderer() {
        this(IS_STDERR_A_TTY);
    }

    public PlainTextMessageRenderer(boolean colorEnabled) {
        this.colorEnabled = colorEnabled;
    }

    @Override
    public String renderPreamble() {
        return "";
    }

    @Override
    public String render(@NotNull CompilerMessageSeverity severity, @NotNull String message2, @Nullable CompilerMessageSourceLocation location) {
        String path;
        if (severity == null) {
            PlainTextMessageRenderer.$$$reportNull$$$0(0);
        }
        if (message2 == null) {
            PlainTextMessageRenderer.$$$reportNull$$$0(1);
        }
        StringBuilder result2 = new StringBuilder();
        int line = location != null ? location.getLine() : -1;
        int column = location != null ? location.getColumn() : -1;
        String lineContent = location != null ? location.getLineContent() : null;
        String string2 = path = location != null ? this.getPath(location) : null;
        if (path != null) {
            result2.append(path);
            result2.append(":");
            if (line > 0) {
                result2.append(line).append(":");
                if (column > 0) {
                    result2.append(column).append(":");
                }
            }
            result2.append(" ");
        }
        if (this.colorEnabled) {
            String decapitalized;
            int firstNewline;
            Ansi ansi = Ansi.ansi().bold().fg(PlainTextMessageRenderer.severityColor(severity)).a(severity.getPresentableName()).a(": ").reset();
            if (IMPORTANT_MESSAGE_SEVERITIES.contains((Object)severity)) {
                ansi.bold();
            }
            if ((firstNewline = (decapitalized = PlainTextMessageRenderer.decapitalizeIfNeeded(message2)).indexOf(LINE_SEPARATOR)) < 0) {
                result2.append(ansi.a(decapitalized).reset());
            } else {
                result2.append(ansi.a(decapitalized.substring(0, firstNewline)).reset().a(decapitalized.substring(firstNewline)));
            }
        } else {
            result2.append(severity.getPresentableName());
            result2.append(": ");
            result2.append(PlainTextMessageRenderer.decapitalizeIfNeeded(message2));
        }
        if (lineContent != null && 1 <= column && column <= lineContent.length() + 1) {
            result2.append(LINE_SEPARATOR);
            result2.append(lineContent);
            result2.append(LINE_SEPARATOR);
            result2.append(StringsKt.repeat((CharSequence)" ", (int)(column - 1)));
            result2.append("^");
        }
        return result2.toString();
    }

    @NotNull
    private static String decapitalizeIfNeeded(@NotNull String message2) {
        if (message2 == null) {
            PlainTextMessageRenderer.$$$reportNull$$$0(2);
        }
        if (message2.startsWith("Java") || message2.startsWith("Kotlin")) {
            String string2 = message2;
            if (string2 == null) {
                PlainTextMessageRenderer.$$$reportNull$$$0(3);
            }
            return string2;
        }
        if (message2.length() >= 2 && Character.isUpperCase(message2.charAt(0)) && Character.isUpperCase(message2.charAt(1))) {
            String string3 = message2;
            if (string3 == null) {
                PlainTextMessageRenderer.$$$reportNull$$$0(4);
            }
            return string3;
        }
        String string4 = CapitalizeDecapitalizeKt.decapitalizeAsciiOnly(message2);
        if (string4 == null) {
            PlainTextMessageRenderer.$$$reportNull$$$0(5);
        }
        return string4;
    }

    @NotNull
    private static Ansi.Color severityColor(@NotNull CompilerMessageSeverity severity) {
        if (severity == null) {
            PlainTextMessageRenderer.$$$reportNull$$$0(6);
        }
        switch (severity) {
            case EXCEPTION: {
                Ansi.Color color = Ansi.Color.RED;
                if (color == null) {
                    PlainTextMessageRenderer.$$$reportNull$$$0(7);
                }
                return color;
            }
            case ERROR: {
                Ansi.Color color = Ansi.Color.RED;
                if (color == null) {
                    PlainTextMessageRenderer.$$$reportNull$$$0(8);
                }
                return color;
            }
            case STRONG_WARNING: {
                Ansi.Color color = Ansi.Color.YELLOW;
                if (color == null) {
                    PlainTextMessageRenderer.$$$reportNull$$$0(9);
                }
                return color;
            }
            case WARNING: {
                Ansi.Color color = Ansi.Color.YELLOW;
                if (color == null) {
                    PlainTextMessageRenderer.$$$reportNull$$$0(10);
                }
                return color;
            }
            case INFO: {
                Ansi.Color color = Ansi.Color.BLUE;
                if (color == null) {
                    PlainTextMessageRenderer.$$$reportNull$$$0(11);
                }
                return color;
            }
            case LOGGING: {
                Ansi.Color color = Ansi.Color.BLUE;
                if (color == null) {
                    PlainTextMessageRenderer.$$$reportNull$$$0(12);
                }
                return color;
            }
            case OUTPUT: {
                Ansi.Color color = Ansi.Color.BLUE;
                if (color == null) {
                    PlainTextMessageRenderer.$$$reportNull$$$0(13);
                }
                return color;
            }
        }
        throw new UnsupportedOperationException("Unknown severity: " + (Object)((Object)severity));
    }

    @Nullable
    protected abstract String getPath(@NotNull CompilerMessageSourceLocation var1);

    @Override
    public String renderUsage(@NotNull String usage) {
        if (usage == null) {
            PlainTextMessageRenderer.$$$reportNull$$$0(14);
        }
        return usage;
    }

    @Override
    public String renderConclusion() {
        return "";
    }

    public void enableColorsIfNeeded() {
        if (this.colorEnabled) {
            AnsiConsole.systemInstall();
        }
    }

    public void disableColorsIfNeeded() {
        if (this.colorEnabled) {
            AnsiConsole.systemUninstall();
        }
    }

    static {
        boolean isStderrATty = false;
        if (!PropertiesKt.isWindows() && "true".equals(CompilerSystemProperties.KOTLIN_COLORS_ENABLED_PROPERTY.getValue())) {
            try {
                isStderrATty = CLibrary.isatty(CLibrary.STDERR_FILENO) != 0;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
        IS_STDERR_A_TTY = isStderrATty;
        LINE_SEPARATOR = System.lineSeparator();
        IMPORTANT_MESSAGE_SEVERITIES = EnumSet.of(CompilerMessageSeverity.EXCEPTION, CompilerMessageSeverity.ERROR, CompilerMessageSeverity.STRONG_WARNING, CompilerMessageSeverity.WARNING);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/cli/common/messages/PlainTextMessageRenderer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/cli/common/messages/PlainTextMessageRenderer";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "decapitalizeIfNeeded";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "severityColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "decapitalizeIfNeeded";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "severityColor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "renderUsage";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

