/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmCachedDeclarations;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.InheritedDefaultMethodsOnClassesLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.InterfaceLowering;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020!H\u0016J\u0014\u0010\"\u001a\u00020\u0014*\u00020#2\u0006\u0010$\u001a\u00020\u000fH\u0002J\u0014\u0010%\u001a\u00020\u0014*\u00020#2\u0006\u0010$\u001a\u00020\u000fH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/InterfaceLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "removedFunctions", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "Lkotlin/collections/HashMap;", "removedFunctionsWithoutRemapping", "", "createDefaultImpl", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "function", "forCompatibility", "", "createJvmDefaultCompatibilityDelegate", "", "handleAnnotationClass", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "handleInterface", "lower", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "bridgeToStatic", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "callTarget", "bridgeViaAccessorTo", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nInterfaceLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InterfaceLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/InterfaceLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,299:1\n800#2,11:300\n1864#2,3:311\n1864#2,3:314\n1864#2,3:317\n*S KotlinDebug\n*F\n+ 1 InterfaceLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/InterfaceLowering\n*L\n176#1:300,11\n216#1:311,3\n220#1:314,3\n237#1:317,3\n*E\n"})
public final class InterfaceLowering
extends IrElementTransformerVoid
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final HashMap<IrSimpleFunctionSymbol, IrSimpleFunctionSymbol> removedFunctions;
    @NotNull
    private final Set<IrSimpleFunctionSymbol> removedFunctionsWithoutRemapping;

    public InterfaceLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.removedFunctions = new HashMap();
        this.removedFunctionsWithoutRemapping = new LinkedHashSet();
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        if (!JvmIrUtilsKt.isJvmInterface(irClass2)) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[irClass2.getKind().ordinal()]) {
            case 1: {
                this.handleInterface(irClass2);
                break;
            }
            case 2: {
                this.handleAnnotationClass(irClass2);
                break;
            }
            default: {
                return;
            }
        }
        CollectionsKt.removeAll(irClass2.getDeclarations(), (Function1)((Function1)new Function1<IrDeclaration, Boolean>(this){
            final /* synthetic */ InterfaceLowering this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull IrDeclaration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it instanceof IrFunction && (((Map)InterfaceLowering.access$getRemovedFunctions$p(this.this$0)).containsKey(((IrFunction)it).getSymbol()) || CollectionsKt.contains((Iterable)InterfaceLowering.access$getRemovedFunctionsWithoutRemapping$p(this.this$0), (Object)((IrFunction)it).getSymbol()));
            }
        }));
        IrClass defaultImplsIrClass = this.context.getCachedDeclarations().getDefaultImplsClass(irClass2);
        if (!((Collection)defaultImplsIrClass.getDeclarations()).isEmpty()) {
            irClass2.getDeclarations().add(defaultImplsIrClass);
        }
        IrElementTransformerVoidKt.transformChildrenVoid(irClass2, this);
    }

    /*
     * WARNING - void declaration
     */
    private final void handleInterface(IrClass irClass2) {
        void $this$filterIsInstanceTo$iv$iv;
        Object superImpl;
        JvmDefaultMode jvmDefaultMode2 = this.context.getConfig().getJvmDefaultMode();
        boolean isCompatibilityMode = jvmDefaultMode2.isCompatibility() && !JvmIrUtilsKt.hasJvmDefaultNoCompatibilityAnnotation(irClass2) || jvmDefaultMode2 == JvmDefaultMode.ALL_INCOMPATIBLE && JvmIrUtilsKt.hasJvmDefaultWithCompatibilityAnnotation(irClass2);
        for (IrSimpleFunction function2 : IrUtilsKt.getFunctions(irClass2)) {
            DescriptorVisibility visibility2;
            DescriptorVisibility descriptorVisibility;
            IrSimpleFunction defaultImpl;
            if (function2.getModality() == Modality.ABSTRACT) continue;
            if (function2.isFakeOverride()) {
                IrSimpleFunction implementation2;
                String string2 = function2.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                if (StringsKt.endsWith$default((String)string2, (String)"$default", (boolean)false, (int)2, null)) continue;
                if ((IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverride$default(function2, false, null, 3, null) == null) {
                    throw new IllegalStateException(("No single implementation found for: " + RenderIrElementKt.render$default(function2, null, 1, null)).toString());
                }
                if (DescriptorVisibilities.isPrivate(implementation2.getVisibility()) || IrUtilsKt.isMethodOfAny(implementation2)) continue;
                if (!InheritedDefaultMethodsOnClassesLoweringKt.isDefinitelyNotDefaultImplsMethod(function2, jvmDefaultMode2, implementation2)) {
                    IrSimpleFunction irSimpleFunction;
                    IrSimpleFunction defaultImpl2 = InterfaceLowering.createDefaultImpl$default(this, function2, false, 2, null);
                    superImpl = JvmIrUtilsKt.firstSuperMethodFromKotlin(function2, implementation2);
                    IrSimpleFunction it = irSimpleFunction = JvmCachedDeclarations.getDefaultImplsFunction$default(this.context.getCachedDeclarations(), (IrSimpleFunction)superImpl.getOwner(), false, 2, null);
                    boolean bl = false;
                    this.bridgeToStatic(defaultImpl2, it);
                    continue;
                }
                if (!isCompatibilityMode || !JvmIrUtilsKt.isCompiledToJvmDefault(implementation2, jvmDefaultMode2)) continue;
                this.createJvmDefaultCompatibilityDelegate(function2);
                continue;
            }
            if (!JvmIrUtilsKt.isCompiledToJvmDefault(function2, jvmDefaultMode2) && (DescriptorVisibilities.isPrivate(function2.getVisibility()) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)IrDeclarationOrigin.FUNCTION_FOR_DEFAULT_PARAMETER.INSTANCE) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.SYNTHETIC_METHOD_FOR_PROPERTY_OR_TYPEALIAS_ANNOTATIONS.INSTANCE)) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.SYNTHETIC_METHOD_FOR_PROPERTY_OR_TYPEALIAS_ANNOTATIONS.INSTANCE) && (isCompatibilityMode || jvmDefaultMode2 == JvmDefaultMode.ENABLE) && JvmIrUtilsKt.isCompiledToJvmDefault(function2, jvmDefaultMode2)) {
                if (Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INLINE_LAMBDA.INSTANCE)) {
                    IrClass defaultImplsClass = this.context.getCachedDeclarations().getDefaultImplsClass(irClass2);
                    defaultImplsClass.getDeclarations().add(function2);
                    this.removedFunctionsWithoutRemapping.add(function2.getSymbol());
                    function2.setParent(defaultImplsClass);
                    continue;
                }
                defaultImpl = InterfaceLowering.createDefaultImpl$default(this, function2, false, 2, null);
                defaultImpl.setBody(IrInlineUtilsKt.moveBodyTo(function2, defaultImpl));
                ((Map)this.removedFunctions).put(function2.getSymbol(), defaultImpl.getSymbol());
                continue;
            }
            if (!JvmIrUtilsKt.isCompiledToJvmDefault(function2, jvmDefaultMode2)) {
                defaultImpl = InterfaceLowering.createDefaultImpl$default(this, function2, false, 2, null);
                defaultImpl.setBody(IrInlineUtilsKt.moveBodyTo(function2, defaultImpl));
                function2.setBody(null);
                continue;
            }
            if (!isCompatibilityMode) continue;
            if (Intrinsics.areEqual((Object)function2.getOrigin(), (Object)IrDeclarationOrigin.FUNCTION_FOR_DEFAULT_PARAMETER.INSTANCE)) {
                IrFunction irFunction2 = this.context.getMapping().getDefaultArgumentsOriginalFunction().get((IrFunction)((IrDeclaration)function2));
                Intrinsics.checkNotNull((Object)irFunction2);
                descriptorVisibility = irFunction2.getVisibility();
            } else {
                descriptorVisibility = function2.getVisibility();
            }
            if (DescriptorVisibilities.isPrivate(visibility2 = descriptorVisibility)) continue;
            this.createJvmDefaultCompatibilityDelegate(function2);
        }
        IrClass defaultImplsIrClass = this.context.getCachedDeclarations().getDefaultImplsClass(irClass2);
        Iterable $this$filterIsInstance$iv = irClass2.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        superImpl = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrField)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (IrField field2 : (List)destination$iv$iv) {
            if ((jvmDefaultMode2.getForAllMethodsWithBody() || !Intrinsics.areEqual((Object)field2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.GENERATED_PROPERTY_REFERENCE.INSTANCE)) && !Intrinsics.areEqual((Object)field2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.GENERATED_ASSERTION_ENABLED_FIELD.INSTANCE)) continue;
            irClass2.getDeclarations().remove(field2);
            defaultImplsIrClass.getDeclarations().add(0, field2);
            field2.setParent(defaultImplsIrClass);
        }
    }

    private final void createJvmDefaultCompatibilityDelegate(IrSimpleFunction function2) {
        IrSimpleFunction defaultImpl = this.createDefaultImpl(function2, true);
        this.bridgeViaAccessorTo(defaultImpl, function2);
    }

    private final void handleAnnotationClass(IrClass irClass2) {
        Sequence annotationsMethods2 = SequencesKt.filter(IrUtilsKt.getFunctions(irClass2), (Function1)handleAnnotationClass.annotationsMethods.1.INSTANCE);
        if (SequencesKt.none((Sequence)annotationsMethods2)) {
            return;
        }
        for (IrSimpleFunction function2 : annotationsMethods2) {
            IrSimpleFunction defaultImpl = InterfaceLowering.createDefaultImpl$default(this, function2, false, 2, null);
            defaultImpl.setBody(IrInlineUtilsKt.moveBodyTo(function2, defaultImpl));
            ((Map)this.removedFunctions).put(function2.getSymbol(), defaultImpl.getSymbol());
        }
    }

    private final IrSimpleFunction createDefaultImpl(IrSimpleFunction function2, boolean forCompatibility) {
        IrSimpleFunction irSimpleFunction;
        IrSimpleFunction newFunction2 = irSimpleFunction = this.context.getCachedDeclarations().getDefaultImplsFunction(function2, forCompatibility);
        boolean bl = false;
        IrUtilsKt.getParentAsClass(newFunction2).getDeclarations().add(newFunction2);
        return irSimpleFunction;
    }

    static /* synthetic */ IrSimpleFunction createDefaultImpl$default(InterfaceLowering interfaceLowering, IrSimpleFunction irSimpleFunction, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return interfaceLowering.createDefaultImpl(irSimpleFunction, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void bridgeToStatic(IrFunction $this$bridgeToStatic, IrSimpleFunction callTarget) {
        void call2;
        int i;
        int n;
        IrCallImpl irCallImpl;
        IrCallImpl irCallImpl2 = irCallImpl = IrCallImpl.Companion.fromSymbolOwner$default(IrCallImpl.Companion, $this$bridgeToStatic.getStartOffset(), $this$bridgeToStatic.getEndOffset(), $this$bridgeToStatic.getReturnType(), callTarget.getSymbol(), 0, 0, null, null, 240, null);
        IrFunction irFunction2 = $this$bridgeToStatic;
        boolean bl = false;
        Iterable $this$forEachIndexed$iv = callTarget.getTypeParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrTypeParameter cfr_ignored_0 = (IrTypeParameter)item$iv;
            i = n;
            boolean bl2 = false;
            call2.putTypeArgument(i, JvmIrUtilsKt.createPlaceholderAnyNType(this.context.getIrBuiltIns()));
        }
        $this$forEachIndexed$iv = $this$bridgeToStatic.getValueParameters();
        $i$f$forEachIndexed = false;
        index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter = (IrValueParameter)item$iv;
            i = n;
            boolean bl3 = false;
            call2.putValueArgument(i, new IrGetValueImpl($this$bridgeToStatic.getStartOffset(), $this$bridgeToStatic.getEndOffset(), it.getSymbol(), null, 8, null));
        }
        IrExpression irExpression = irCallImpl;
        irFunction2.setBody(new IrExpressionBodyImpl(irExpression));
    }

    /*
     * WARNING - void declaration
     */
    private final void bridgeViaAccessorTo(IrFunction $this$bridgeViaAccessorTo, IrSimpleFunction callTarget) {
        IrValueParameter it;
        void call2;
        IrCallImpl irCallImpl;
        IrCallImpl irCallImpl2 = irCallImpl = IrCallImpl.Companion.fromSymbolOwner$default(IrCallImpl.Companion, $this$bridgeViaAccessorTo.getStartOffset(), $this$bridgeViaAccessorTo.getEndOffset(), $this$bridgeViaAccessorTo.getReturnType(), callTarget.getSymbol(), 0, 0, null, IrUtilsKt.getParentAsClass(callTarget).getSymbol(), 112, null);
        IrFunction irFunction2 = $this$bridgeViaAccessorTo;
        boolean bl = false;
        Iterable $this$forEachIndexed$iv = CollectionsKt.drop((Iterable)$this$bridgeViaAccessorTo.getTypeParameters(), (int)IrUtilsKt.getParentAsClass(callTarget).getTypeParameters().size());
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void typeParameter2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrTypeParameter irTypeParameter2 = (IrTypeParameter)item$iv;
            int i = n;
            boolean bl2 = false;
            call2.putTypeArgument(i, IrTypesKt.getDefaultType((IrTypeParameter)typeParameter2));
        }
        int offset2 = 0;
        IrValueParameter irValueParameter = callTarget.getDispatchReceiverParameter();
        if (irValueParameter != null) {
            it = irValueParameter;
            boolean bl3 = false;
            call2.setDispatchReceiver(new IrGetValueImpl($this$bridgeViaAccessorTo.getStartOffset(), $this$bridgeViaAccessorTo.getEndOffset(), $this$bridgeViaAccessorTo.getValueParameters().get(offset2).getSymbol(), null, 8, null));
            ++offset2;
        }
        IrValueParameter irValueParameter2 = callTarget.getExtensionReceiverParameter();
        if (irValueParameter2 != null) {
            it = irValueParameter2;
            boolean bl4 = false;
            call2.setExtensionReceiver(new IrGetValueImpl($this$bridgeViaAccessorTo.getStartOffset(), $this$bridgeViaAccessorTo.getEndOffset(), $this$bridgeViaAccessorTo.getValueParameters().get(offset2).getSymbol(), null, 8, null));
            ++offset2;
        }
        int n = $this$bridgeViaAccessorTo.getValueParameters().size();
        for (int i = offset2; i < n; ++i) {
            call2.putValueArgument(i - offset2, new IrGetValueImpl($this$bridgeViaAccessorTo.getStartOffset(), $this$bridgeViaAccessorTo.getEndOffset(), $this$bridgeViaAccessorTo.getValueParameters().get(i).getSymbol(), null, 8, null));
        }
        IrExpression irExpression = irCallImpl;
        irFunction2.setBody(new IrExpressionBodyImpl(irExpression));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitReturn(@NotNull IrReturn expression2) {
        IrReturn irReturn;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)((Map)this.removedFunctions).get(expression2.getReturnTargetSymbol());
        IrSimpleFunction newFunction2 = irSimpleFunctionSymbol != null ? (IrSimpleFunction)irSimpleFunctionSymbol.getOwner() : null;
        InterfaceLowering interfaceLowering = this;
        if (newFunction2 != null) {
            void $this$visitReturn_u24lambda_u249;
            IrReturn irReturn2 = expression2;
            InterfaceLowering interfaceLowering2 = interfaceLowering;
            boolean bl = false;
            interfaceLowering = interfaceLowering2;
            irReturn = new IrReturnImpl($this$visitReturn_u24lambda_u249.getStartOffset(), $this$visitReturn_u24lambda_u249.getEndOffset(), $this$visitReturn_u24lambda_u249.getType(), newFunction2.getSymbol(), $this$visitReturn_u24lambda_u249.getValue());
        } else {
            irReturn = expression2;
        }
        return super.visitReturn(irReturn);
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.removedFunctions.get(expression2.getSymbol());
        IrSimpleFunction newFunction2 = irSimpleFunctionSymbol != null ? (IrSimpleFunction)irSimpleFunctionSymbol.getOwner() : null;
        return super.visitCall(newFunction2 != null ? JvmIrUtilsKt.createDelegatingCallWithPlaceholderTypeArguments(expression2, newFunction2, this.context.getIrBuiltIns()) : expression2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
        IrFunctionReference irFunctionReference;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)((Map)this.removedFunctions).get(expression2.getSymbol());
        IrSimpleFunction newFunction2 = irSimpleFunctionSymbol != null ? (IrSimpleFunction)irSimpleFunctionSymbol.getOwner() : null;
        InterfaceLowering interfaceLowering = this;
        if (newFunction2 != null) {
            void $this$visitFunctionReference_u24lambda_u2411;
            IrFunctionReferenceImpl irFunctionReferenceImpl;
            IrFunctionReference irFunctionReference2 = expression2;
            InterfaceLowering interfaceLowering2 = interfaceLowering;
            boolean bl = false;
            IrFunctionReferenceImpl $this$visitFunctionReference_u24lambda_u2411_u24lambda_u2410 = irFunctionReferenceImpl = new IrFunctionReferenceImpl($this$visitFunctionReference_u24lambda_u2411.getStartOffset(), $this$visitFunctionReference_u24lambda_u2411.getEndOffset(), $this$visitFunctionReference_u24lambda_u2411.getType(), newFunction2.getSymbol(), newFunction2.getTypeParameters().size(), newFunction2.getValueParameters().size(), expression2.getReflectionTarget(), $this$visitFunctionReference_u24lambda_u2411.getOrigin());
            boolean bl2 = false;
            JvmIrUtilsKt.copyFromWithPlaceholderTypeArguments($this$visitFunctionReference_u24lambda_u2411_u24lambda_u2410, expression2, this.context.getIrBuiltIns());
            IrDeclarationsKt.copyAttributes((IrAttributeContainer)$this$visitFunctionReference_u24lambda_u2411_u24lambda_u2410, expression2);
            interfaceLowering = interfaceLowering2;
            irFunctionReference = irFunctionReferenceImpl;
        } else {
            irFunctionReference = expression2;
        }
        return super.visitFunctionReference(irFunctionReference);
    }

    public static final /* synthetic */ HashMap access$getRemovedFunctions$p(InterfaceLowering $this) {
        return $this.removedFunctions;
    }

    public static final /* synthetic */ Set access$getRemovedFunctionsWithoutRemapping$p(InterfaceLowering $this) {
        return $this.removedFunctionsWithoutRemapping;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.INTERFACE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

