/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.TypeVariableTypeConstructor;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tower.NewResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.tower.SimplePSIKotlinCallArgument;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/NullableVarargArgumentCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class NullableVarargArgumentCallChecker
implements CallChecker {
    @NotNull
    public static final NullableVarargArgumentCallChecker INSTANCE = new NullableVarargArgumentCallChecker();

    private NullableVarargArgumentCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.NewInference)) {
            return;
        }
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
            this.check(((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getFunctionCall(), reportOn, context);
            return;
        }
        if (!(resolvedCall2 instanceof NewResolvedCallImpl)) {
            return;
        }
        for (ResolvedCallArgument argument2 : ((NewResolvedCallImpl)resolvedCall2).getArgumentMappingByOriginal().values()) {
            for (KotlinCallArgument arg : argument2.getArguments()) {
                LeafPsiElement spreadElement;
                KotlinType type2;
                Object object;
                if (!arg.isSpread() || !(arg instanceof SimplePSIKotlinCallArgument) || ((SimplePSIKotlinCallArgument)arg).getValueArgument().getSpreadElement() == null) continue;
                ReceiverValueWithSmartCastInfo $this$safeAs$iv = ((SimplePSIKotlinCallArgument)arg).getReceiver();
                boolean $i$f$safeAs = false;
                ReceiverValueWithSmartCastInfo receiverValueWithSmartCastInfo = $this$safeAs$iv;
                if (!(receiverValueWithSmartCastInfo instanceof ReceiverValueWithSmartCastInfo)) {
                    receiverValueWithSmartCastInfo = null;
                }
                if (receiverValueWithSmartCastInfo == null) continue;
                ReceiverValueWithSmartCastInfo receiver = receiverValueWithSmartCastInfo;
                if (ArgumentsUtilsKt.getStableType(receiver).getConstructor() instanceof TypeVariableTypeConstructor) {
                    object = (KotlinTypeInfo)context.getTrace().getBindingContext().get(BindingContext.EXPRESSION_TYPE_INFO, ((SimplePSIKotlinCallArgument)arg).getValueArgument().getArgumentExpression());
                    if (object == null || (object = ((KotlinTypeInfo)object).getType()) == null) {
                        object = ArgumentsUtilsKt.getStableType(receiver);
                    }
                } else {
                    object = ArgumentsUtilsKt.getStableType(receiver);
                }
                if ((type2 = object) instanceof FlexibleType || !TypeUtils.isNullableType(type2)) continue;
                context.getTrace().report(Errors.SPREAD_OF_NULLABLE.on((LeafPsiElement)((PsiElement)spreadElement)));
            }
        }
    }
}

