/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.ic;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.ic.ICUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.ic.IdSignatureProtoType;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.protobuf.CodedInputStream;
import org.jetbrains.kotlin.protobuf.CodedOutputStream;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\u0002H\u0000\u001a*\u0010\b\u001a\u00020\u0007*\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004H\u0000\u00a8\u0006\f"}, d2={"readIdSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lorg/jetbrains/kotlin/protobuf/CodedInputStream;", "indexToSignatureMapper", "Lkotlin/Function1;", "", "skipIdSignature", "", "writeIdSignature", "Lorg/jetbrains/kotlin/protobuf/CodedOutputStream;", "signature", "signatureToIndexMapper", "backend.js"})
public final class IdSignatureSerializationKt {
    public static final void writeIdSignature(@NotNull CodedOutputStream $this$writeIdSignature, @NotNull IdSignature signature2, @NotNull Function1<? super IdSignature, Integer> signatureToIndexMapper) {
        Intrinsics.checkNotNullParameter((Object)$this$writeIdSignature, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)signature2, (String)"signature");
        Intrinsics.checkNotNullParameter(signatureToIndexMapper, (String)"signatureToIndexMapper");
        Integer index2 = (Integer)signatureToIndexMapper.invoke((Object)signature2);
        if (index2 != null) {
            $this$writeIdSignature.writeInt32NoTag(IdSignatureProtoType.DECLARED_SIGNATURE.getId());
            $this$writeIdSignature.writeInt32NoTag(index2);
            return;
        }
        IdSignature idSignature = signature2;
        if (idSignature instanceof IdSignature.CommonSignature) {
            $this$writeIdSignature.writeInt32NoTag(IdSignatureProtoType.COMMON_SIGNATURE.getId());
            $this$writeIdSignature.writeStringNoTag(((IdSignature.CommonSignature)signature2).getPackageFqName());
            $this$writeIdSignature.writeStringNoTag(((IdSignature.CommonSignature)signature2).getDeclarationFqName());
            Long id = ((IdSignature.CommonSignature)signature2).getId();
            if (id != null) {
                $this$writeIdSignature.writeBoolNoTag(true);
                $this$writeIdSignature.writeFixed64NoTag(id);
            } else {
                $this$writeIdSignature.writeBoolNoTag(false);
            }
            $this$writeIdSignature.writeInt64NoTag(((IdSignature.CommonSignature)signature2).getMask());
        } else if (idSignature instanceof IdSignature.CompositeSignature) {
            $this$writeIdSignature.writeInt32NoTag(IdSignatureProtoType.COMPOSITE_SIGNATURE.getId());
            IdSignatureSerializationKt.writeIdSignature($this$writeIdSignature, ((IdSignature.CompositeSignature)signature2).getContainer(), signatureToIndexMapper);
            IdSignatureSerializationKt.writeIdSignature($this$writeIdSignature, ((IdSignature.CompositeSignature)signature2).getInner(), signatureToIndexMapper);
        } else if (idSignature instanceof IdSignature.AccessorSignature) {
            $this$writeIdSignature.writeInt32NoTag(IdSignatureProtoType.ACCESSOR_SIGNATURE.getId());
            IdSignatureSerializationKt.writeIdSignature($this$writeIdSignature, ((IdSignature.AccessorSignature)signature2).getPropertySignature(), signatureToIndexMapper);
            IdSignatureSerializationKt.writeIdSignature($this$writeIdSignature, ((IdSignature.AccessorSignature)signature2).getAccessorSignature(), signatureToIndexMapper);
        } else {
            ICUtilsKt.icError-5T69zGA$default("can not write " + signature2 + " signature", null, null, 6, null);
            throw null;
        }
    }

    @NotNull
    public static final IdSignature readIdSignature(@NotNull CodedInputStream $this$readIdSignature, @NotNull Function1<? super Integer, ? extends IdSignature> indexToSignatureMapper) {
        Intrinsics.checkNotNullParameter((Object)$this$readIdSignature, (String)"<this>");
        Intrinsics.checkNotNullParameter(indexToSignatureMapper, (String)"indexToSignatureMapper");
        int signatureType = $this$readIdSignature.readInt32();
        if (signatureType == IdSignatureProtoType.DECLARED_SIGNATURE.getId()) {
            return (IdSignature)indexToSignatureMapper.invoke((Object)$this$readIdSignature.readInt32());
        }
        if (signatureType == IdSignatureProtoType.COMMON_SIGNATURE.getId()) {
            String packageFqName = $this$readIdSignature.readString();
            String declarationFqName = $this$readIdSignature.readString();
            Long id = $this$readIdSignature.readBool() ? Long.valueOf($this$readIdSignature.readFixed64()) : (Long)null;
            long mask = $this$readIdSignature.readInt64();
            Intrinsics.checkNotNullExpressionValue((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullExpressionValue((Object)declarationFqName, (String)"declarationFqName");
            return new IdSignature.CommonSignature(packageFqName, declarationFqName, id, mask);
        }
        if (signatureType == IdSignatureProtoType.COMPOSITE_SIGNATURE.getId()) {
            IdSignature containerSignature = IdSignatureSerializationKt.readIdSignature($this$readIdSignature, indexToSignatureMapper);
            IdSignature innerSignature = IdSignatureSerializationKt.readIdSignature($this$readIdSignature, indexToSignatureMapper);
            return new IdSignature.CompositeSignature(containerSignature, innerSignature);
        }
        if (signatureType == IdSignatureProtoType.ACCESSOR_SIGNATURE.getId()) {
            IdSignature propertySignature = IdSignatureSerializationKt.readIdSignature($this$readIdSignature, indexToSignatureMapper);
            IdSignature accessorSignature = IdSignatureSerializationKt.readIdSignature($this$readIdSignature, indexToSignatureMapper);
            if (!(accessorSignature instanceof IdSignature.CommonSignature)) {
                ICUtilsKt.icError-5T69zGA$default("can not read accessor signature", null, null, 6, null);
                throw null;
            }
            return new IdSignature.AccessorSignature(propertySignature, (IdSignature.CommonSignature)accessorSignature);
        }
        ICUtilsKt.icError-5T69zGA$default("can not read signature type " + signatureType, null, null, 6, null);
        throw null;
    }

    public static final void skipIdSignature(@NotNull CodedInputStream $this$skipIdSignature) {
        Intrinsics.checkNotNullParameter((Object)$this$skipIdSignature, (String)"<this>");
        int signatureType = $this$skipIdSignature.readInt32();
        if (signatureType == IdSignatureProtoType.DECLARED_SIGNATURE.getId()) {
            $this$skipIdSignature.readInt32();
        } else if (signatureType == IdSignatureProtoType.COMMON_SIGNATURE.getId()) {
            $this$skipIdSignature.readString();
            $this$skipIdSignature.readString();
            if ($this$skipIdSignature.readBool()) {
                $this$skipIdSignature.readFixed64();
            }
            $this$skipIdSignature.readInt64();
        } else if (signatureType == IdSignatureProtoType.COMPOSITE_SIGNATURE.getId()) {
            IdSignatureSerializationKt.skipIdSignature($this$skipIdSignature);
            IdSignatureSerializationKt.skipIdSignature($this$skipIdSignature);
        } else if (signatureType == IdSignatureProtoType.ACCESSOR_SIGNATURE.getId()) {
            IdSignatureSerializationKt.skipIdSignature($this$skipIdSignature);
            IdSignatureSerializationKt.skipIdSignature($this$skipIdSignature);
        } else {
            ICUtilsKt.icError-5T69zGA$default("can not skip signature type " + signatureType, null, null, 6, null);
            throw null;
        }
    }
}

