/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.extensions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rJ\u001b\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010\u0014\u001a\u00020\u000fR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/extensions/ApplicationExtensionDescriptor;", "T", "", "name", "", "extensionClass", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)V", "extensionPointName", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "getExtensionPointName", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "getInstances", "", "registerExtension", "", "extension", "disposable", "Lcom/intellij/openapi/Disposable;", "(Ljava/lang/Object;Lcom/intellij/openapi/Disposable;)V", "registerExtensionPoint", "util"})
public class ApplicationExtensionDescriptor<T> {
    @NotNull
    private final Class<T> extensionClass;
    @NotNull
    private final ExtensionPointName<T> extensionPointName;

    public ApplicationExtensionDescriptor(@NotNull String name, @NotNull Class<T> extensionClass) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(extensionClass, (String)"extensionClass");
        this.extensionClass = extensionClass;
        ExtensionPointName extensionPointName = ExtensionPointName.create(name);
        Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"create(name)");
        this.extensionPointName = extensionPointName;
    }

    @NotNull
    public final ExtensionPointName<T> getExtensionPointName() {
        return this.extensionPointName;
    }

    public final void registerExtensionPoint() {
        ApplicationManager.getApplication().getExtensionArea().registerExtensionPoint(this.extensionPointName.getName(), this.extensionClass.getName(), ExtensionPoint.Kind.INTERFACE);
    }

    public final void registerExtension(@NotNull T extension, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter(extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        ApplicationManager.getApplication().getExtensionArea().getExtensionPoint(this.extensionPointName).registerExtension(extension, disposable);
    }

    @NotNull
    public final List<T> getInstances() {
        ExtensionsArea extensionsArea = ApplicationManager.getApplication().getExtensionArea();
        Intrinsics.checkNotNullExpressionValue((Object)extensionsArea, (String)"getApplication().extensionArea");
        ExtensionsArea projectArea = extensionsArea;
        if (!projectArea.hasExtensionPoint(this.extensionPointName.getName())) {
            return CollectionsKt.emptyList();
        }
        Object[] objectArray = projectArea.getExtensionPoint(this.extensionPointName).getExtensions();
        Intrinsics.checkNotNullExpressionValue(objectArray, (String)"projectArea.getExtension\u2026sionPointName).extensions");
        return ArraysKt.toList((Object[])objectArray);
    }
}

