/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.JvmFieldApplicabilityProblem;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FieldDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.load.java.DescriptorsJvmAbiUtil;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.InlineClassManglingRulesKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.checkers.DeclarationCheckersKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u000f\u001a\u00020\f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\f*\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmFieldApplicabilityChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isInterfaceCompanionWithPublicJvmFieldProperties", "", "companionObject", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "hasBackingField", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "hasCustomAccessor", "Lorg/jetbrains/kotlin/psi/KtProperty;", "frontend.java"})
public final class JvmFieldApplicabilityChecker
implements DeclarationChecker {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        JvmFieldApplicabilityProblem jvmFieldApplicabilityProblem;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(descriptor2 instanceof PropertyDescriptor)) return;
        if (!(declaration instanceof KtProperty) && !(declaration instanceof KtParameter)) {
            return;
        }
        AnnotationDescriptor annotationDescriptor = JvmAnnotationUtilKt.findJvmFieldAnnotation(descriptor2);
        if (annotationDescriptor == null) {
            FieldDescriptor fieldDescriptor = ((PropertyDescriptor)descriptor2).getDelegateField();
            Object object = fieldDescriptor;
            if (fieldDescriptor == null) return;
            Annotations annotations2 = object.getAnnotations();
            object = annotations2;
            if (annotations2 == null) return;
            AnnotationDescriptor annotationDescriptor2 = object.findAnnotation(JvmAbi.JVM_FIELD_ANNOTATION_FQ_NAME);
            annotationDescriptor = annotationDescriptor2;
            if (annotationDescriptor2 == null) {
                return;
            }
        }
        AnnotationDescriptor annotation2 = annotationDescriptor;
        if (declaration instanceof KtProperty && ((KtProperty)declaration).hasDelegate()) {
            jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.DELEGATE;
        } else {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
            BindingContext bindingContext = context.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"context.trace.bindingContext");
            if (!this.hasBackingField(propertyDescriptor, bindingContext)) {
                return;
            }
            if (ModalityUtilsKt.isOverridable((CallableMemberDescriptor)descriptor2)) {
                jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.NOT_FINAL;
            } else if (DescriptorVisibilities.isPrivate(((PropertyDescriptor)descriptor2).getVisibility())) {
                jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.PRIVATE;
            } else if (declaration instanceof KtProperty && this.hasCustomAccessor((KtProperty)declaration)) {
                jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.CUSTOM_ACCESSOR;
            } else {
                Collection<? extends PropertyDescriptor> collection = ((PropertyDescriptor)descriptor2).getOverriddenDescriptors();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"descriptor.overriddenDescriptors");
                if (!collection.isEmpty()) {
                    jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.OVERRIDES;
                } else if (((PropertyDescriptor)descriptor2).isLateInit()) {
                    jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.LATEINIT;
                } else if (((PropertyDescriptor)descriptor2).isConst()) {
                    jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.CONST;
                } else if (DeclarationCheckersKt.isInsideCompanionObjectOfInterface((CallableMemberDescriptor)descriptor2)) {
                    if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.JvmFieldInInterface)) {
                        jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.INSIDE_COMPANION_OF_INTERFACE;
                    } else {
                        DeclarationDescriptor declarationDescriptor = ((PropertyDescriptor)descriptor2).getContainingDeclaration();
                        Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                        if (this.isInterfaceCompanionWithPublicJvmFieldProperties((ClassDescriptor)declarationDescriptor)) return;
                        jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.NOT_PUBLIC_VAL_WITH_JVMFIELD;
                    }
                } else if (DescriptorUtils.isTopLevelDeclaration(descriptor2) && JvmFileClassUtilKt.isInsideJvmMultifileClassFile(declaration)) {
                    jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.TOP_LEVEL_PROPERTY_OF_MULTIFILE_FACADE;
                } else {
                    KotlinType kotlinType = ((PropertyDescriptor)descriptor2).getReturnType();
                    if (kotlinType == null) return;
                    if (!InlineClassManglingRulesKt.isInlineClassThatRequiresMangling(kotlinType)) return;
                    boolean bl = true;
                    if (!bl) return;
                    jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.RETURN_TYPE_IS_INLINE_CLASS;
                }
            }
        }
        JvmFieldApplicabilityProblem problem = jvmFieldApplicabilityProblem;
        KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(annotation2);
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry annotationEntry = ktAnnotationEntry;
        DiagnosticFactory1<KtAnnotationEntry, String> factory2 = declaration instanceof KtParameter && !context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitJvmFieldOnOverrideFromInterfaceInPrimaryConstructor) ? ErrorsJvm.INAPPLICABLE_JVM_FIELD_WARNING : ErrorsJvm.INAPPLICABLE_JVM_FIELD;
        context.getTrace().report(factory2.on((KtAnnotationEntry)((PsiElement)annotationEntry), problem.getErrorMessage()));
    }

    private final boolean isInterfaceCompanionWithPublicJvmFieldProperties(ClassDescriptor companionObject2) {
        for (DeclarationDescriptor next : companionObject2.getUnsubstitutedMemberScope().getContributedDescriptors(DescriptorKindFilter.VARIABLES, MemberScope.Companion.getALL_NAME_FILTER())) {
            if (!(next instanceof PropertyDescriptor)) continue;
            if (!Intrinsics.areEqual((Object)((PropertyDescriptor)next).getVisibility(), (Object)DescriptorVisibilities.PUBLIC) || ((PropertyDescriptor)next).isVar() || ((PropertyDescriptor)next).getModality() != Modality.FINAL) {
                return false;
            }
            if (DescriptorsJvmAbiUtil.hasJvmFieldAnnotation((CallableMemberDescriptor)next)) continue;
            return false;
        }
        return true;
    }

    private final boolean hasCustomAccessor(KtProperty $this$hasCustomAccessor) {
        return $this$hasCustomAccessor.getGetter() != null || $this$hasCustomAccessor.getSetter() != null;
    }

    private final boolean hasBackingField(PropertyDescriptor $this$hasBackingField, BindingContext bindingContext) {
        Boolean bl = (Boolean)bindingContext.get(BindingContext.BACKING_FIELD_REQUIRED, $this$hasBackingField);
        if (bl == null) {
            bl = false;
        }
        return bl;
    }
}

