/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.TrailingCommaChecker;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/TrailingCommaCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class TrailingCommaCallChecker
implements CallChecker {
    @NotNull
    public static final TrailingCommaCallChecker INSTANCE = new TrailingCommaCallChecker();

    private TrailingCommaCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"resolvedCall.call.callElement");
        KtElement callElement = ktElement;
        if (callElement instanceof KtArrayAccessExpression) {
            TrailingCommaChecker.INSTANCE.check(((KtArrayAccessExpression)callElement).getTrailingComma(), context.getTrace(), context.getLanguageVersionSettings());
        } else if (callElement instanceof KtCollectionLiteralExpression) {
            TrailingCommaChecker.INSTANCE.check(((KtCollectionLiteralExpression)callElement).getTrailingComma(), context.getTrace(), context.getLanguageVersionSettings());
        } else if (callElement instanceof KtWhenExpression) {
            if (((KtWhenExpression)callElement).getSubjectExpression() != null) {
                List<KtWhenEntry> list2 = ((KtWhenExpression)callElement).getEntries();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"callElement.entries");
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtWhenEntry whenEntry = (KtWhenEntry)element$iv;
                    boolean bl = false;
                    TrailingCommaChecker.INSTANCE.check(whenEntry.getTrailingComma(), context.getTrace(), context.getLanguageVersionSettings());
                }
            }
        } else {
            Call $this$check_u24lambda_u241 = resolvedCall2.getCall();
            boolean bl = false;
            KtValueArgumentList ktValueArgumentList = $this$check_u24lambda_u241.getValueArgumentList();
            TrailingCommaChecker.INSTANCE.check(ktValueArgumentList != null ? ktValueArgumentList.getTrailingComma() : null, context.getTrace(), context.getLanguageVersionSettings());
        }
    }
}

