/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.JvmNames;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmRecordChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "JAVA_RECORD_CLASS_ID", "Lorg/jetbrains/kotlin/name/ClassId;", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
public final class FirJvmRecordChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirJvmRecordChecker INSTANCE = new FirJvmRecordChecker();
    @NotNull
    private static final ClassId JAVA_RECORD_CLASS_ID;

    private FirJvmRecordChecker() {
    }

    @Override
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        block18: {
            Modality modality$iv;
            Object object;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            FirTypeRef firTypeRef = (FirTypeRef)CollectionsKt.firstOrNull(declaration.getSuperTypeRefs());
            if (firTypeRef != null) {
                FirTypeRef typeRef = firTypeRef;
                boolean bl = false;
                FirTypeRef $this$coneTypeSafe$iv = typeRef;
                boolean $i$f$coneTypeSafe = false;
                FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                if (!(coneKotlinType instanceof ConeClassLikeType)) {
                    coneKotlinType = null;
                }
                ConeClassLikeType coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType));
                if (Intrinsics.areEqual((Object)(coneClassLikeType != null ? ConeTypeUtilsKt.getClassId(coneClassLikeType) : null), (Object)JAVA_RECORD_CLASS_ID)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)typeRef.getSource(), FirJvmErrors.INSTANCE.getILLEGAL_JAVA_LANG_RECORD_SUPERTYPE(), (DiagnosticContext)context, null, 8, null);
                    return;
                }
            }
            if ((object = FirAnnotationUtilsKt.getAnnotationByClassId(declaration, JvmNames.JVM_RECORD_ANNOTATION_CLASS_ID)) == null || (object = ((FirAnnotation)object).getSource()) == null) {
                return;
            }
            Object annotationSource = object;
            LanguageVersionSettings languageVersionSettings = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context.getSession());
            if (!languageVersionSettings.supportsFeature(LanguageFeature.JvmRecordSupport)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirErrors.INSTANCE.getUNSUPPORTED_FEATURE(), (Object)TuplesKt.to((Object)((Object)LanguageFeature.JvmRecordSupport), (Object)languageVersionSettings), (DiagnosticContext)context, null, 16, null);
                return;
            }
            FirClassLikeDeclaration $this$isLocal$iv = declaration;
            boolean $i$f$isLocal = false;
            if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirJvmErrors.INSTANCE.getLOCAL_JVM_RECORD(), (DiagnosticContext)context, null, 8, null);
                return;
            }
            FirMemberDeclaration $this$isInner$iv = declaration;
            boolean $i$f$isInner = false;
            if ($this$isInner$iv.getStatus().isInner()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirJvmErrors.INSTANCE.getINNER_JVM_RECORD(), (DiagnosticContext)context, null, 8, null);
                return;
            }
            FirMemberDeclaration $this$isFinal$iv = declaration;
            boolean $i$f$isFinal = false;
            Modality modality = $this$isFinal$iv.getStatus().getModality();
            if (!(modality == null ? true : (modality$iv = modality) == Modality.FINAL)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirJvmErrors.INSTANCE.getNON_FINAL_JVM_RECORD(), (DiagnosticContext)context, null, 8, null);
                return;
            }
            FirClass $this$isEnumClass$iv = declaration;
            boolean $i$f$isEnumClass = false;
            ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
            boolean $i$f$isEnumClass2 = false;
            boolean bl = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS;
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirJvmErrors.INSTANCE.getENUM_JVM_RECORD(), (DiagnosticContext)context, null, 8, null);
                return;
            }
            FirRegularClass $this$isData$iv = declaration;
            boolean $i$f$isData = false;
            if (!$this$isData$iv.getStatus().isData()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirJvmErrors.INSTANCE.getNON_DATA_CLASS_JVM_RECORD(), (DiagnosticContext)context, null, 8, null);
                return;
            }
            Object object2 = DeclarationUtilsKt.primaryConstructorIfAny(declaration, context.getSession());
            if (object2 != null && (object2 = ((FirFunctionSymbol)object2).getValueParameterSymbols()) != null) {
                Object params = object2;
                boolean bl2 = false;
                if (params.isEmpty()) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirJvmErrors.INSTANCE.getJVM_RECORD_WITHOUT_PRIMARY_CONSTRUCTOR_PARAMETERS(), (DiagnosticContext)context, null, 8, null);
                    return;
                }
                Iterable $this$forEach$iv = CollectionsKt.dropLast((List)params, (int)1);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirValueParameterSymbol param = (FirValueParameterSymbol)element$iv;
                    boolean bl3 = false;
                    if (!param.isVararg()) continue;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)param.getSource(), FirJvmErrors.INSTANCE.getJVM_RECORD_NOT_LAST_VARARG_PARAMETER(), (DiagnosticContext)context, null, 8, null);
                }
            }
            Iterable $this$forEach$iv = declaration.getDeclarations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirDeclaration decl = (FirDeclaration)element$iv;
                boolean bl4 = false;
                if (decl instanceof FirProperty) {
                    KtSourceElement ktSourceElement = decl.getSource();
                    boolean fromConstructor = Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE);
                    if (((FirProperty)decl).isVar() && fromConstructor) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)decl.getSource(), FirJvmErrors.INSTANCE.getJVM_RECORD_NOT_VAL_PARAMETER(), (DiagnosticContext)context, null, 8, null);
                        continue;
                    }
                    if (fromConstructor || !DeclarationAttributesKt.getHasBackingField((FirProperty)decl) && ((FirProperty)decl).getDelegateFieldSymbol() == null) continue;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)decl.getSource(), FirJvmErrors.INSTANCE.getFIELD_IN_JVM_RECORD(), (DiagnosticContext)context, null, 8, null);
                    continue;
                }
                if (!(decl instanceof FirField)) continue;
                FirDeclaration $this$isSynthetic$iv = decl;
                boolean $i$f$isSynthetic = false;
                if (!Intrinsics.areEqual((Object)$this$isSynthetic$iv.getOrigin(), (Object)FirDeclarationOrigin.Synthetic.INSTANCE)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)decl.getSource(), FirJvmErrors.INSTANCE.getDELEGATION_BY_IN_JVM_RECORD(), (DiagnosticContext)context, null, 8, null);
            }
            FirTypeRef firTypeRef2 = (FirTypeRef)CollectionsKt.firstOrNull(declaration.getSuperTypeRefs());
            if (firTypeRef2 == null) break block18;
            FirTypeRef typeRef = firTypeRef2;
            boolean bl5 = false;
            KtSourceElement ktSourceElement = typeRef.getSource();
            if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtRealSourceElementKind.INSTANCE)) {
                FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol(typeRef, context.getSession());
                if ((firRegularClassSymbol != null ? firRegularClassSymbol.getClassKind() : null) == ClassKind.CLASS) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirJvmErrors.INSTANCE.getJVM_RECORD_EXTENDS_CLASS(), (Object)FirTypeUtilsKt.getConeType(typeRef), (DiagnosticContext)context, null, 16, null);
                }
            }
        }
    }

    static {
        ClassId classId = ClassId.fromString("java/lang/Record");
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"fromString(\"java/lang/Record\")");
        JAVA_RECORD_CLASS_ID = classId;
    }
}

