/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.profiling;

import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URL;
import java.net.URLClassLoader;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.profiling.AsyncProfilerReflected;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0016\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/cli/common/profiling/AsyncProfilerHelper;", "", "()V", "instance", "Lorg/jetbrains/kotlin/cli/common/profiling/AsyncProfilerReflected;", "getInstance", "libPath", "", "loadAsyncProfilerClass", "Ljava/lang/Class;", "cli"})
public final class AsyncProfilerHelper {
    private static AsyncProfilerReflected instance;
    @NotNull
    public static final AsyncProfilerHelper INSTANCE;

    @NotNull
    public final AsyncProfilerReflected getInstance(@Nullable String libPath) {
        AsyncProfilerReflected asyncProfilerReflected;
        AsyncProfilerReflected asyncProfilerReflected2 = instance;
        if (asyncProfilerReflected2 != null) {
            AsyncProfilerReflected asyncProfilerReflected3;
            AsyncProfilerReflected it = asyncProfilerReflected3 = asyncProfilerReflected2;
            boolean bl = false;
            return it;
        }
        Class<?> profilerClass = this.loadAsyncProfilerClass(libPath);
        MethodHandle getInstanceHandle = MethodHandles.lookup().findStatic(profilerClass, "getInstance", MethodType.methodType(profilerClass, String.class));
        MethodHandle executeHandle = MethodHandles.lookup().findVirtual(profilerClass, "execute", MethodType.methodType(String.class, String.class));
        MethodHandle stopHandle = MethodHandles.lookup().findVirtual(profilerClass, "stop", MethodType.methodType(Void.TYPE));
        MethodHandle getVersionHandle = MethodHandles.lookup().findVirtual(profilerClass, "getVersion", MethodType.methodType(String.class));
        Object instance = getInstanceHandle.invokeWithArguments(libPath);
        AsyncProfilerReflected it = asyncProfilerReflected = new AsyncProfilerReflected(executeHandle, instance, stopHandle, getVersionHandle){
            private final MethodHandle boundExecute;
            private final MethodHandle boundStop;
            private final MethodHandle boundGetVersion;
            final /* synthetic */ MethodHandle $executeHandle;
            final /* synthetic */ Object $instance;
            final /* synthetic */ MethodHandle $stopHandle;
            final /* synthetic */ MethodHandle $getVersionHandle;

            @NotNull
            public String execute(@NotNull String command) {
                Intrinsics.checkNotNullParameter((Object)command, (String)"command");
                Object object = this.boundExecute.invokeWithArguments(command);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                return (String)object;
            }

            public void stop() {
                this.boundStop.invokeWithArguments(new Object[0]);
            }

            @NotNull
            public String getVersion() {
                Object object = this.boundGetVersion.invokeWithArguments(new Object[0]);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                return (String)object;
            }
            {
                this.$executeHandle = $captured_local_variable$0;
                this.$instance = $captured_local_variable$1;
                this.$stopHandle = $captured_local_variable$2;
                this.$getVersionHandle = $captured_local_variable$3;
                this.boundExecute = $captured_local_variable$0.bindTo($captured_local_variable$1);
                this.boundStop = $captured_local_variable$2.bindTo($captured_local_variable$1);
                this.boundGetVersion = $captured_local_variable$3.bindTo($captured_local_variable$1);
            }
        };
        boolean bl = false;
        AsyncProfilerHelper.instance = it;
        return asyncProfilerReflected;
    }

    private final Class<?> loadAsyncProfilerClass(String libPath) {
        Class<?> clazz;
        String fqName2 = "one.profiler.AsyncProfiler";
        try {
            Class<?> clazz2 = Class.forName(fqName2);
            Intrinsics.checkNotNullExpressionValue(clazz2, (String)"Class.forName(fqName)");
            clazz = clazz2;
        }
        catch (ClassNotFoundException e) {
            File directory;
            if (libPath == null) {
                throw (Throwable)e;
            }
            File file2 = directory = new File(libPath).getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"directory");
            boolean bl = file2.isDirectory();
            if (!bl) {
                boolean $i$a$-check-AsyncProfilerHelper$loadAsyncProfilerClass$22 = false;
                File $i$a$-check-AsyncProfilerHelper$loadAsyncProfilerClass$22 = directory;
                throw new IllegalStateException(((Object)$i$a$-check-AsyncProfilerHelper$loadAsyncProfilerClass$22).toString());
            }
            File apiJar = FilesKt.resolve((File)directory, (String)"async-profiler.jar");
            if (!apiJar.exists()) {
                String $i$a$-check-AsyncProfilerHelper$loadAsyncProfilerClass$22 = "To use async-profiler, either add it to the compiler classpath, or put async-profiler.jar at this path: " + apiJar;
                throw new IllegalStateException($i$a$-check-AsyncProfilerHelper$loadAsyncProfilerClass$22.toString());
            }
            URLClassLoader classLoader2 = new URLClassLoader(new URL[]{apiJar.toURI().toURL()}, null);
            Class<?> clazz3 = classLoader2.loadClass(fqName2);
            Intrinsics.checkNotNullExpressionValue(clazz3, (String)"if (libPath == null) thr\u2026ass(fqName)\n            }");
            clazz = clazz3;
        }
        return clazz;
    }

    private AsyncProfilerHelper() {
    }

    static {
        AsyncProfilerHelper asyncProfilerHelper;
        INSTANCE = asyncProfilerHelper = new AsyncProfilerHelper();
    }
}

