/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.BasePathResolver;
import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SafeJdomFactory;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PathBasedJdomXIncluder<T> {
    private static final Logger LOG = Logger.getInstance(PathBasedJdomXIncluder.class);
    public static final PathResolver<Path> DEFAULT_PATH_RESOLVER = new BasePathResolver();
    private final DescriptorListLoadingContext context;
    private final PathResolver<T> pathResolver;

    private PathBasedJdomXIncluder(@NotNull DescriptorListLoadingContext context, @NotNull PathResolver<T> pathResolver) {
        if (context == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(0);
        }
        if (pathResolver == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(1);
        }
        this.context = context;
        this.pathResolver = pathResolver;
    }

    public static <T> void resolveNonXIncludeElement(@NotNull Element original, @Nullable Path base, @NotNull DescriptorListLoadingContext context, @NotNull PathResolver<T> pathResolver) {
        if (original == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(2);
        }
        if (context == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(3);
        }
        if (pathResolver == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(!PathBasedJdomXIncluder.isIncludeElement(original));
        super.resolveNonXIncludeElement(original, pathResolver.createNewStack(base));
    }

    private static boolean isIncludeElement(Element element) {
        return element.getName().equals("include") && element.getNamespace().equals(JDOMUtil.XINCLUDE_NAMESPACE);
    }

    @NotNull
    private List<Element> resolveXIncludeElement(@NotNull Element linkElement, @NotNull List<T> bases, @Nullable ArrayList<Element> result2) {
        String xpointer;
        Element remoteParsed;
        String relativePath;
        if (linkElement == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(5);
        }
        if (bases == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(6);
        }
        if ((relativePath = linkElement.getAttributeValue("href")) == null) {
            throw new RuntimeException("Missing href attribute");
        }
        String parseAttribute = linkElement.getAttributeValue("parse");
        if (parseAttribute != null) {
            LOG.assertTrue(parseAttribute.equals("xml"), parseAttribute + " is not a legal value for the parse attribute");
        }
        if ((remoteParsed = this.parseRemote(bases, relativePath, linkElement)) != null && (xpointer = linkElement.getAttributeValue("xpointer")) != null) {
            remoteParsed = PathBasedJdomXIncluder.extractNeededChildren(remoteParsed, xpointer);
        }
        if (remoteParsed == null) {
            List<Element> list2 = result2 == null ? Collections.emptyList() : result2;
            if (list2 == null) {
                PathBasedJdomXIncluder.$$$reportNull$$$0(7);
            }
            return list2;
        }
        if (result2 == null) {
            result2 = new ArrayList(remoteParsed.getContentSize());
        } else {
            result2.ensureCapacity(result2.size() + remoteParsed.getContentSize());
        }
        Iterator<Content> iterator2 = remoteParsed.getContent().iterator();
        while (iterator2.hasNext()) {
            Content content2 = iterator2.next();
            if (!(content2 instanceof Element)) continue;
            iterator2.remove();
            Element element = (Element)content2;
            if (PathBasedJdomXIncluder.isIncludeElement(element)) {
                this.resolveXIncludeElement(element, bases, result2);
                continue;
            }
            this.resolveNonXIncludeElement(element, bases);
            result2.add(element);
        }
        ArrayList<Element> arrayList = result2;
        if (arrayList == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Nullable
    private static Element extractNeededChildren(@NotNull Element remoteElement, @NotNull String xpointer) {
        Matcher matcher2;
        if (remoteElement == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(9);
        }
        if (xpointer == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(10);
        }
        if (!(matcher2 = JDOMUtil.XPOINTER_PATTERN.matcher(xpointer)).matches()) {
            throw new RuntimeException("Unsupported XPointer: " + xpointer);
        }
        String pointer = matcher2.group(1);
        if (!(matcher2 = JDOMUtil.CHILDREN_PATTERN.matcher(pointer)).matches()) {
            throw new RuntimeException("Unsupported pointer: " + pointer);
        }
        Element result2 = remoteElement;
        if (!result2.getName().equals(matcher2.group(1))) {
            return null;
        }
        String subTagName = matcher2.group(2);
        if (subTagName != null) {
            result2 = result2.getChild(subTagName.substring(1));
            assert (result2 != null);
        }
        return result2;
    }

    @Nullable
    private Element parseRemote(@NotNull List<T> bases, @NotNull String relativePath, @NotNull Element referrerElement) {
        if (bases == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(11);
        }
        if (relativePath == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(12);
        }
        if (referrerElement == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(13);
        }
        int baseStackSize = bases.size();
        try {
            Element root2;
            String base = referrerElement.getAttributeValue("base", Namespace.XML_NAMESPACE);
            if (base != null) {
                LOG.error("Do not use xml:base attribute: " + base);
            }
            if (PathBasedJdomXIncluder.isIncludeElement(root2 = this.pathResolver.resolvePath(bases, relativePath, base, this.context.getXmlFactory()))) {
                throw new UnsupportedOperationException("root tag of remote cannot be include");
            }
            this.resolveNonXIncludeElement(root2, bases);
            Element element = root2;
            return element;
        }
        catch (JDOMException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            Element fallbackElement = referrerElement.getChild("fallback", referrerElement.getNamespace());
            if (fallbackElement != null) {
                Element element = null;
                return element;
            }
            if (this.context.ignoreMissingInclude) {
                LOG.info(relativePath + " include ignored: " + e.getMessage());
                Element element = null;
                return element;
            }
            throw new RuntimeException(e);
        }
        finally {
            if (baseStackSize != bases.size()) {
                bases.remove(bases.size() - 1);
            }
        }
    }

    private void resolveNonXIncludeElement(@NotNull Element original, @NotNull List<T> bases) {
        if (original == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(14);
        }
        if (bases == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(15);
        }
        List<Content> contentList = original.getContent();
        for (int i = contentList.size() - 1; i >= 0; --i) {
            Content content2 = contentList.get(i);
            if (!(content2 instanceof Element)) continue;
            Element element = (Element)content2;
            if (PathBasedJdomXIncluder.isIncludeElement(element)) {
                original.setContent(i, this.resolveXIncludeElement(element, bases, null));
                continue;
            }
            this.resolveNonXIncludeElement(element, bases);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathResolver";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkElement";
                break;
            }
            case 6: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bases";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PathBasedJdomXIncluder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xpointer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referrerElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PathBasedJdomXIncluder";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveXIncludeElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveNonXIncludeElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveXIncludeElement";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "extractNeededChildren";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseRemote";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static interface PathResolver<T> {
        @NotNull
        public Element resolvePath(@NotNull List<T> var1, @NotNull String var2, @Nullable String var3, @NotNull SafeJdomFactory var4) throws IOException, JDOMException;

        @NotNull
        public Element resolvePath(@NotNull Path var1, @NotNull String var2, @NotNull SafeJdomFactory var3) throws IOException, JDOMException;

        @NotNull
        public List<T> createNewStack(@Nullable Path var1);
    }
}

