/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.TrackedLookupMap;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.BasicMapsOwner;
import org.jetbrains.kotlin.incremental.storage.FileToIdMap;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;
import org.jetbrains.kotlin.incremental.storage.IdToFileMap;
import org.jetbrains.kotlin.incremental.storage.LookupMap;
import org.jetbrains.kotlin.incremental.storage.LookupSymbolKey;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 82\u00020\u0001:\u00018B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ(\u0010$\u001a\u00020%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)0'2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020)0\u0010J\u0010\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00020\u0003H\u0002J\b\u0010-\u001a\u00020%H\u0016J\u0014\u0010.\u001a\u00020)2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020(0\u0010J\u0010\u0010/\u001a\u00020%2\u0006\u00100\u001a\u00020\u0007H\u0016J\u0006\u00101\u001a\u00020%J\u0014\u00102\u001a\b\u0012\u0004\u0012\u00020)0\u001c2\u0006\u00103\u001a\u00020(J\b\u00104\u001a\u00020%H\u0002J\u0014\u00105\u001a\u00020%2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000307R\u0016\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0013R\u000e\u0010#\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/incremental/LookupStorage;", "Lorg/jetbrains/kotlin/incremental/storage/BasicMapsOwner;", "targetDataDir", "Ljava/io/File;", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "storeFullFqNames", "", "trackChanges", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;ZZ)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "addedLookupSymbols", "", "Lorg/jetbrains/kotlin/incremental/storage/LookupSymbolKey;", "getAddedLookupSymbols", "()Ljava/util/Set;", "countersFile", "fileToId", "Lorg/jetbrains/kotlin/incremental/storage/FileToIdMap;", "idToFile", "Lorg/jetbrains/kotlin/incremental/storage/IdToFileMap;", "lookupMap", "Lorg/jetbrains/kotlin/incremental/TrackedLookupMap;", "lookupSymbols", "", "getLookupSymbols", "()Ljava/util/Collection;", "oldSize", "", "removedLookupSymbols", "getRemovedLookupSymbols", "size", "addAll", "", "lookups", "Lcom/intellij/util/containers/MultiMap;", "Lorg/jetbrains/kotlin/incremental/LookupSymbol;", "", "allPaths", "addFileIfNeeded", "file", "clean", "dump", "flush", "memoryCachesOnly", "forceGC", "get", "lookupSymbol", "removeGarbageForTests", "removeLookupsFrom", "files", "Lkotlin/sequences/Sequence;", "Companion", "kotlin-build-common"})
public class LookupStorage
extends BasicMapsOwner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean trackChanges;
    @NotNull
    private final Logger LOG;
    @NotNull
    private final File countersFile;
    @NotNull
    private final IdToFileMap idToFile;
    @NotNull
    private final FileToIdMap fileToId;
    @NotNull
    private final TrackedLookupMap lookupMap;
    private volatile int size;
    private int oldSize;
    private static final double DELETED_TO_SIZE_TRESHOLD = 0.5;
    private static final int MINIMUM_GARBAGE_COLLECTIBLE_SIZE = 10000;

    public LookupStorage(@NotNull File targetDataDir, @NotNull FileToPathConverter pathConverter, boolean storeFullFqNames, boolean trackChanges) {
        Intrinsics.checkNotNullParameter((Object)targetDataDir, (String)"targetDataDir");
        Intrinsics.checkNotNullParameter((Object)pathConverter, (String)"pathConverter");
        super(targetDataDir);
        this.trackChanges = trackChanges;
        Logger logger = Logger.getInstance("#org.jetbrains.kotlin.jps.build.KotlinBuilder");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(\"#org.jetbra\u2026jps.build.KotlinBuilder\")");
        this.LOG = logger;
        this.countersFile = this.getStorageFile("counters");
        this.idToFile = (IdToFileMap)this.registerMap((BasicMap)new IdToFileMap(this.getStorageFile("id-to-file"), pathConverter));
        this.fileToId = (FileToIdMap)this.registerMap((BasicMap)new FileToIdMap(this.getStorageFile("file-to-id"), pathConverter));
        this.lookupMap = new TrackedLookupMap((LookupMap)this.registerMap((BasicMap)new LookupMap(this.getStorageFile("lookups"), storeFullFqNames)), this.trackChanges);
        try {
            if (this.countersFile.exists()) {
                List lines = FilesKt.readLines$default((File)this.countersFile, null, (int)1, null);
                Object object = (String)kotlin.collections.CollectionsKt.firstOrNull((List)lines);
                if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
                    throw new IOException(this.countersFile + " exists, but it is empty. Counters file is corrupted");
                }
                this.oldSize = this.size = ((Integer)object).intValue();
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Could not read " + this.countersFile, e);
        }
    }

    public /* synthetic */ LookupStorage(File file2, FileToPathConverter fileToPathConverter, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        this(file2, fileToPathConverter, bl, bl2);
    }

    @NotNull
    public final Logger getLOG() {
        return this.LOG;
    }

    @NotNull
    public final Set<LookupSymbolKey> getAddedLookupSymbols() {
        LookupStorage $this$_get_addedLookupSymbols__u24lambda_u2d1 = this;
        boolean bl = false;
        if (!$this$_get_addedLookupSymbols__u24lambda_u2d1.trackChanges) {
            boolean bl2 = false;
            String string2 = "trackChanges is not enabled";
            throw new IllegalStateException(string2.toString());
        }
        Set<LookupSymbolKey> set = $this$_get_addedLookupSymbols__u24lambda_u2d1.lookupMap.getAddedKeys();
        Intrinsics.checkNotNull(set);
        return set;
    }

    @NotNull
    public final Set<LookupSymbolKey> getRemovedLookupSymbols() {
        LookupStorage $this$_get_removedLookupSymbols__u24lambda_u2d3 = this;
        boolean bl = false;
        if (!$this$_get_removedLookupSymbols__u24lambda_u2d3.trackChanges) {
            boolean bl2 = false;
            String string2 = "trackChanges is not enabled";
            throw new IllegalStateException(string2.toString());
        }
        Set<LookupSymbolKey> set = $this$_get_removedLookupSymbols__u24lambda_u2d3.lookupMap.getRemovedKeys();
        Intrinsics.checkNotNull(set);
        return set;
    }

    @NotNull
    public final Collection<LookupSymbolKey> getLookupSymbols() {
        return this.lookupMap.getKeys();
    }

    @NotNull
    public final synchronized Collection<String> get(@NotNull LookupSymbol lookupSymbol) {
        Intrinsics.checkNotNullParameter((Object)lookupSymbol, (String)"lookupSymbol");
        LookupSymbolKey key = new LookupSymbolKey(lookupSymbol.getName(), lookupSymbol.getScope());
        Collection<Integer> collection = this.lookupMap.get(key);
        if (collection == null) {
            return SetsKt.emptySet();
        }
        Collection<Integer> fileIds = collection;
        Set paths = new LinkedHashSet();
        Set filtered = new LinkedHashSet();
        Iterator<Integer> iterator2 = fileIds.iterator();
        while (iterator2.hasNext()) {
            int fileId = ((Number)iterator2.next()).intValue();
            File file2 = this.idToFile.get(fileId);
            String path2 = file2 != null ? file2.getPath() : null;
            if (path2 == null) continue;
            paths.add(path2);
            filtered.add(fileId);
        }
        if (this.size > MINIMUM_GARBAGE_COLLECTIBLE_SIZE && (double)filtered.size() / (double)fileIds.size() < DELETED_TO_SIZE_TRESHOLD) {
            this.lookupMap.set(key, filtered);
        }
        return paths;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void addAll(@NotNull MultiMap<LookupSymbol, String> lookups, @NotNull Set<String> allPaths) {
        Intrinsics.checkNotNullParameter(lookups, (String)"lookups");
        Intrinsics.checkNotNullParameter(allPaths, (String)"allPaths");
        Map pathToId2 = CollectionsKt.keysToMap(kotlin.collections.CollectionsKt.sorted((Iterable)allPaths), (Function1)new Function1<String, Integer>(this){
            final /* synthetic */ LookupStorage this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return LookupStorage.access$addFileIfNeeded(this.this$0, new File(it));
            }
        });
        Set<LookupSymbol> set = lookups.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"lookups.keySet()");
        for (LookupSymbol lookupSymbol : kotlin.collections.CollectionsKt.sorted((Iterable)set)) {
            void $this$mapTo$iv;
            Collection<String> paths;
            LookupSymbolKey key = new LookupSymbolKey(lookupSymbol.getName(), lookupSymbol.getScope());
            Intrinsics.checkNotNullExpressionValue(lookups.get(lookupSymbol), (String)"lookups[lookupSymbol]");
            Iterable iterable = paths;
            Collection destination$iv = new TreeSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                String string2 = (String)item$iv;
                Collection collection = destination$iv;
                boolean bl = false;
                Object v = pathToId2.get(it);
                Intrinsics.checkNotNull(v);
                collection.add(((Number)v).intValue());
            }
            TreeSet fileIds = (TreeSet)destination$iv;
            this.lookupMap.append(key, fileIds);
        }
    }

    public final synchronized void removeLookupsFrom(@NotNull Sequence<? extends File> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        for (File file2 : files2) {
            Integer n = this.fileToId.get(file2);
            if (n == null) {
                continue;
            }
            int id = n;
            this.idToFile.remove(id);
            this.fileToId.remove(file2);
        }
    }

    @Override
    public synchronized void clean() {
        if (this.countersFile.exists()) {
            this.countersFile.delete();
        }
        this.size = 0;
        super.clean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void flush(boolean memoryCachesOnly) {
        try {
            if (this.size != this.oldSize && this.size > 0) {
                if (!this.countersFile.exists()) {
                    this.countersFile.getParentFile().mkdirs();
                    this.countersFile.createNewFile();
                }
                FilesKt.writeText$default((File)this.countersFile, (String)(this.size + "\n0"), null, (int)2, null);
            }
        }
        finally {
            super.flush(memoryCachesOnly);
        }
    }

    private final int addFileIfNeeded(File file2) {
        Integer existing = this.fileToId.get(file2);
        if (existing != null) {
            return existing;
        }
        int n = this.size;
        this.size = n + 1;
        int id = n;
        this.fileToId.set(file2, id);
        this.idToFile.set(id, file2);
        return id;
    }

    /*
     * WARNING - void declaration
     */
    private final void removeGarbageForTests() {
        for (LookupSymbolKey hash : this.lookupMap.getKeys()) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Collection<Integer> collection = this.lookupMap.get(hash);
            Intrinsics.checkNotNull(collection);
            Iterator<LookupSymbolKey> iterator2 = collection;
            LookupSymbolKey lookupSymbolKey = hash;
            TrackedLookupMap trackedLookupMap = this.lookupMap;
            boolean $i$f$filter = false;
            void var5_6 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                int it = ((Number)element$iv$iv).intValue();
                boolean bl = false;
                if (!this.idToFile.contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            trackedLookupMap.set(lookupSymbolKey, kotlin.collections.CollectionsKt.toSet((Iterable)list2));
        }
        Map<File, Integer> oldFileToId = this.fileToId.toMap();
        HashMap oldIdToNewId = new HashMap(oldFileToId.size());
        this.idToFile.clean();
        this.fileToId.clean();
        this.size = 0;
        Object $this$sortedBy$iv2 = oldFileToId.entrySet();
        boolean $i$f$sortedBy = false;
        for (Object $this$sortedBy$iv2 : kotlin.collections.CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((File)it.getKey()).getPath());
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((File)it.getKey()).getPath())));
            }
        })) {
            Object element$iv$iv;
            File file2 = (File)$this$sortedBy$iv2.getKey();
            int oldId = ((Number)$this$sortedBy$iv2.getValue()).intValue();
            int newId = this.addFileIfNeeded(file2);
            element$iv$iv = oldId;
            Integer it = newId;
            ((Map)oldIdToNewId).put(element$iv$iv, it);
        }
        for (LookupSymbolKey lookup2 : this.lookupMap.getKeys()) {
            void $this$mapNotNullTo$iv$iv;
            Collection<Integer> collection = this.lookupMap.get(lookup2);
            Intrinsics.checkNotNull(collection);
            Iterable $this$mapNotNull$iv = collection;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Integer it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl = false;
                int it = ((Number)element$iv$iv).intValue();
                boolean bl2 = false;
                if ((Integer)oldIdToNewId.get(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Set fileIds = kotlin.collections.CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            if (fileIds.isEmpty()) {
                this.lookupMap.remove(lookup2);
                continue;
            }
            this.lookupMap.set(lookup2, fileIds);
        }
    }

    public final void forceGC() {
        this.removeGarbageForTests();
        this.flush(false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String dump(@NotNull Set<LookupSymbol> lookupSymbols2) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(lookupSymbols2, (String)"lookupSymbols");
        this.flush(false);
        StringBuilder sb = new StringBuilder();
        Printer p = new Printer(sb);
        Object[] objectArray = new Object[]{"====== File to id map"};
        p.println(objectArray);
        objectArray = new Object[]{this.fileToId.dump()};
        p.println(objectArray);
        objectArray = new Object[]{"====== Id to file map"};
        p.println(objectArray);
        objectArray = new Object[]{this.idToFile.dump()};
        p.println(objectArray);
        Iterable $this$groupBy$iv = lookupSymbols2;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            LookupSymbol it = (LookupSymbol)element$iv$iv;
            boolean bl = false;
            LookupSymbolKey key$iv$iv = new LookupSymbolKey(it.getName(), it.getScope());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map lookupsStrings = destination$iv$iv;
        for (LookupSymbolKey lookup2 : kotlin.collections.CollectionsKt.sorted((Iterable)this.lookupMap.getKeys())) {
            void $this$mapTo$iv$iv;
            Collection<Integer> fileIds;
            String string2;
            Iterable iterable2;
            Iterable destination$iv$iv2;
            Intrinsics.checkNotNull(this.lookupMap.get(lookup2));
            if (lookupsStrings.containsKey(lookup2)) {
                void $this$mapTo$iv$iv2;
                Object v = lookupsStrings.get(lookup2);
                Intrinsics.checkNotNull(v);
                Iterable $this$map$iv = (Iterable)v;
                boolean $i$f$map = false;
                Iterable element$iv$iv = $this$map$iv;
                destination$iv$iv2 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    LookupSymbol $i$f$getOrPut = (LookupSymbol)item$iv$iv;
                    iterable2 = destination$iv$iv2;
                    boolean bl = false;
                    iterable2.add(it.getScope() + '#' + it.getName());
                }
                string2 = kotlin.collections.CollectionsKt.joinToString$default((Iterable)kotlin.collections.CollectionsKt.sorted((Iterable)((List)destination$iv$iv2)), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            } else {
                string2 = lookup2.toString();
            }
            String key = string2;
            Iterable $this$map$iv = fileIds;
            boolean $i$f$map = false;
            destination$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                int bl = ((Number)item$iv$iv).intValue();
                iterable2 = destination$iv$iv3;
                boolean bl3 = false;
                iterable2.add(String.valueOf((int)it));
            }
            String value2 = kotlin.collections.CollectionsKt.joinToString$default((Iterable)kotlin.collections.CollectionsKt.sorted((Iterable)((List)destination$iv$iv3)), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            Object[] objectArray2 = new Object[]{key + " -> " + value2};
            p.println(objectArray2);
        }
        String string3 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sb.toString()");
        return string3;
    }

    public static final /* synthetic */ int access$addFileIfNeeded(LookupStorage $this, File file2) {
        return $this.addFileIfNeeded(file2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/incremental/LookupStorage$Companion;", "", "()V", "DELETED_TO_SIZE_TRESHOLD", "", "MINIMUM_GARBAGE_COLLECTIBLE_SIZE", "", "kotlin-build-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

