/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorNonRoot;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverloadChecker;
import org.jetbrains.kotlin.resolve.OverloadFilter;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u001e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0013H\u0002J\u0016\u0010\u0019\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0013H\u0002J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002JS\u0010\u001c\u001a\u00020\u000e2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001a0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00132\u0006\u0010\u0004\u001a\u00020\u00052\u001e\u0010\"\u001a\u001a\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00130#H\u0082\bJ\u001c\u0010&\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00180\u001e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00132\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0013H\u0002J?\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00132\u0006\u0010*\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u00052\u001e\u0010\"\u001a\u001a\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00130#H\u0082\bJ\"\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00130\u00132\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0013H\u0002J$\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001a0\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020!2\u0006\u00100\u001a\u00020!H\u0002J\u0018\u00101\u001a\u00020.2\u0006\u0010/\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u001aH\u0002J\u0018\u00102\u001a\u00020.2\u0006\u00103\u001a\u00020!2\u0006\u00104\u001a\u00020!H\u0002J\u0018\u00105\u001a\u00020.2\u0006\u0010/\u001a\u00020!2\u0006\u00100\u001a\u00020!H\u0002J\u0016\u00106\u001a\u00020\u000e2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0013H\u0002J\f\u00108\u001a\u00020.*\u00020!H\u0002J\f\u00109\u001a\u00020.*\u00020!H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/resolve/OverloadResolver;", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "overloadFilter", "Lorg/jetbrains/kotlin/resolve/OverloadFilter;", "overloadChecker", "Lorg/jetbrains/kotlin/resolve/OverloadChecker;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/OverloadFilter;Lorg/jetbrains/kotlin/resolve/OverloadChecker;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "mainFunctionDetector", "Lorg/jetbrains/kotlin/idea/MainFunctionDetector;", "checkOverloads", "", "c", "Lorg/jetbrains/kotlin/resolve/BodiesResolveContext;", "checkOverloadsInClass", "members", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "nestedClassConstructors", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkOverloadsInPackage", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorNonRoot;", "checkOverloadsInPackages", "collectModulePackageMembersWithSameName", "packageMembersByName", "Lcom/intellij/util/containers/MultiMap;", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "interestingDescriptors", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getMembersByName", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "Lorg/jetbrains/kotlin/name/Name;", "findConstructorsInNestedClassesAndTypeAliases", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "findRedeclarations", "getModulePackageMembersWithSameName", "descriptor", "getPossibleRedeclarationGroups", "groupModulePackageMembersByFqName", "isConstructorsOfDifferentRedeclaredClasses", "", "member1", "member2", "isDefinitionsForDifferentPlatforms", "isExpectDeclarationAndDefinition", "declaration", "definition", "isTopLevelMainInDifferentFiles", "reportRedeclarations", "redeclarations", "isPrivate", "isSynthesized", "frontend"})
public final class OverloadResolver {
    private final MainFunctionDetector mainFunctionDetector;
    private final BindingTrace trace;
    private final OverloadFilter overloadFilter;
    private final OverloadChecker overloadChecker;

    public final void checkOverloads(@NotNull BodiesResolveContext c) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        MultiMap<ClassDescriptor, FunctionDescriptor> inClasses = this.findConstructorsInNestedClassesAndTypeAliases(c);
        Iterator<ClassDescriptorWithResolutionScopes> iterator2 = c.getDeclaredClasses().values().iterator();
        while (iterator2.hasNext()) {
            ClassDescriptorWithResolutionScopes value;
            ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = value = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptorWithResolutionScopes, (String)"value");
            Collection<FunctionDescriptor> collection = inClasses.get(value);
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"inClasses.get(value)");
            this.checkOverloadsInClass(classDescriptorWithResolutionScopes, collection);
        }
        this.checkOverloadsInPackages(c);
    }

    private final MultiMap<ClassDescriptor, FunctionDescriptor> findConstructorsInNestedClassesAndTypeAliases(BodiesResolveContext c) {
        DeclarationDescriptor containingDeclaration;
        MultiMap<ClassDescriptor, FunctionDescriptor> multiMap = MultiMap.create();
        Intrinsics.checkExpressionValueIsNotNull(multiMap, (String)"MultiMap.create<ClassDes\u2026or, FunctionDescriptor>()");
        MultiMap<ClassDescriptor, FunctionDescriptor> constructorsByOuterClass = multiMap;
        Iterator<ClassifierDescriptorWithTypeParameters> iterator2 = c.getDeclaredClasses().values().iterator();
        while (iterator2.hasNext()) {
            ClassDescriptorWithResolutionScopes klass2;
            ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = klass2 = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptorWithResolutionScopes, (String)"klass");
            ClassKind classKind = classDescriptorWithResolutionScopes.getKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)classKind), (String)"klass.kind");
            if (classKind.isSingleton()) continue;
            Name name = klass2.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"klass.name");
            if (name.isSpecial()) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)klass2.getContainingDeclaration(), (String)"klass.containingDeclaration");
            if (containingDeclaration instanceof ScriptDescriptor) continue;
            if (containingDeclaration instanceof ClassDescriptor) {
                constructorsByOuterClass.putValues((ClassDescriptor)containingDeclaration, klass2.getConstructors());
                continue;
            }
            if (containingDeclaration instanceof FunctionDescriptor || containingDeclaration instanceof PropertyDescriptor || containingDeclaration instanceof PackageFragmentDescriptor) continue;
            throw (Throwable)new IllegalStateException("Illegal class container: " + containingDeclaration);
        }
        iterator2 = c.getTypeAliases().values().iterator();
        while (iterator2.hasNext()) {
            TypeAliasDescriptor typeAlias;
            TypeAliasDescriptor typeAliasDescriptor = typeAlias = (TypeAliasDescriptor)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeAliasDescriptor, (String)"typeAlias");
            Intrinsics.checkExpressionValueIsNotNull((Object)typeAliasDescriptor.getContainingDeclaration(), (String)"typeAlias.containingDeclaration");
            if (!(containingDeclaration instanceof ClassDescriptor)) continue;
            constructorsByOuterClass.putValues((ClassDescriptor)containingDeclaration, typeAlias.getConstructors());
        }
        return constructorsByOuterClass;
    }

    private final void checkOverloadsInPackages(BodiesResolveContext c) {
        MultiMap<FqNameUnsafe, DeclarationDescriptorNonRoot> membersByName = this.groupModulePackageMembersByFqName(c, this.overloadFilter);
        for (Map.Entry<FqNameUnsafe, Collection<DeclarationDescriptorNonRoot>> e : membersByName.entrySet()) {
            Collection<DeclarationDescriptorNonRoot> collection = e.getValue();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"e.value");
            this.checkOverloadsInPackage(collection);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final MultiMap<FqNameUnsafe, DeclarationDescriptorNonRoot> groupModulePackageMembersByFqName(BodiesResolveContext c, OverloadFilter overloadFilter) {
        List possibleOverloads$iv$iv;
        ClassifierDescriptor classifier2;
        Name name;
        Object scope;
        Object containingPackageScope$iv$iv;
        ModuleDescriptor containingModule$iv$iv;
        DeclarationDescriptor containingPackage$iv$iv;
        boolean $i$f$getModulePackageMembersWithSameName;
        OverloadResolver this_$iv$iv;
        OverloadResolver this_$iv;
        FqNameUnsafe descriptorFQN$iv;
        MultiMap<FqNameUnsafe, DeclarationDescriptorNonRoot> packageMembersByName = new MultiMap<FqNameUnsafe, DeclarationDescriptorNonRoot>();
        OverloadResolver overloadResolver = this;
        Collection<SimpleFunctionDescriptor> collection = c.getFunctions().values();
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Collection<org.jetbrains.kotlin.descriptors.DeclarationDescriptor>");
        }
        Collection<PropertyDescriptor> interestingDescriptors$iv = CollectionsKt.plus((Collection)CollectionsKt.plus(collection, (Iterable)c.getDeclaredClasses().values()), (Iterable)c.getTypeAliases().values());
        boolean $i$f$collectModulePackageMembersWithSameName = false;
        boolean bl = false;
        HashSet<FqNameUnsafe> observedFQNs$iv = new HashSet<FqNameUnsafe>();
        for (DeclarationDescriptor declarationDescriptor : interestingDescriptors$iv) {
            Collection<DeclarationDescriptorNonRoot> collection2;
            if (!(declarationDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)DescriptorUtils.getFqName(declarationDescriptor), (String)"DescriptorUtils.getFqName(descriptor)");
            if (observedFQNs$iv.contains(descriptorFQN$iv)) continue;
            observedFQNs$iv.add(descriptorFQN$iv);
            this_$iv$iv = this_$iv;
            $i$f$getModulePackageMembersWithSameName = false;
            containingPackage$iv$iv = declarationDescriptor.getContainingDeclaration();
            if (!(containingPackage$iv$iv instanceof PackageFragmentDescriptor)) {
                throw (Throwable)((Object)new AssertionError((Object)(declarationDescriptor + " is not a top-level package member")));
            }
            if (DescriptorUtils.getContainingModuleOrNull(declarationDescriptor) == null) {
                DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
                if (declarationDescriptor2 instanceof CallableMemberDescriptor) {
                    collection2 = CollectionsKt.listOf((Object)declarationDescriptor);
                } else {
                    if (!(declarationDescriptor2 instanceof ClassDescriptor)) throw (Throwable)((Object)new AssertionError((Object)("Unexpected descriptor kind: " + declarationDescriptor)));
                    Collection<ClassConstructorDescriptor> collection3 = ((ClassDescriptor)declarationDescriptor).getConstructors();
                    collection2 = collection3;
                    Intrinsics.checkExpressionValueIsNotNull(collection3, (String)"descriptor.constructors");
                }
            } else {
                void $this$filterTo$iv$iv$iv$iv;
                Collection collection4;
                Intrinsics.checkExpressionValueIsNotNull((Object)containingModule$iv$iv, (String)"DescriptorUtils.getConta\u2026: $descriptor\")\n        }");
                containingPackageScope$iv$iv = containingModule$iv$iv.getPackage(((PackageFragmentDescriptor)containingPackage$iv$iv).getFqName()).getMemberScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor.getName(), (String)"descriptor.name");
                scope = containingPackageScope$iv$iv;
                boolean bl2 = false;
                Collection functions2 = scope.getContributedFunctions(name, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
                ClassifierDescriptor classifierDescriptor = classifier2 = scope.getContributedClassifier(name, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
                if (classifierDescriptor instanceof ClassDescriptor) {
                    ClassKind classKind = ((ClassDescriptor)classifier2).getKind();
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)classKind), (String)"classifier.kind");
                    if (!classKind.isSingleton()) {
                        Collection<ClassConstructorDescriptor> collection5 = ((ClassDescriptor)classifier2).getConstructors();
                        Intrinsics.checkExpressionValueIsNotNull(collection5, (String)"classifier.constructors");
                        collection4 = CollectionsKt.plus((Collection)functions2, (Iterable)collection5);
                    } else {
                        collection4 = functions2;
                    }
                } else {
                    collection4 = classifierDescriptor instanceof TypeAliasDescriptor ? (Collection)CollectionsKt.plus(functions2, (Iterable)((TypeAliasDescriptor)classifier2).getConstructors()) : functions2;
                }
                Iterable $this$filter$iv$iv$iv = collection4;
                boolean $i$f$filter2 = false;
                Iterable iterable = $this$filter$iv$iv$iv;
                Collection destination$iv$iv$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv$iv$iv : $this$filterTo$iv$iv$iv$iv) {
                    DeclarationDescriptorNonRoot it$iv$iv = (DeclarationDescriptorNonRoot)element$iv$iv$iv$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)DescriptorUtils.getContainingModule(it$iv$iv), (Object)containingModule$iv$iv)) continue;
                    destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
                }
                possibleOverloads$iv$iv = (List)destination$iv$iv$iv$iv;
                collection2 = overloadFilter.filterPackageMemberOverloads(possibleOverloads$iv$iv);
            }
            Collection<ClassConstructorDescriptor> packageMembersWithSameName$iv = collection2;
            packageMembersByName.putValues(descriptorFQN$iv, packageMembersWithSameName$iv);
        }
        this_$iv = this;
        interestingDescriptors$iv = c.getProperties().values();
        $i$f$collectModulePackageMembersWithSameName = false;
        boolean bl4 = false;
        observedFQNs$iv = new HashSet();
        for (DeclarationDescriptor declarationDescriptor : interestingDescriptors$iv) {
            Collection<DeclarationDescriptorNonRoot> collection6;
            if (!(declarationDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)DescriptorUtils.getFqName(declarationDescriptor), (String)"DescriptorUtils.getFqName(descriptor)");
            if (observedFQNs$iv.contains(descriptorFQN$iv)) continue;
            observedFQNs$iv.add(descriptorFQN$iv);
            this_$iv$iv = this_$iv;
            $i$f$getModulePackageMembersWithSameName = false;
            containingPackage$iv$iv = declarationDescriptor.getContainingDeclaration();
            if (!(containingPackage$iv$iv instanceof PackageFragmentDescriptor)) {
                throw (Throwable)((Object)new AssertionError((Object)(declarationDescriptor + " is not a top-level package member")));
            }
            if (DescriptorUtils.getContainingModuleOrNull(declarationDescriptor) == null) {
                containingPackageScope$iv$iv = declarationDescriptor;
                if (containingPackageScope$iv$iv instanceof CallableMemberDescriptor) {
                    collection6 = CollectionsKt.listOf((Object)declarationDescriptor);
                } else {
                    if (!(containingPackageScope$iv$iv instanceof ClassDescriptor)) throw (Throwable)((Object)new AssertionError((Object)("Unexpected descriptor kind: " + declarationDescriptor)));
                    Collection<ClassConstructorDescriptor> collection7 = ((ClassDescriptor)declarationDescriptor).getConstructors();
                    collection6 = collection7;
                    Intrinsics.checkExpressionValueIsNotNull(collection7, (String)"descriptor.constructors");
                }
            } else {
                void $this$filterTo$iv$iv$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)containingModule$iv$iv, (String)"DescriptorUtils.getConta\u2026: $descriptor\")\n        }");
                containingPackageScope$iv$iv = containingModule$iv$iv.getPackage(((PackageFragmentDescriptor)containingPackage$iv$iv).getFqName()).getMemberScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor.getName(), (String)"descriptor.name");
                scope = containingPackageScope$iv$iv;
                boolean bl5 = false;
                Collection<? extends PropertyDescriptor> variables = scope.getContributedVariables(name, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
                classifier2 = scope.getContributedClassifier(name, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
                Iterable $this$filter$iv$iv$iv = CollectionsKt.plus(variables, (Iterable)CollectionsKt.listOfNotNull((Object)classifier2));
                boolean $i$f$filter = false;
                Iterable $i$f$filter2 = $this$filter$iv$iv$iv;
                Collection destination$iv$iv$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv$iv$iv : $this$filterTo$iv$iv$iv$iv) {
                    DeclarationDescriptorNonRoot it$iv$iv = (DeclarationDescriptorNonRoot)element$iv$iv$iv$iv;
                    boolean bl6 = false;
                    if (!Intrinsics.areEqual((Object)DescriptorUtils.getContainingModule(it$iv$iv), (Object)containingModule$iv$iv)) continue;
                    destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
                }
                possibleOverloads$iv$iv = (List)destination$iv$iv$iv$iv;
                collection6 = overloadFilter.filterPackageMemberOverloads(possibleOverloads$iv$iv);
            }
            Collection<ClassConstructorDescriptor> packageMembersWithSameName$iv = collection6;
            packageMembersByName.putValues(descriptorFQN$iv, packageMembersWithSameName$iv);
        }
        return packageMembersByName;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<DeclarationDescriptorNonRoot> getModulePackageMembersWithSameName(DeclarationDescriptor descriptor2, OverloadFilter overloadFilter, Function2<? super MemberScope, ? super Name, ? extends Collection<? extends DeclarationDescriptorNonRoot>> getMembersByName) {
        void $this$filterTo$iv$iv;
        int $i$f$getModulePackageMembersWithSameName = 0;
        DeclarationDescriptor containingPackage = descriptor2.getContainingDeclaration();
        if (!(containingPackage instanceof PackageFragmentDescriptor)) {
            throw (Throwable)((Object)new AssertionError((Object)(descriptor2 + " is not a top-level package member")));
        }
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModuleOrNull(descriptor2);
        if (moduleDescriptor == null) {
            Collection<ClassConstructorDescriptor> collection;
            DeclarationDescriptor declarationDescriptor = descriptor2;
            if (declarationDescriptor instanceof CallableMemberDescriptor) {
                collection = CollectionsKt.listOf((Object)descriptor2);
            } else if (declarationDescriptor instanceof ClassDescriptor) {
                Collection<ClassConstructorDescriptor> collection2 = ((ClassDescriptor)descriptor2).getConstructors();
                collection = collection2;
                Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"descriptor.constructors");
            } else {
                throw (Throwable)((Object)new AssertionError((Object)("Unexpected descriptor kind: " + descriptor2)));
            }
            return collection;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleDescriptor, (String)"DescriptorUtils.getConta\u2026: $descriptor\")\n        }");
        ModuleDescriptor containingModule = moduleDescriptor;
        MemberScope containingPackageScope = containingModule.getPackage(((PackageFragmentDescriptor)containingPackage).getFqName()).getMemberScope();
        Name name = descriptor2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"descriptor.name");
        Iterable $this$filter$iv = (Iterable)getMembersByName.invoke((Object)containingPackageScope, (Object)name);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DeclarationDescriptorNonRoot it = (DeclarationDescriptorNonRoot)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)DescriptorUtils.getContainingModule(it), (Object)containingModule)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List possibleOverloads = (List)destination$iv$iv;
        return overloadFilter.filterPackageMemberOverloads(possibleOverloads);
    }

    private final void checkOverloadsInClass(ClassDescriptorWithResolutionScopes classDescriptor2, Collection<? extends FunctionDescriptor> nestedClassConstructors) {
        MultiMap<Name, CallableMemberDescriptor> multiMap = MultiMap.create();
        Intrinsics.checkExpressionValueIsNotNull(multiMap, (String)"MultiMap.create<Name, CallableMemberDescriptor>()");
        MultiMap<Name, CallableMemberDescriptor> functionsByName = multiMap;
        Iterator<Object> iterator2 = classDescriptor2.getDeclaredCallableMembers().iterator();
        while (iterator2.hasNext()) {
            CallableMemberDescriptor callableMemberDescriptor;
            CallableMemberDescriptor callableMemberDescriptor2 = callableMemberDescriptor = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor2, (String)"function");
            functionsByName.putValue(callableMemberDescriptor2.getName(), callableMemberDescriptor);
        }
        for (FunctionDescriptor functionDescriptor : nestedClassConstructors) {
            Name name;
            DeclarationDescriptor declarationDescriptor = functionDescriptor.getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"nestedConstructor.containingDeclaration");
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor.getName(), (String)"nestedConstructor.containingDeclaration.name");
            functionsByName.putValue(name, functionDescriptor);
        }
        for (Map.Entry entry : functionsByName.entrySet()) {
            Object v = entry.getValue();
            Intrinsics.checkExpressionValueIsNotNull(v, (String)"e.value");
            this.checkOverloadsInClass((Collection)v);
        }
    }

    private final void checkOverloadsInPackage(Collection<? extends DeclarationDescriptorNonRoot> members) {
        Object object;
        boolean $i$f$forEach;
        Object $this$forEach$iv;
        if (members.size() == 1) {
            return;
        }
        LinkedHashMap redeclarationsMap = new LinkedHashMap();
        Object object2 = this.getPossibleRedeclarationGroups(members).iterator();
        while (object2.hasNext()) {
            Collection<DeclarationDescriptorNonRoot> redeclarationGroup = object2.next();
            Collection<DeclarationDescriptorNonRoot> redeclarations = this.findRedeclarations(redeclarationGroup);
            $this$forEach$iv = redeclarations;
            $i$f$forEach = false;
            object = $this$forEach$iv.iterator();
            while (object.hasNext()) {
                Object object3;
                Object element$iv = object.next();
                DeclarationDescriptorNonRoot it = (DeclarationDescriptorNonRoot)element$iv;
                boolean bl = false;
                Map $this$getOrPut$iv = redeclarationsMap;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(it);
                if (value$iv == null) {
                    boolean bl2 = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(it, answer$iv);
                    object3 = answer$iv;
                } else {
                    object3 = value$iv;
                }
                ((Set)object3).addAll(redeclarations);
            }
        }
        HashSet reported = new HashSet();
        $this$forEach$iv = redeclarationsMap;
        $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            object = object2 = iterator2.next();
            boolean bl = false;
            DeclarationDescriptorNonRoot member = (DeclarationDescriptorNonRoot)object.getKey();
            object = object2;
            bl = false;
            Set conflicting = (Set)object.getValue();
            if (reported.contains(member)) continue;
            reported.addAll(conflicting);
            this.reportRedeclarations(conflicting);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<Collection<DeclarationDescriptorNonRoot>> getPossibleRedeclarationGroups(Collection<? extends DeclarationDescriptorNonRoot> members) {
        void $this$groupByTo$iv$iv;
        void $this$filterTo$iv$iv;
        boolean bl = false;
        ArrayList result2 = new ArrayList();
        Iterable $this$filter$iv = members;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DeclarationDescriptorNonRoot it = (DeclarationDescriptorNonRoot)element$iv$iv;
            boolean bl2 = false;
            if (!(!this.isPrivate(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nonPrivates = (List)destination$iv$iv;
        Iterable $this$groupBy$iv = members;
        boolean $i$f$groupBy = false;
        destination$iv$iv = $this$groupBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            DeclarationDescriptorNonRoot it = (DeclarationDescriptorNonRoot)element$iv$iv;
            boolean bl3 = false;
            SourceFile key$iv$iv = DescriptorUtils.getContainingSourceFile(it);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl4 = false;
                ArrayList answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map bySourceFile = destination$iv$iv2;
        boolean hasGroupIncludingNonPrivateMembers = false;
        for (List membersInFile : bySourceFile.values()) {
            boolean bl5;
            block9: {
                Iterable $this$any$iv = membersInFile;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl5 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DeclarationDescriptorNonRoot it = (DeclarationDescriptorNonRoot)element$iv;
                        boolean bl6 = false;
                        if (!this.isPrivate(it)) continue;
                        bl5 = true;
                        break block9;
                    }
                    bl5 = false;
                }
            }
            if (!bl5) continue;
            hasGroupIncludingNonPrivateMembers = true;
            Set group = SetsKt.plus((Set)new LinkedHashSet(nonPrivates), (Iterable)membersInFile);
            result2.add(group);
        }
        if (!hasGroupIncludingNonPrivateMembers && nonPrivates.size() > 1) {
            result2.add(nonPrivates);
        }
        return result2;
    }

    private final boolean isPrivate(@NotNull DeclarationDescriptor $this$isPrivate) {
        return $this$isPrivate instanceof DeclarationDescriptorWithVisibility && Visibilities.isPrivate(((DeclarationDescriptorWithVisibility)$this$isPrivate).getVisibility());
    }

    private final void checkOverloadsInClass(Collection<? extends CallableMemberDescriptor> members) {
        if (members.size() == 1) {
            return;
        }
        this.reportRedeclarations(this.findRedeclarations(members));
    }

    private final boolean isSynthesized(@NotNull DeclarationDescriptor $this$isSynthesized) {
        return $this$isSynthesized instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)$this$isSynthesized).getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED;
    }

    private final Collection<DeclarationDescriptorNonRoot> findRedeclarations(Collection<? extends DeclarationDescriptorNonRoot> members) {
        boolean bl = false;
        LinkedHashSet<DeclarationDescriptorNonRoot> redeclarations = new LinkedHashSet<DeclarationDescriptorNonRoot>();
        for (DeclarationDescriptorNonRoot declarationDescriptorNonRoot : members) {
            if (this.isSynthesized(declarationDescriptorNonRoot)) continue;
            for (DeclarationDescriptorNonRoot declarationDescriptorNonRoot2 : members) {
                if (Intrinsics.areEqual((Object)declarationDescriptorNonRoot, (Object)declarationDescriptorNonRoot2) || this.isConstructorsOfDifferentRedeclaredClasses(declarationDescriptorNonRoot, declarationDescriptorNonRoot2) || this.isTopLevelMainInDifferentFiles(declarationDescriptorNonRoot, declarationDescriptorNonRoot2) || this.isDefinitionsForDifferentPlatforms(declarationDescriptorNonRoot, declarationDescriptorNonRoot2) || this.isExpectDeclarationAndDefinition(declarationDescriptorNonRoot, declarationDescriptorNonRoot2) || this.isExpectDeclarationAndDefinition(declarationDescriptorNonRoot2, declarationDescriptorNonRoot) || this.overloadChecker.isOverloadable(declarationDescriptorNonRoot, declarationDescriptorNonRoot2)) continue;
                redeclarations.add(declarationDescriptorNonRoot);
            }
        }
        return redeclarations;
    }

    private final boolean isConstructorsOfDifferentRedeclaredClasses(DeclarationDescriptor member1, DeclarationDescriptor member2) {
        if (!(member1 instanceof ConstructorDescriptor) || !(member2 instanceof ConstructorDescriptor)) {
            return false;
        }
        ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ConstructorDescriptor)member1).getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull((Object)classifierDescriptorWithTypeParameters, (String)"member1.containingDeclaration");
        ClassifierDescriptorWithTypeParameters parent1 = classifierDescriptorWithTypeParameters;
        ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters2 = ((ConstructorDescriptor)member2).getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull((Object)classifierDescriptorWithTypeParameters2, (String)"member2.containingDeclaration");
        ClassifierDescriptorWithTypeParameters parent2 = classifierDescriptorWithTypeParameters2;
        return parent1 != parent2 && Intrinsics.areEqual((Object)parent1.getContainingDeclaration(), (Object)parent2.getContainingDeclaration());
    }

    private final boolean isTopLevelMainInDifferentFiles(DeclarationDescriptor member1, DeclarationDescriptor member2) {
        if (!MainFunctionDetector.isMain$default(this.mainFunctionDetector, member1, false, false, false, 14, null) || !MainFunctionDetector.isMain$default(this.mainFunctionDetector, member2, false, false, false, 14, null)) {
            return false;
        }
        KtFile file1 = DescriptorToSourceUtils.getContainingFile(member1);
        KtFile file2 = DescriptorToSourceUtils.getContainingFile(member2);
        return file1 == null || file2 == null || file1 != file2;
    }

    private final boolean isExpectDeclarationAndDefinition(DeclarationDescriptor declaration2, DeclarationDescriptor definition) {
        return declaration2 instanceof MemberDescriptor && ((MemberDescriptor)declaration2).isExpect() && definition instanceof MemberDescriptor && !((MemberDescriptor)definition).isExpect();
    }

    private final boolean isDefinitionsForDifferentPlatforms(DeclarationDescriptorNonRoot member1, DeclarationDescriptorNonRoot member2) {
        if (!(member1 instanceof MemberDescriptor) || !(member2 instanceof MemberDescriptor)) {
            return false;
        }
        return ((MemberDescriptor)member1).isActual() && ((MemberDescriptor)member2).isActual() && Intrinsics.areEqual((Object)DescriptorUtilsKt.getPlatform(member1), (Object)DescriptorUtilsKt.getPlatform(member2)) ^ true;
    }

    private final void reportRedeclarations(Collection<? extends DeclarationDescriptorNonRoot> redeclarations) {
        if (redeclarations.isEmpty()) {
            return;
        }
        for (DeclarationDescriptorNonRoot declarationDescriptorNonRoot : redeclarations) {
            Diagnostic diagnostic;
            PsiElement it;
            BindingTrace bindingTrace;
            PsiElement psiElement$iv;
            PsiElement psiElement;
            boolean bl2;
            boolean bl3;
            boolean $i$f$reportOnDeclaration;
            BindingTrace trace$iv;
            DeclarationDescriptorNonRoot declarationDescriptorNonRoot2 = declarationDescriptorNonRoot;
            if (declarationDescriptorNonRoot2 instanceof PropertyDescriptor || declarationDescriptorNonRoot2 instanceof ClassifierDescriptor) {
                trace$iv = this.trace;
                $i$f$reportOnDeclaration = false;
                if (DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptorNonRoot) != null) {
                    bl3 = false;
                    bl2 = false;
                    psiElement$iv = psiElement;
                    boolean bl = false;
                    PsiElement psiElement2 = psiElement$iv;
                    bindingTrace = trace$iv;
                    boolean bl4 = false;
                    ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.REDECLARATION.on(it, redeclarations);
                    Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, (String)"Errors.REDECLARATION.on(it, redeclarations)");
                    diagnostic = parametrizedDiagnostic;
                    bindingTrace.report(diagnostic);
                }
                continue;
            }
            if (!(declarationDescriptorNonRoot2 instanceof FunctionDescriptor)) continue;
            trace$iv = this.trace;
            $i$f$reportOnDeclaration = false;
            if (DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptorNonRoot) == null) continue;
            bl3 = false;
            bl2 = false;
            psiElement$iv = psiElement;
            boolean bl = false;
            it = psiElement$iv;
            bindingTrace = trace$iv;
            boolean bl5 = false;
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.CONFLICTING_OVERLOADS.on(it, redeclarations);
            Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, (String)"Errors.CONFLICTING_OVERL\u2026DS.on(it, redeclarations)");
            diagnostic = parametrizedDiagnostic;
            bindingTrace.report(diagnostic);
        }
    }

    public OverloadResolver(@NotNull BindingTrace trace, @NotNull OverloadFilter overloadFilter, @NotNull OverloadChecker overloadChecker, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)overloadFilter, (String)"overloadFilter");
        Intrinsics.checkParameterIsNotNull((Object)overloadChecker, (String)"overloadChecker");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.trace = trace;
        this.overloadFilter = overloadFilter;
        this.overloadChecker = overloadChecker;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
        this.mainFunctionDetector = new MainFunctionDetector(bindingContext, languageVersionSettings);
    }

    public static final /* synthetic */ Collection access$getModulePackageMembersWithSameName(OverloadResolver $this, DeclarationDescriptor descriptor2, OverloadFilter overloadFilter, Function2 getMembersByName) {
        return $this.getModulePackageMembersWithSameName(descriptor2, overloadFilter, (Function2<? super MemberScope, ? super Name, ? extends Collection<? extends DeclarationDescriptorNonRoot>>)getMembersByName);
    }
}

