/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.plugins;

import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.cli.jvm.plugins.ServiceLoaderLite;
import org.jetbrains.kotlin.compiler.plugin.AbstractCliOption;
import org.jetbrains.kotlin.compiler.plugin.CliOptionProcessingException;
import org.jetbrains.kotlin.compiler.plugin.CliOptionValue;
import org.jetbrains.kotlin.compiler.plugin.CliOptionsKt;
import org.jetbrains.kotlin.compiler.plugin.CommandLineProcessor;
import org.jetbrains.kotlin.compiler.plugin.ComponentRegistrar;
import org.jetbrains.kotlin.compiler.plugin.PluginCliOptionProcessingException;
import org.jetbrains.kotlin.config.CompilerConfiguration;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nH\u0007J5\u0010\u000b\u001a\u00020\f2\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\r2\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u000eJ0\u0010\u000b\u001a\u00020\f2\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nH\u0007J(\u0010\u000f\u001a\u00020\u00042\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/plugins/PluginCliParser;", "", "()V", "loadPlugins", "", "pluginClasspaths", "", "", "pluginOptions", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "loadPluginsSafe", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "", "([Ljava/lang/String;[Ljava/lang/String;Lorg/jetbrains/kotlin/config/CompilerConfiguration;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "processPluginOptions", "classLoader", "Ljava/net/URLClassLoader;", "cli"})
public final class PluginCliParser {
    public static final PluginCliParser INSTANCE;

    @JvmStatic
    @NotNull
    public static final ExitCode loadPluginsSafe(@Nullable String[] pluginClasspaths, @Nullable String[] pluginOptions, @NotNull CompilerConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        return PluginCliParser.loadPluginsSafe(pluginClasspaths != null ? ArraysKt.asIterable((Object[])pluginClasspaths) : null, pluginOptions != null ? ArraysKt.asIterable((Object[])pluginOptions) : null, configuration);
    }

    @JvmStatic
    @NotNull
    public static final ExitCode loadPluginsSafe(@Nullable Iterable<String> pluginClasspaths, @Nullable Iterable<String> pluginOptions, @NotNull CompilerConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        MessageCollector messageCollector = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        try {
            PluginCliParser.loadPlugins(pluginClasspaths, pluginOptions, configuration);
        }
        catch (PluginCliOptionProcessingException e) {
            String message2 = e.getMessage() + "\n\n" + CliOptionsKt.cliPluginUsageString(e.getPluginId(), e.getOptions());
            MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, message2, null, 4, null);
            return ExitCode.INTERNAL_ERROR;
        }
        catch (CliOptionProcessingException e) {
            String string = e.getMessage();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, string, null, 4, null);
            return ExitCode.INTERNAL_ERROR;
        }
        catch (Throwable t) {
            MessageCollectorUtil.reportException(messageCollector, t);
            return ExitCode.INTERNAL_ERROR;
        }
        return ExitCode.OK;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void loadPlugins(@Nullable Iterable<String> pluginClasspaths, @Nullable Iterable<String> pluginOptions, @NotNull CompilerConfiguration configuration) {
        Object object;
        block6: {
            Object object2;
            block5: {
                void $this$mapTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
                object = pluginClasspaths;
                if (pluginClasspaths == null) break block5;
                URL[] $this$map$iv = object;
                boolean $i$f$map = false;
                URL[] uRLArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    object2 = destination$iv$iv;
                    boolean bl = false;
                    URL uRL = new File((String)it).toURI().toURL();
                    object2.add(uRL);
                }
                object2 = (List)destination$iv$iv;
                Collection $this$toTypedArray$iv = (Collection)object2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                URL[] uRLArray2 = thisCollection$iv.toArray(new URL[0]);
                if (uRLArray2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                object2 = uRLArray2;
                object = object2;
                if (object != null) break block6;
            }
            object2 = new URL[]{};
            object = object2;
        }
        ClassLoader classLoader = INSTANCE.getClass().getClassLoader();
        URL[] uRLArray = object;
        URLClassLoader classLoader2 = new URLClassLoader(uRLArray, classLoader);
        List<ComponentRegistrar> componentRegistrars = ServiceLoaderLite.INSTANCE.loadImplementations(ComponentRegistrar.class, classLoader2);
        configuration.addAll(ComponentRegistrar.Companion.getPLUGIN_COMPONENT_REGISTRARS(), (Collection)componentRegistrars);
        INSTANCE.processPluginOptions(pluginOptions, configuration, classLoader2);
    }

    /*
     * WARNING - void declaration
     */
    private final void processPluginOptions(Iterable<String> pluginOptions, CompilerConfiguration configuration, URLClassLoader classLoader) {
        Object object;
        Iterable list$iv$iv;
        AbstractCliOption value$iv$iv$iv;
        Object object2;
        Object object3;
        Iterable<String> iterable = pluginOptions;
        if (iterable != null) {
            void $this$groupByTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            Iterable<String> $this$map$iv = iterable;
            boolean $i$f$map = false;
            Iterable<String> iterable2 = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p1;
                String string = (String)item$iv$iv;
                object3 = destination$iv$iv;
                boolean bl = false;
                object2 = CliOptionsKt.parsePluginOption((String)p1);
                object3.add(object2);
            }
            Iterable $this$groupBy$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$mapTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object4;
                CliOptionValue it = (CliOptionValue)element$iv$iv;
                boolean bl = false;
                if (it == null) {
                    throw (Throwable)new CliOptionProcessingException("Wrong plugin option format: " + it + ", should be plugin:<pluginId>:<optionName>=<value>", null, 2, null);
                }
                String key$iv$iv = it.getPluginId();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object4 = answer$iv$iv$iv;
                } else {
                    object4 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object4;
                list$iv$iv.add(element$iv$iv);
            }
            object = destination$iv$iv;
        } else {
            boolean $this$groupBy$iv = false;
            object = MapsKt.emptyMap();
        }
        Map optionValuesByPlugin = object;
        List<CommandLineProcessor> commandLineProcessors = ServiceLoaderLite.INSTANCE.loadImplementations(CommandLineProcessor.class, classLoader);
        for (CommandLineProcessor processor2 : commandLineProcessors) {
            List $this$associateByTo$iv$iv;
            Iterable $this$associateBy$iv = processor2.getPluginOptions();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            list$iv$iv = $this$associateBy$iv;
            Map destination$iv$iv22 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                value$iv$iv$iv = (AbstractCliOption)element$iv$iv;
                object3 = destination$iv$iv22;
                boolean bl = false;
                object2 = it.getOptionName();
                object3.put(object2, element$iv$iv);
            }
            Map declaredOptions = destination$iv$iv22;
            MultiMap<AbstractCliOption, CliOptionValue> optionsToValues = new MultiMap<AbstractCliOption, CliOptionValue>();
            $this$associateByTo$iv$iv = (List)optionValuesByPlugin.get(processor2.getPluginId());
            boolean destination$iv$iv22 = false;
            List list2 = $this$associateByTo$iv$iv;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            Iterator<Object> iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                AbstractCliOption option;
                CliOptionValue optionValue;
                CliOptionValue cliOptionValue = optionValue = (CliOptionValue)iterator2.next();
                if (cliOptionValue == null) {
                    Intrinsics.throwNpe();
                }
                if ((AbstractCliOption)declaredOptions.get(cliOptionValue.getOptionName()) == null) {
                    throw (Throwable)new CliOptionProcessingException("Unsupported plugin option: " + optionValue, null, 2, null);
                }
                optionsToValues.putValue(option, optionValue);
            }
            for (AbstractCliOption option : processor2.getPluginOptions()) {
                Collection values = optionsToValues.get(option);
                if (option.getRequired() && values.isEmpty()) {
                    throw (Throwable)new PluginCliOptionProcessingException(processor2.getPluginId(), processor2.getPluginOptions(), "Required plugin option not present: " + processor2.getPluginId() + ':' + option.getOptionName(), null, 8, null);
                }
                if (!option.getAllowMultipleOccurrences() && values.size() > 1) {
                    throw (Throwable)new PluginCliOptionProcessingException(processor2.getPluginId(), processor2.getPluginOptions(), "Multiple values are not allowed for plugin option " + processor2.getPluginId() + ':' + option.getOptionName(), null, 8, null);
                }
                for (CliOptionValue value : values) {
                    processor2.processOption(option, value.getValue(), configuration);
                }
            }
        }
    }

    private PluginCliParser() {
    }

    static {
        PluginCliParser pluginCliParser;
        INSTANCE = pluginCliParser = new PluginCliParser();
    }
}

