/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.ir.convertors;

import java.io.ByteArrayOutputStream;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\bf\u0018\u00002\u00020\u0001:\u00010J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0000H&J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\nH&J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\fH&J\b\u0010\r\u001a\u00020\u0000H&J\u0017\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\nH\u0016J\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0010\u0010#\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020&H\u0016J\u0017\u0010'\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b(\u0010\u0015J\u0017\u0010)\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b*\u0010\u0019J\u0010\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020&H\u0016J\u0017\u0010-\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b.\u0010\u0019J\u0010\u0010/\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020$H\u0002R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u00061\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/convertors/ByteWriter;", "", "written", "", "getWritten", "()I", "write", "", "v", "writeByte", "", "writeBytes", "", "createTemp", "writeUByte", "Lkotlin/UByte;", "writeUByte-7apg3OU", "(B)V", "writeUInt16", "Lkotlin/UShort;", "writeUInt16-xj2QHRw", "(S)V", "writeUInt32", "Lkotlin/UInt;", "writeUInt32-WZ4Q5Ns", "(I)V", "writeUInt64", "Lkotlin/ULong;", "writeUInt64-VKZWuLQ", "(J)V", "size", "writeUInt64-4PLdz1A", "(JI)V", "writeVarInt7", "writeVarInt32", "writeVarInt64", "", "writeVarUInt1", "", "writeVarUInt7", "writeVarUInt7-xj2QHRw", "writeVarUInt32", "writeVarUInt32-WZ4Q5Ns", "writeBoolean", "value", "writeUnsignedLeb128", "writeUnsignedLeb128-WZ4Q5Ns", "writeSignedLeb128", "OutputStream", "wasm.ir"})
public interface ByteWriter {
    public int getWritten();

    public void write(@NotNull ByteWriter var1);

    public void writeByte(byte var1);

    public void writeBytes(@NotNull byte[] var1);

    @NotNull
    public ByteWriter createTemp();

    default public void writeUByte-7apg3OU(byte by) {
        this.writeByte(by);
    }

    default public void writeUInt16-xj2QHRw(short s2) {
        this.writeByte((byte)s2);
        this.writeByte((byte)UInt.constructor-impl((int)(UInt.constructor-impl((int)(s2 & 0xFFFF)) >>> 8)));
    }

    default public void writeUInt32-WZ4Q5Ns(int n2) {
        this.writeByte((byte)n2);
        this.writeByte((byte)UInt.constructor-impl((int)(n2 >>> 8)));
        this.writeByte((byte)UInt.constructor-impl((int)(n2 >>> 16)));
        this.writeByte((byte)UInt.constructor-impl((int)(n2 >>> 24)));
    }

    default public void writeUInt64-VKZWuLQ(long l2) {
        this.writeByte((byte)l2);
        this.writeByte((byte)ULong.constructor-impl((long)(l2 >>> 8)));
        this.writeByte((byte)ULong.constructor-impl((long)(l2 >>> 16)));
        this.writeByte((byte)ULong.constructor-impl((long)(l2 >>> 24)));
        this.writeByte((byte)ULong.constructor-impl((long)(l2 >>> 32)));
        this.writeByte((byte)ULong.constructor-impl((long)(l2 >>> 40)));
        this.writeByte((byte)ULong.constructor-impl((long)(l2 >>> 48)));
        this.writeByte((byte)ULong.constructor-impl((long)(l2 >>> 56)));
    }

    default public void writeUInt64-4PLdz1A(long l2, int size) {
        switch (size) {
            case 1: {
                this.writeUByte-7apg3OU(UByte.constructor-impl((byte)((byte)l2)));
                break;
            }
            case 2: {
                this.writeUInt16-xj2QHRw(UShort.constructor-impl((short)((short)l2)));
                break;
            }
            case 4: {
                this.writeUInt32-WZ4Q5Ns(UInt.constructor-impl((int)((int)l2)));
                break;
            }
            case 8: {
                this.writeUInt64-VKZWuLQ(l2);
                break;
            }
            default: {
                throw new IllegalStateException(("Unsupported size " + size).toString());
            }
        }
    }

    default public void writeVarInt7(byte v2) {
        this.writeSignedLeb128(v2);
    }

    default public void writeVarInt32(int v2) {
        this.writeSignedLeb128(v2);
    }

    default public void writeVarInt64(long v2) {
        this.writeSignedLeb128(v2);
    }

    default public void writeVarUInt1(boolean v2) {
        this.writeUnsignedLeb128-WZ4Q5Ns(v2 ? 1 : 0);
    }

    default public void writeVarUInt7-xj2QHRw(short s2) {
        this.writeUnsignedLeb128-WZ4Q5Ns(UInt.constructor-impl((int)(s2 & 0xFFFF)));
    }

    default public void writeVarUInt32-WZ4Q5Ns(int n2) {
        this.writeUnsignedLeb128-WZ4Q5Ns(n2);
    }

    default public void writeBoolean(boolean value2) {
        this.writeByte(value2 ? (byte)1 : 0);
    }

    private void writeUnsignedLeb128-WZ4Q5Ns(int n2) {
        int n3;
        int v2 = n2;
        int remaining = UInt.constructor-impl((int)(v2 >>> 7));
        while (remaining != 0) {
            n3 = UInt.constructor-impl((int)(UInt.constructor-impl((int)(v2 & 0x7F)) | 0x80));
            this.writeByte((byte)n3);
            v2 = remaining;
            remaining = UInt.constructor-impl((int)(remaining >>> 7));
        }
        n3 = UInt.constructor-impl((int)(v2 & 0x7F));
        this.writeByte((byte)n3);
    }

    private void writeSignedLeb128(long v2) {
        long end;
        long v3 = v2;
        long remaining = v3 >> 7;
        boolean hasMore = true;
        long l2 = end = (v3 & Long.MIN_VALUE) == 0L ? 0L : -1L;
        while (hasMore) {
            hasMore = remaining != end || (remaining & 1L) != (v3 >> 6 & 1L);
            int n2 = (int)(v3 & 0x7FL | (hasMore ? 128L : 0L));
            this.writeByte((byte)n2);
            v3 = remaining;
            remaining >>= 7;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001H\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0000H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/convertors/ByteWriter$OutputStream;", "Lorg/jetbrains/kotlin/wasm/ir/convertors/ByteWriter;", "os", "Ljava/io/OutputStream;", "<init>", "(Ljava/io/OutputStream;)V", "getOs", "()Ljava/io/OutputStream;", "value", "", "written", "getWritten", "()I", "write", "", "v", "writeByte", "", "writeBytes", "", "createTemp", "wasm.ir"})
    public static final class OutputStream
    implements ByteWriter {
        @NotNull
        private final java.io.OutputStream os;
        private int written;

        public OutputStream(@NotNull java.io.OutputStream os) {
            Intrinsics.checkNotNullParameter((Object)os, (String)"os");
            this.os = os;
        }

        @NotNull
        public final java.io.OutputStream getOs() {
            return this.os;
        }

        @Override
        public int getWritten() {
            return this.written;
        }

        @Override
        public void write(@NotNull ByteWriter v2) {
            Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
            if (!(v2 instanceof OutputStream) || !(((OutputStream)v2).os instanceof ByteArrayOutputStream)) {
                throw new IllegalStateException("Writer not created from createTemp".toString());
            }
            ((ByteArrayOutputStream)((OutputStream)v2).os).writeTo(this.os);
            this.written = this.getWritten() + ((ByteArrayOutputStream)((OutputStream)v2).os).size();
        }

        @Override
        public void writeByte(byte v2) {
            this.os.write(v2);
            int n2 = this.getWritten();
            this.written = n2 + 1;
        }

        @Override
        public void writeBytes(@NotNull byte[] v2) {
            Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
            this.os.write(v2);
            this.written = this.getWritten() + v2.length;
        }

        @Override
        @NotNull
        public OutputStream createTemp() {
            return new OutputStream(new ByteArrayOutputStream());
        }
    }
}

