/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints;

import java.util.Comparator;
import java.util.List;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntArrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntComparator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntComparators;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntListIterator;

public interface IntList
extends IntCollection,
Comparable<List<? extends Integer>>,
List<Integer> {
    @Override
    public IntListIterator iterator();

    public IntListIterator listIterator();

    public IntListIterator listIterator(int var1);

    public IntList subList(int var1, int var2);

    public void removeElements(int var1, int var2);

    default public void setElements(int[] a) {
        this.setElements(0, a);
    }

    default public void setElements(int index2, int[] a) {
        this.setElements(index2, a, 0, a.length);
    }

    default public void setElements(int index2, int[] a, int offset2, int length) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is negative");
        }
        if (index2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than list size (" + this.size() + ")");
        }
        IntArrays.ensureOffsetLength(a, offset2, length);
        if (index2 + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (index2 + length) + ") is greater than list size (" + this.size() + ")");
        }
        IntListIterator iter = this.listIterator(index2);
        int i = 0;
        while (i < length) {
            iter.nextInt();
            iter.set(a[offset2 + i++]);
        }
    }

    @Override
    public boolean add(int var1);

    @Override
    public void add(int var1, int var2);

    @Override
    @Deprecated
    default public void add(int index2, Integer key) {
        this.add(index2, (int)key);
    }

    @Override
    public int set(int var1, int var2);

    public int getInt(int var1);

    public int indexOf(int var1);

    public int lastIndexOf(int var1);

    @Override
    @Deprecated
    default public boolean contains(Object key) {
        return IntCollection.super.contains(key);
    }

    @Override
    @Deprecated
    default public Integer get(int index2) {
        return this.getInt(index2);
    }

    @Override
    @Deprecated
    default public int indexOf(Object o) {
        return this.indexOf((Integer)o);
    }

    @Override
    @Deprecated
    default public int lastIndexOf(Object o) {
        return this.lastIndexOf((Integer)o);
    }

    @Override
    @Deprecated
    default public boolean add(Integer k) {
        return this.add((int)k);
    }

    public int removeInt(int var1);

    @Override
    @Deprecated
    default public boolean remove(Object key) {
        return IntCollection.super.remove(key);
    }

    @Override
    @Deprecated
    default public Integer remove(int index2) {
        return this.removeInt(index2);
    }

    @Override
    @Deprecated
    default public Integer set(int index2, Integer k) {
        return this.set(index2, (int)k);
    }

    @Override
    @Deprecated
    default public void sort(Comparator<? super Integer> comparator) {
        this.sort(IntComparators.asIntComparator(comparator));
    }

    default public void sort(IntComparator comparator) {
        if (comparator == null) {
            this.unstableSort(comparator);
        } else {
            int[] elements = this.toIntArray();
            IntArrays.stableSort(elements, comparator);
            this.setElements(elements);
        }
    }

    default public void unstableSort(IntComparator comparator) {
        int[] elements = this.toIntArray();
        if (comparator == null) {
            IntArrays.unstableSort(elements);
        } else {
            IntArrays.unstableSort(elements, comparator);
        }
        this.setElements(elements);
    }
}

