/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSpreadOfNullableChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirSpreadOfNullableChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirSpreadOfNullableChecker INSTANCE = new FirSpreadOfNullableChecker();

    private FirSpreadOfNullableChecker() {
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        for (FirExpression argument2 : expression2.getArgumentList().getArguments()) {
            if (argument2 instanceof FirVarargArgumentsExpression) {
                for (FirExpression subArgument : ((FirVarargArgumentsExpression)argument2).getArguments()) {
                    FirSpreadOfNullableChecker.check$checkAndReport(reporter, context, subArgument, argument2.getSource());
                }
                continue;
            }
            FirSpreadOfNullableChecker.check$checkAndReport(reporter, context, argument2, argument2.getSource());
        }
    }

    private static final void check$checkAndReport(DiagnosticReporter $reporter, CheckerContext $context, FirExpression argument2, KtSourceElement source) {
        FirTypeRef argumentTypeRef = argument2.getTypeRef();
        if (argument2 instanceof FirSpreadArgumentExpression && !(FirTypeUtilsKt.getConeType(argumentTypeRef) instanceof ConeFlexibleType) && FirTypeUtilsKt.getCanBeNull(argumentTypeRef)) {
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getSPREAD_OF_NULLABLE(), (DiagnosticContext)$context, null, 8, null);
        }
    }
}

