/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.ir;

import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmInstr;
import org.jetbrains.kotlin.wasm.ir.WasmIrExpressionBuilderKt;
import org.jetbrains.kotlin.wasm.ir.WasmLocal;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J%\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0019H\u0002\u00a2\u0006\u0002\u0010\u001bJ)\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0019\"\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0017\u0010\u001d\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010\u001eR\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR$\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/WasmIrExpressionBuilder;", "Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "expression", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmInstr;", "(Ljava/util/List;)V", "eatEverythingUntilLevel", "", "Ljava/lang/Integer;", "getExpression", "()Ljava/util/List;", "lastInstr", "getLastInstr", "()Lorg/jetbrains/kotlin/wasm/ir/WasmInstr;", "value", "numberOfNestedBlocks", "getNumberOfNestedBlocks", "()I", "setNumberOfNestedBlocks", "(I)V", "addInstruction", "", "op", "Lorg/jetbrains/kotlin/wasm/ir/WasmOp;", "immediates", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate;", "(Lorg/jetbrains/kotlin/wasm/ir/WasmOp;[Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate;)V", "buildInstr", "getCurrentEatLevel", "(Lorg/jetbrains/kotlin/wasm/ir/WasmOp;)Ljava/lang/Integer;", "wasm.ir"})
public final class WasmIrExpressionBuilder
extends WasmExpressionBuilder {
    @NotNull
    private final List<WasmInstr> expression;
    @Nullable
    private Integer eatEverythingUntilLevel;
    private int numberOfNestedBlocks;

    public WasmIrExpressionBuilder(@NotNull List<WasmInstr> expression2) {
        Intrinsics.checkNotNullParameter(expression2, (String)"expression");
        this.expression = expression2;
    }

    @NotNull
    public final List<WasmInstr> getExpression() {
        return this.expression;
    }

    private final WasmInstr getLastInstr() {
        return (WasmInstr)CollectionsKt.lastOrNull(this.expression);
    }

    private final void addInstruction(WasmOp op, WasmImmediate[] immediates) {
        WasmInstr newInstruction = new WasmInstr(op, ArraysKt.toList((Object[])immediates));
        this.expression.add(newInstruction);
    }

    private final Integer getCurrentEatLevel(WasmOp op) {
        Integer n = this.eatEverythingUntilLevel;
        if (n == null) {
            return null;
        }
        int eatLevel = n;
        if (this.getNumberOfNestedBlocks() == eatLevel && WasmIrExpressionBuilderKt.access$isInCfgNode(op)) {
            this.eatEverythingUntilLevel = null;
            return null;
        }
        if (this.getNumberOfNestedBlocks() < eatLevel) {
            this.eatEverythingUntilLevel = null;
            return null;
        }
        return eatLevel;
    }

    @Override
    public void buildInstr(@NotNull WasmOp op, WasmImmediate ... immediates) {
        WasmInstr lastInstruction;
        Intrinsics.checkNotNullParameter((Object)((Object)op), (String)"op");
        Intrinsics.checkNotNullParameter((Object)immediates, (String)"immediates");
        Integer currentEatUntil = this.getCurrentEatLevel(op);
        if (currentEatUntil != null) {
            if (currentEatUntil <= this.getNumberOfNestedBlocks()) {
                return;
            }
        } else if (WasmIrExpressionBuilderKt.access$isOutCfgNode(op)) {
            this.eatEverythingUntilLevel = this.getNumberOfNestedBlocks();
            this.addInstruction(op, immediates);
            return;
        }
        if ((lastInstruction = this.getLastInstr()) == null) {
            this.addInstruction(op, immediates);
            return;
        }
        WasmOp lastOperator = lastInstruction.getOperator();
        if ((op == WasmOp.DROP || op == WasmOp.UNREACHABLE) && WasmIrExpressionBuilderKt.access$pureStacklessInstruction(lastOperator)) {
            CollectionsKt.removeLast(this.expression);
            return;
        }
        if (lastOperator == WasmOp.LOCAL_SET && op == WasmOp.LOCAL_GET) {
            WasmSymbol<WasmLocal> localSetNumber;
            Object object = CollectionsKt.firstOrNull(lastInstruction.getImmediates());
            WasmImmediate.LocalIdx localIdx = object instanceof WasmImmediate.LocalIdx ? (WasmImmediate.LocalIdx)object : null;
            WasmSymbol<WasmLocal> wasmSymbol = localSetNumber = localIdx != null ? localIdx.getValue() : null;
            if (localSetNumber != null) {
                WasmSymbol<WasmLocal> localGetNumber;
                Object object2 = ArraysKt.firstOrNull((Object[])immediates);
                WasmImmediate.LocalIdx localIdx2 = object2 instanceof WasmImmediate.LocalIdx ? (WasmImmediate.LocalIdx)object2 : null;
                WasmSymbol<WasmLocal> wasmSymbol2 = localGetNumber = localIdx2 != null ? localIdx2.getValue() : null;
                if (Intrinsics.areEqual(localGetNumber, localSetNumber)) {
                    CollectionsKt.removeLast(this.expression);
                    this.addInstruction(WasmOp.LOCAL_TEE, immediates);
                    return;
                }
            }
        }
        this.addInstruction(op, immediates);
    }

    @Override
    public int getNumberOfNestedBlocks() {
        return this.numberOfNestedBlocks;
    }

    @Override
    public void setNumberOfNestedBlocks(int value2) {
        boolean bl;
        boolean bl2 = bl = value2 >= 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "end without matching block";
            throw new AssertionError((Object)string2);
        }
        this.numberOfNestedBlocks = value2;
    }
}

