/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataElement;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataKt;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataCharArray;", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataElement;", "name", "", "value", "", "(Ljava/lang/String;[C)V", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbol;", "", "(Ljava/lang/String;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "sizeInBytes", "", "getSizeInBytes", "()I", "getValue", "()Ljava/util/List;", "dump", "indent", "startAddress", "toBytes", "", "backend.wasm"})
public final class ConstantDataCharArray
extends ConstantDataElement {
    @NotNull
    private final String name;
    @NotNull
    private final List<WasmSymbol<Character>> value;
    private final int sizeInBytes;

    public ConstantDataCharArray(@NotNull String name, @NotNull List<WasmSymbol<Character>> value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        super(null);
        this.name = name;
        this.value = value2;
        this.sizeInBytes = this.value.size() * 2;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<WasmSymbol<Character>> getValue() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    public ConstantDataCharArray(@NotNull String name, @NotNull char[] value2) {
        Collection<WasmSymbol<Character>> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        char[] cArray = value2;
        String string2 = name;
        ConstantDataCharArray constantDataCharArray = this;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_13 = item$iv$iv = $this$mapTo$iv$iv[i];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new WasmSymbol<Character>(Character.valueOf((char)it)));
        }
        collection = (List)destination$iv$iv;
        constantDataCharArray(string2, (List<WasmSymbol<Character>>)collection);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public byte[] toBytes() {
        void $this$fold$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.value;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            WasmSymbol wasmSymbol = (WasmSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ConstantDataKt.toLittleEndianBytes(((Character)it.getOwner()).charValue()));
        }
        $this$map$iv = (List)destination$iv$iv;
        byte[] initial$iv = new byte[]{};
        boolean $i$f$fold = false;
        byte[] accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void p1;
            Object item$iv$iv;
            item$iv$iv = (byte[])element$iv;
            byte[] p0 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = ArraysKt.plus((byte[])p0, (byte[])p1);
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String dump(@NotNull String indent, int startAddress) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        if (this.value.isEmpty()) {
            return "";
        }
        Iterable iterable = this.value;
        StringBuilder stringBuilder2 = new StringBuilder().append(ConstantDataKt.access$addressToString(startAddress)).append(": ").append(indent).append(" i16[] : ");
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            WasmSymbol wasmSymbol = (WasmSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Character.valueOf(((Character)it.getOwner()).charValue()));
        }
        String string2 = Arrays.toString(CollectionsKt.toCharArray((Collection)((List)destination$iv$iv)));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this)");
        return stringBuilder2.append(string2).append("   ;; ").append(this.name).append('\n').toString();
    }

    @Override
    public int getSizeInBytes() {
        return this.sizeInBytes;
    }
}

