/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrInlineUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.JvmStaticAnnotationLoweringKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\f\u0010\u0013\u001a\u00020\b*\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/CompanionObjectJvmStaticTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "shouldReplaceWithStaticCall", "", "callee", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "needsStaticProxy", "backend.jvm.lower"})
final class CompanionObjectJvmStaticTransformer
extends IrElementTransformerVoid {
    @NotNull
    private final JvmBackendContext context;

    public CompanionObjectJvmStaticTransformer(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    private final boolean needsStaticProxy(IrSimpleFunction $this$needsStaticProxy) {
        return $this$needsStaticProxy.isExternal() ? true : (Intrinsics.areEqual((Object)$this$needsStaticProxy.getOrigin(), (Object)JvmLoweredDeclarationOrigin.SYNTHETIC_METHOD_FOR_PROPERTY_OR_TYPEALIAS_ANNOTATIONS.INSTANCE) ? false : (JvmIrInlineUtilsKt.isEffectivelyInlineOnly($this$needsStaticProxy) ? false : (Intrinsics.areEqual((Object)$this$needsStaticProxy.getVisibility(), (Object)DescriptorVisibilities.PROTECTED) && !$this$needsStaticProxy.isInline() ? true : !$this$needsStaticProxy.getOrigin().isSynthetic())));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrStatement visitClass(@NotNull IrClass declaration) {
        IrStatement irStatement;
        block4: {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            IrStatement it = irStatement = super.visitClass(declaration);
            boolean bl = false;
            Object object = AdditionalIrUtilsKt.companionObject(declaration);
            if (object == null || (object = object.getDeclarations()) == null) break block4;
            Object $this$transformInPlace$iv = object;
            boolean $i$f$transformInPlace = false;
            int n = $this$transformInPlace$iv.size();
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                IrElement irElement;
                IrElement irElement2;
                void it2;
                IrDeclaration irDeclaration2 = (IrDeclaration)$this$transformInPlace$iv.get(i$iv);
                int n2 = i$iv;
                Object object2 = $this$transformInPlace$iv;
                boolean bl2 = false;
                if (it2 instanceof IrSimpleFunction && JvmStaticAnnotationLoweringKt.access$isJvmStaticDeclaration((IrDeclaration)it2) && this.needsStaticProxy((IrSimpleFunction)it2)) {
                    Pair<IrSimpleFunction, IrSimpleFunction> pair = this.context.getCachedDeclarations().getStaticAndCompanionDeclaration((IrSimpleFunction)it2);
                    IrSimpleFunction irSimpleFunction = (IrSimpleFunction)pair.component1();
                    IrSimpleFunction companionFun = (IrSimpleFunction)pair.component2();
                    declaration.getDeclarations().add(irSimpleFunction);
                    irElement2 = companionFun;
                } else {
                    irElement2 = (IrElement)it2;
                }
                IrElement irElement3 = irElement = irElement2;
                if (irElement3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
                }
                object2.set(n2, (IrElement)((IrDeclaration)irElement3));
            }
        }
        return irStatement;
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
        if (this.shouldReplaceWithStaticCall(callee)) {
            IrSimpleFunction staticProxy = (IrSimpleFunction)this.context.getCachedDeclarations().getStaticAndCompanionDeclaration(callee).component1();
            irExpression = JvmStaticAnnotationLoweringKt.access$makeStatic(expression2, this.context.getIrBuiltIns(), staticProxy);
        } else if (Intrinsics.areEqual((Object)callee.getSymbol(), (Object)this.context.getIr().getSymbols().getIndyLambdaMetafactoryIntrinsic())) {
            IrExpression irExpression2 = expression2.getValueArgument(1);
            IrFunctionReference irFunctionReference = irExpression2 instanceof IrFunctionReference ? (IrFunctionReference)irExpression2 : null;
            if (irFunctionReference == null) {
                throw new AssertionError((Object)("'implMethodReference' is expected to be 'IrFunctionReference': " + DumpIrTreeKt.dump$default(expression2, false, false, 3, null)));
            }
            IrFunctionReference implFunRef = irFunctionReference;
            IrFunction implFun = ((IrFunctionSymbol)implFunRef.getSymbol()).getOwner();
            if (implFunRef.getDispatchReceiver() != null && implFun instanceof IrSimpleFunction && this.shouldReplaceWithStaticCall((IrSimpleFunction)implFun)) {
                IrSimpleFunction staticProxy = (IrSimpleFunction)this.context.getCachedDeclarations().getStaticAndCompanionDeclaration((IrSimpleFunction)implFun).component1();
                expression2.putValueArgument(1, new IrFunctionReferenceImpl(implFunRef.getStartOffset(), implFunRef.getEndOffset(), implFunRef.getType(), staticProxy.getSymbol(), staticProxy.getTypeParameters().size(), staticProxy.getValueParameters().size(), implFunRef.getReflectionTarget(), implFunRef.getOrigin()));
            }
            irExpression = expression2;
        } else {
            irExpression = expression2;
        }
        return irExpression;
    }

    private final boolean shouldReplaceWithStaticCall(IrSimpleFunction callee) {
        return JvmStaticAnnotationLoweringKt.access$isJvmStaticInCompanion(callee) && Intrinsics.areEqual((Object)callee.getVisibility(), (Object)DescriptorVisibilities.PROTECTED) && !JvmIrInlineUtilsKt.isInlineFunctionCall(callee, this.context);
    }
}

