/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityUtilsKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;
import org.jetbrains.kotlin.js.translate.context.InlineFunctionContext;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceFile;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006*\u00020\u0002H\u0002\u001a&\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u001a \u0010\u0011\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\f\u001a\u00020\u00022\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u001a\u001a\u0010\u0016\u001a\u00020\n*\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a\u001a\"\u0010\u001b\u001a\u00020\u000e*\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001d"}, d2={"requiresExtensionReceiverParameter", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getRequiresExtensionReceiverParameter", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Z", "getCorrectTypeParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "kotlin.jvm.PlatformType", "reportInlineFunction", "", "Lorg/jetbrains/kotlin/incremental/js/IncrementalResultsConsumer;", "descriptor", "translatedFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "sourceInfo", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "translateAndAliasParameters", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "targetList", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "translateFunction", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "wrapWithInlineMetadata", "outerContext", "js.translator"})
public final class FunctionTranslatorKt {
    @NotNull
    public static final TranslationContext translateAndAliasParameters(@NotNull TranslationContext $this$translateAndAliasParameters, @NotNull FunctionDescriptor descriptor2, @NotNull List<JsParameter> targetList2) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)$this$translateAndAliasParameters, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter(targetList2, (String)"targetList");
        Map aliases = new LinkedHashMap();
        for (TypeParameterDescriptor type2 : FunctionTranslatorKt.getCorrectTypeParameters(descriptor2)) {
            JsNameRef jsNameRef;
            JsName paramName;
            String suggestedName;
            JsName paramNameForType;
            if (!type2.isReified()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)$this$translateAndAliasParameters.getNameForDescriptor(type2), (String)"getNameForDescriptor(type)");
            ((Collection)targetList2).add(new JsParameter(paramNameForType));
            Intrinsics.checkNotNullExpressionValue((Object)Namer.isInstanceSuggestedName(type2), (String)"isInstanceSuggestedName(type)");
            Intrinsics.checkNotNullExpressionValue((Object)JsScope.declareTemporaryName(suggestedName), (String)"declareTemporaryName(suggestedName)");
            ((Collection)targetList2).add(new JsParameter(paramName));
            object2 = aliases;
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"type");
            object = type2;
            Intrinsics.checkNotNullExpressionValue((Object)paramName.makeRef(), (String)"paramName.makeRef()");
            object2.put(object, jsNameRef);
        }
        if (FunctionTranslatorKt.getRequiresExtensionReceiverParameter(descriptor2)) {
            JsName jsName = JsScope.declareTemporaryName(Namer.getReceiverParameterName());
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"declareTemporaryName(Nam\u2026tReceiverParameterName())");
            JsName receiverParameterName = jsName;
            JsNameRef jsNameRef = receiverParameterName.makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"receiverParameterName.makeRef()");
            JsNameRef receiverRef = jsNameRef;
            JsExpression jsExpression = receiverRef;
            ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
            Intrinsics.checkNotNull((Object)receiverParameterDescriptor);
            MetadataProperties.setType(jsExpression, receiverParameterDescriptor.getType());
            ReceiverParameterDescriptor receiverParameterDescriptor2 = descriptor2.getExtensionReceiverParameter();
            Intrinsics.checkNotNull((Object)receiverParameterDescriptor2);
            aliases.put(receiverParameterDescriptor2, receiverRef);
            ((Collection)targetList2).add(new JsParameter(receiverParameterName));
        }
        for (ValueParameterDescriptor valueParameter2 : descriptor2.getValueParameters()) {
            JsNameRef parameterRef;
            JsName tmpName;
            JsName name;
            Intrinsics.checkNotNullExpressionValue((Object)$this$translateAndAliasParameters.getNameForDescriptor(valueParameter2), (String)"getNameForDescriptor(valueParameter)");
            object2 = JsScope.declareTemporaryName(name.getIdent());
            JsName it = object2;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            MetadataProperties.setDescriptor(it, (DeclarationDescriptor)valueParameter2);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"declareTemporaryName(nam\u2026riptor = valueParameter }");
            Intrinsics.checkNotNullExpressionValue((Object)JsAstUtils.pureFqn(tmpName, null), (String)"pureFqn(tmpName, null)");
            MetadataProperties.setType(parameterRef, valueParameter2.getType());
            Intrinsics.checkNotNullExpressionValue((Object)valueParameter2, (String)"valueParameter");
            aliases.put(valueParameter2, parameterRef);
            object2 = targetList2;
            Object $this$translateAndAliasParameters_u24lambda_u241 = object = new JsParameter(tmpName);
            boolean bl2 = false;
            MetadataProperties.setHasDefaultValue((JsParameter)$this$translateAndAliasParameters_u24lambda_u241, ArgumentsUtilsKt.hasDefaultValue(valueParameter2));
            object2.add(object);
        }
        ValueParameterDescriptor continuationDescriptor = $this$translateAndAliasParameters.getContinuationParameterDescriptor();
        if (continuationDescriptor != null) {
            JsParameter jsParameter = new JsParameter($this$translateAndAliasParameters.getNameForDescriptor(continuationDescriptor));
            ((Collection)targetList2).add(jsParameter);
            Map map = aliases;
            JsExpression jsExpression = JsAstUtils.stateMachineReceiver();
            Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"stateMachineReceiver()");
            JsExpression jsExpression2 = jsExpression;
            map.put(continuationDescriptor, jsExpression2);
        }
        TranslationContext translationContext = $this$translateAndAliasParameters.innerContextWithDescriptorsAliased(aliases);
        Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"this.innerContextWithDescriptorsAliased(aliases)");
        return translationContext;
    }

    private static final List<TypeParameterDescriptor> getCorrectTypeParameters(FunctionDescriptor $this$getCorrectTypeParameters) {
        Object object = $this$getCorrectTypeParameters instanceof PropertyAccessorDescriptor ? (PropertyAccessorDescriptor)$this$getCorrectTypeParameters : null;
        if (object == null || (object = object.getCorrespondingProperty()) == null || (object = object.getTypeParameters()) == null) {
            object = $this$getCorrectTypeParameters.getTypeParameters();
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"(this as? PropertyAccess\u2026ameters ?: typeParameters");
        return object;
    }

    private static final boolean getRequiresExtensionReceiverParameter(FunctionDescriptor $this$requiresExtensionReceiverParameter) {
        return DescriptorUtils.isExtension($this$requiresExtensionReceiverParameter);
    }

    public static final void translateFunction(@NotNull TranslationContext $this$translateFunction, @NotNull KtDeclarationWithBody declaration, @NotNull JsFunction function2) {
        Intrinsics.checkNotNullParameter((Object)$this$translateFunction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        FunctionDescriptor functionDescriptor = BindingUtils.getFunctionDescriptor($this$translateFunction.bindingContext(), declaration);
        Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor, (String)"getFunctionDescriptor(bi\u2026ngContext(), declaration)");
        FunctionDescriptor descriptor2 = functionDescriptor;
        if (declaration.hasBody()) {
            JsBlock jsBlock = FunctionBodyTranslator.translateFunctionBody(descriptor2, declaration, $this$translateFunction);
            Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"translateFunctionBody(de\u2026iptor, declaration, this)");
            JsBlock body2 = jsBlock;
            List<JsStatement> list2 = function2.getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"function.body.statements");
            Collection collection = list2;
            List<JsStatement> list3 = body2.getStatements();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"body.statements");
            CollectionsKt.addAll((Collection)collection, (Iterable)list3);
        }
        MetadataProperties.setFunctionDescriptor(function2, descriptor2);
    }

    @NotNull
    public static final JsExpression wrapWithInlineMetadata(@NotNull TranslationContext $this$wrapWithInlineMetadata, @NotNull TranslationContext outerContext, @NotNull JsFunction function2, @NotNull FunctionDescriptor descriptor2) {
        JsExpression jsExpression;
        Intrinsics.checkNotNullParameter((Object)$this$wrapWithInlineMetadata, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)outerContext, (String)"outerContext");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        SourceElement sourceElement = descriptor2.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"descriptor.source");
        PsiElement sourceInfo = PsiSourceElementKt.getPsi(sourceElement);
        if (descriptor2.isInline()) {
            IncrementalResultsConsumer incrementalResults;
            JsExpression jsExpression2;
            JsExpression jsExpression3;
            DeclarationDescriptor declarationDescriptor = descriptor2;
            JsConfig jsConfig = $this$wrapWithInlineMetadata.getConfig();
            Intrinsics.checkNotNullExpressionValue((Object)jsConfig, (String)"config");
            if (org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt.shouldBeExported(declarationDescriptor, jsConfig)) {
                InlineMetadata metadata = InlineMetadata.Companion.compose(function2, descriptor2, $this$wrapWithInlineMetadata);
                jsExpression3 = metadata.functionWithMetadata(outerContext, sourceInfo);
            } else {
                InlineFunctionContext inlineFunctionContext = $this$wrapWithInlineMetadata.getInlineFunctionContext();
                Intrinsics.checkNotNull((Object)inlineFunctionContext);
                InlineFunctionContext it = inlineFunctionContext;
                boolean bl = false;
                List<JsStatement> list2 = it.getImportBlock().getStatements();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"it.importBlock.statements");
                Collection collection = list2;
                List<JsStatement> list3 = it.getPrototypeBlock().getStatements();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"it.prototypeBlock.statements");
                Collection collection2 = CollectionsKt.plus((Collection)collection, (Iterable)list3);
                List<JsStatement> list4 = it.getDeclarationsBlock().getStatements();
                Intrinsics.checkNotNullExpressionValue(list4, (String)"it.declarationsBlock.statements");
                JsBlock block = new JsBlock(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection2, (Iterable)list4), (Object)new JsReturn(function2)));
                jsExpression3 = InlineMetadata.Companion.wrapFunction(outerContext, new FunctionWithWrapper(function2, block), sourceInfo);
            }
            JsExpression it = jsExpression2 = jsExpression3;
            boolean bl = false;
            IncrementalResultsConsumer incrementalResultsConsumer = incrementalResults = $this$wrapWithInlineMetadata.getConfig().getConfiguration().get(JSConfigurationKeys.INCREMENTAL_RESULTS_CONSUMER);
            if (incrementalResultsConsumer != null) {
                FunctionTranslatorKt.reportInlineFunction(incrementalResultsConsumer, descriptor2, it, sourceInfo);
            }
            jsExpression = jsExpression2;
        } else {
            jsExpression = function2;
        }
        return jsExpression;
    }

    private static final void reportInlineFunction(IncrementalResultsConsumer $this$reportInlineFunction, FunctionDescriptor descriptor2, JsExpression translatedFunction, PsiElement sourceInfo) {
        String string2;
        SourceFile sourceFile = descriptor2.getSource().getContainingFile();
        Object object = sourceFile instanceof PsiSourceFile ? (PsiSourceFile)sourceFile : null;
        if (object == null || (object = ((PsiSourceFile)object).getPsiFile()) == null) {
            return;
        }
        Object psiFile = object;
        File file2 = VfsUtilCore.virtualToIoFile(psiFile.getVirtualFile());
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"virtualToIoFile(psiFile.virtualFile)");
        File file3 = file2;
        DescriptorVisibility descriptorVisibility = descriptor2.getVisibility();
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"descriptor.visibility");
        if (EffectiveVisibilityUtilsKt.effectiveVisibility(descriptorVisibility, descriptor2, true).getPrivateApi()) {
            return;
        }
        FunctionDescriptor functionDescriptor = descriptor2;
        if (functionDescriptor instanceof PropertyGetterDescriptor) {
            StringBuilder stringBuilder2 = new StringBuilder().append("<get>");
            PropertyDescriptor propertyDescriptor = ((PropertyGetterDescriptor)descriptor2).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"descriptor.correspondingProperty");
            string2 = stringBuilder2.append(DescriptorUtilsKt.getFqNameSafe(propertyDescriptor).asString()).toString();
        } else if (functionDescriptor instanceof PropertySetterDescriptor) {
            StringBuilder stringBuilder3 = new StringBuilder().append("<set>");
            PropertyDescriptor propertyDescriptor = ((PropertySetterDescriptor)descriptor2).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"descriptor.correspondingProperty");
            string2 = stringBuilder3.append(DescriptorUtilsKt.getFqNameSafe(propertyDescriptor).asString()).toString();
        } else {
            String string3 = DescriptorUtilsKt.getFqNameSafe(descriptor2).asString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"descriptor.fqNameSafe.asString()");
        }
        String fqName2 = string2;
        UserDataHolder userDataHolder = sourceInfo;
        Integer offset2 = userDataHolder != null && (userDataHolder = userDataHolder.getNode()) != null ? Integer.valueOf(userDataHolder.getStartOffset()) : null;
        Document document2 = psiFile.getViewProvider().getDocument();
        int sourceLine = -1;
        int sourceColumn = -1;
        if (offset2 != null && document2 != null) {
            sourceLine = document2.getLineNumber(offset2);
            sourceColumn = offset2 - document2.getLineStartOffset(sourceLine);
        }
        $this$reportInlineFunction.processInlineFunction(file3, fqName2, translatedFunction, sourceLine, sourceColumn);
    }
}

