/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunInterfaceConstructorReferenceChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirFunInterfaceConstructorReferenceChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirFunInterfaceConstructorReferenceChecker INSTANCE = new FirFunInterfaceConstructorReferenceChecker();

    private FirFunInterfaceConstructorReferenceChecker() {
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(expression2 instanceof FirCallableReferenceAccess)) {
            return;
        }
        if (context.getLanguageVersionSettings().supportsFeature(LanguageFeature.KotlinFunInterfaceConstructorReference)) {
            return;
        }
        FirResolvedNamedReference firResolvedNamedReference = UtilsKt.getResolved(((FirCallableReferenceAccess)expression2).getCalleeReference());
        if (firResolvedNamedReference == null) {
            return;
        }
        FirResolvedNamedReference reference = firResolvedNamedReference;
        FirBasedSymbol<?> referredSymbol = reference.getResolvedSymbol();
        if (referredSymbol instanceof FirNamedFunctionSymbol && Intrinsics.areEqual((Object)referredSymbol.getOrigin(), (Object)FirDeclarationOrigin.SamConstructor.INSTANCE)) {
            FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol(((FirNamedFunctionSymbol)referredSymbol).getResolvedReturnTypeRef(), context.getSession());
            if (firRegularClassSymbol == null) {
                return;
            }
            FirRegularClassSymbol samClassSymbol = firRegularClassSymbol;
            FirClassSymbol $this$isFun$iv = samClassSymbol;
            boolean $i$f$isFun = false;
            if ($this$isFun$iv.getRawStatus().isFun()) {
                FirBasedSymbol $this$isJavaOrEnhancement$iv = samClassSymbol;
                boolean $i$f$isJavaOrEnhancement = false;
                if (!($this$isJavaOrEnhancement$iv.getOrigin() instanceof FirDeclarationOrigin.Java || Intrinsics.areEqual((Object)$this$isJavaOrEnhancement$iv.getOrigin(), (Object)FirDeclarationOrigin.Enhancement.INSTANCE))) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)reference.getSource(), FirErrors.INSTANCE.getFUN_INTERFACE_CONSTRUCTOR_REFERENCE(), (DiagnosticContext)context, null, 8, null);
                }
            }
        }
    }
}

