/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference;
import org.jetbrains.kotlin.fir.resolve.dfa.FirControlFlowGraphReferenceImplKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.BlockExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionReturnChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkHasReturnIfBlock", "checkers"})
public final class FirFunctionReturnChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirFunctionReturnChecker INSTANCE = new FirFunctionReturnChecker();

    private FirFunctionReturnChecker() {
    }

    @Override
    public void check(@NotNull FirFunction declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.checkHasReturnIfBlock(declaration, reporter, context);
    }

    private final void checkHasReturnIfBlock(FirFunction declaration, DiagnosticReporter reporter, CheckerContext context) {
        CFGNode<?> cFGNode;
        block8: {
            if (declaration instanceof FirPropertyAccessor && ((FirPropertyAccessor)declaration).isSetter()) {
                return;
            }
            if (declaration instanceof FirConstructor) {
                return;
            }
            if (declaration instanceof FirAnonymousFunction && ((FirAnonymousFunction)declaration).isLambda()) {
                return;
            }
            if (FirTypeUtilsKt.isUnit(declaration.getReturnTypeRef()) || FirTypeUtilsKt.isNothing(declaration.getReturnTypeRef())) {
                return;
            }
            Object object = declaration.getControlFlowGraphReference();
            if (object == null || (object = FirControlFlowGraphReferenceImplKt.getControlFlowGraph((FirControlFlowGraphReference)object)) == null) {
                return;
            }
            Object graph2 = object;
            List<CFGNode<?>> $this$lastOrNull$iv = ((ControlFlowGraph)graph2).getExitNode().getPreviousNodes();
            boolean $i$f$lastOrNull = false;
            ListIterator<CFGNode<?>> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                CFGNode<?> element$iv;
                CFGNode<?> it = element$iv = iterator$iv.previous();
                boolean bl = false;
                if (!(it instanceof BlockExitNode)) continue;
                cFGNode = element$iv;
                break block8;
            }
            cFGNode = null;
        }
        CFGNode cFGNode2 = cFGNode;
        if (cFGNode2 == null) {
            return;
        }
        CFGNode blockExitNode = cFGNode2;
        if (!blockExitNode.isDead()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getNO_RETURN_IN_FUNCTION_WITH_BLOCK_BODY(), (DiagnosticContext)context, null, 8, null);
        }
    }
}

