/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.resolve.jvm.checkers.PolymorphicSignatureCallChecker;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0016J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0011H\u0002J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u000f*\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/PolymorphicSignatureLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "isCast", "", "transform", "castReturnType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "backend.jvm.lower"})
public final class PolymorphicSignatureLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public PolymorphicSignatureLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        if (this.context.getState().getLanguageVersionSettings().supportsFeature(LanguageFeature.PolymorphicSignature)) {
            this.transformChildrenVoid(irFile);
        }
    }

    private final boolean isCast(IrTypeOperatorCall $this$isCast) {
        return $this$isCast.getOperator() != IrTypeOperator.INSTANCEOF && $this$isCast.getOperator() != IrTypeOperator.NOT_INSTANCEOF;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrExpression irExpression2 = expression2.getArgument();
        IrCall irCall = irExpression2 instanceof IrCall ? (IrCall)irExpression2 : null;
        if (irCall != null) {
            IrCall irCall2;
            IrCall it = irCall2 = irCall;
            boolean bl = false;
            irCall = this.isCast(expression2) && IrTypePredicatesKt.isNullableAny(it.getType()) ? irCall2 : null;
            if (irCall != null && (irCall = this.transform(irCall, expression2.getTypeOperand())) != null) {
                irExpression = irCall;
                return irExpression;
            }
        }
        irExpression = super.visitTypeOperator(expression2);
        return irExpression;
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrCall irCall = this.transform(expression2, null);
        return irCall != null ? (IrExpression)irCall : super.visitCall(expression2);
    }

    /*
     * WARNING - void declaration
     */
    private final IrCall transform(IrCall $this$transform, IrType castReturnType) {
        List list2;
        IrExpression it;
        boolean bl;
        Object b = $this$transform.getSymbol().getOwner();
        IrSimpleFunction irSimpleFunction = b instanceof IrSimpleFunction ? (IrSimpleFunction)b : null;
        if (irSimpleFunction == null) {
            return null;
        }
        IrSimpleFunction function2 = irSimpleFunction;
        if (!IrUtilsKt.hasAnnotation((IrAnnotationContainer)function2, PolymorphicSignatureCallChecker.polymorphicSignatureFqName)) {
            return null;
        }
        IrValueParameter irValueParameter = (IrValueParameter)CollectionsKt.singleOrNull(function2.getValueParameters());
        boolean bl2 = bl = (irValueParameter != null ? irValueParameter.getVarargElementType() : null) != null;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-PolymorphicSignatureLowering$transform$22 = false;
            String $i$a$-assert-PolymorphicSignatureLowering$transform$22 = "@PolymorphicSignature methods should only have a single vararg argument: " + DumpIrTreeKt.dump$default($this$transform, false, false, 3, null);
            throw new AssertionError((Object)$i$a$-assert-PolymorphicSignatureLowering$transform$22);
        }
        Object object = (IrVararg)$this$transform.getValueArgument(0);
        if (object != null && (object = ((IrVararg)object).getElements()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IrExpression irExpression;
                IrVarargElement irVarargElement = (IrVarargElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                IrExpression irExpression2 = it;
                if (irExpression2 instanceof IrExpression) {
                    irExpression = it;
                } else if (irExpression2 instanceof IrSpreadElement) {
                    irExpression = ((IrSpreadElement)((Object)it)).getExpression();
                } else {
                    throw new AssertionError((Object)("unknown IrVarargElement: " + it));
                }
                collection.add(irExpression);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List values2 = list2;
        IrFactory $this$buildFun$iv = this.context.getIrFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2418$iv = new IrFunctionBuilder();
        boolean $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = false;
        IrFunctionBuilder $this$transform_u24lambda_u2462 = $this$buildFun_u24lambda_u2418$iv;
        boolean bl4 = false;
        $this$transform_u24lambda_u2462.updateFrom(function2);
        $this$transform_u24lambda_u2462.setName(function2.getName());
        $this$transform_u24lambda_u2462.setOrigin(JvmLoweredDeclarationOrigin.POLYMORPHIC_SIGNATURE_INSTANTIATION.INSTANCE);
        IrType irType = castReturnType;
        if (irType == null) {
            irType = function2.getReturnType();
        }
        $this$transform_u24lambda_u2462.setReturnType(irType);
        IrElementBase irElementBase = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u2418$iv);
        IrSimpleFunction $this$transform_u24lambda_u244 = irElementBase;
        boolean bl5 = false;
        $this$transform_u24lambda_u244.setParent(function2.getParent());
        IrUtilsKt.copyTypeParametersFrom$default($this$transform_u24lambda_u244, function2, null, null, 6, null);
        $this$transform_u24lambda_u244.setDispatchReceiverParameter(function2.getDispatchReceiverParameter());
        $this$transform_u24lambda_u244.setExtensionReceiverParameter(function2.getExtensionReceiverParameter());
        Iterator $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = values2.iterator();
        int $this$transform_u24lambda_u2462 = 0;
        while ($i$a$-run-DeclarationBuildersKt$buildFun$1$iv22.hasNext()) {
            int i = $this$transform_u24lambda_u2462++;
            IrExpression value2 = (IrExpression)$i$a$-run-DeclarationBuildersKt$buildFun$1$iv22.next();
            DeclarationBuildersKt.addValueParameter((IrFunction)$this$transform_u24lambda_u244, "" + '$' + i, value2.getType(), (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.POLYMORPHIC_SIGNATURE_INSTANTIATION.INSTANCE);
        }
        IrSimpleFunction fakeFunction = irElementBase;
        IrElementBase $this$transform_u24lambda_u245 = irElementBase = IrCallImpl.Companion.fromSymbolOwner$default(IrCallImpl.Companion, $this$transform.getStartOffset(), $this$transform.getEndOffset(), fakeFunction.getReturnType(), fakeFunction.getSymbol(), 0, 0, $this$transform.getOrigin(), $this$transform.getSuperQualifierSymbol(), 48, null);
        boolean bl6 = false;
        IrMemberAccessExpressionKt.copyTypeArgumentsFrom$default((IrMemberAccessExpression)$this$transform_u24lambda_u245, $this$transform, 0, 2, null);
        ((IrMemberAccessExpression)$this$transform_u24lambda_u245).setDispatchReceiver($this$transform.getDispatchReceiver());
        ((IrMemberAccessExpression)$this$transform_u24lambda_u245).setExtensionReceiver($this$transform.getExtensionReceiver());
        Iterable $this$forEachIndexed$iv = values2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void p1;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            it = (IrExpression)item$iv;
            int p0 = n;
            boolean bl7 = false;
            ((IrMemberAccessExpression)$this$transform_u24lambda_u245).putValueArgument(p0, (IrExpression)p1);
        }
        this.transformChildrenVoid($this$transform_u24lambda_u245);
        return (IrCall)irElementBase;
    }
}

