/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.container.DefaultImplementation;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.UpperBoundViolatedReporter;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@DefaultImplementation(impl=UpperBoundChecker.class)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015J>\u0010\u0010\u001a\u00020\u00112\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J \u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;", "", "()V", "checkBound", "", "bound", "Lorg/jetbrains/kotlin/types/KotlinType;", "argumentType", "argumentReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "substitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "typeAliasUsageElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "upperBoundViolatedReporter", "Lorg/jetbrains/kotlin/resolve/UpperBoundViolatedReporter;", "checkBounds", "", "typeReference", "type", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "typeParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "checkBoundsOfExpandedTypeAlias", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "frontend"})
public class UpperBoundChecker {
    public void checkBoundsOfExpandedTypeAlias(@NotNull KotlinType type2, @NotNull KtExpression expression2, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
    }

    public void checkBounds(@Nullable KtTypeReference argumentReference, @NotNull KotlinType argumentType, @NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull TypeSubstitutor substitutor2, @NotNull BindingTrace trace, @Nullable KtElement typeAliasUsageElement) {
        Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
        Intrinsics.checkNotNullParameter((Object)typeParameterDescriptor, (String)"typeParameterDescriptor");
        Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        if (typeParameterDescriptor.getUpperBounds().isEmpty()) {
            return;
        }
        UpperBoundViolatedReporter diagnosticsReporter = new UpperBoundViolatedReporter(trace, argumentType, typeParameterDescriptor, null, null, 24, null);
        for (KotlinType bound : typeParameterDescriptor.getUpperBounds()) {
            Intrinsics.checkNotNullExpressionValue((Object)bound, (String)"bound");
            this.checkBound(bound, argumentType, argumentReference, substitutor2, typeAliasUsageElement, diagnosticsReporter);
        }
    }

    public static /* synthetic */ void checkBounds$default(UpperBoundChecker upperBoundChecker, KtTypeReference ktTypeReference, KotlinType kotlinType, TypeParameterDescriptor typeParameterDescriptor, TypeSubstitutor typeSubstitutor2, BindingTrace bindingTrace, KtElement ktElement, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkBounds");
        }
        if ((n & 0x20) != 0) {
            ktElement = null;
        }
        upperBoundChecker.checkBounds(ktTypeReference, kotlinType, typeParameterDescriptor, typeSubstitutor2, bindingTrace, ktElement);
    }

    public final void checkBounds(@NotNull KtTypeReference typeReference, @NotNull KotlinType type2, @NotNull BindingTrace trace) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)typeReference, (String)"typeReference");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        if (KotlinTypeKt.isError(type2)) {
            return;
        }
        KtTypeElement ktTypeElement = typeReference.getTypeElement();
        if (ktTypeElement == null) {
            return;
        }
        KtTypeElement typeElement = ktTypeElement;
        List<TypeParameterDescriptor> list2 = type2.getConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"type.constructor.parameters");
        List<TypeParameterDescriptor> parameters2 = list2;
        List<TypeProjection> arguments2 = type2.getArguments();
        boolean bl2 = bl = parameters2.size() == arguments2.size();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        List<KtTypeReference> list3 = typeElement.getTypeArgumentsAsTypes();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"typeElement.typeArgumentsAsTypes");
        List<KtTypeReference> ktTypeArguments = list3;
        if (FlexibleTypesKt.isFlexible(type2) && !DynamicTypesKt.isDynamic(type2)) {
            boolean bl3;
            boolean bl4 = bl3 = ktTypeArguments.size() == 2;
            if (_Assertions.ENABLED && !bl3) {
                boolean $i$a$-assert-UpperBoundChecker$checkBounds$22 = false;
                String $i$a$-assert-UpperBoundChecker$checkBounds$22 = "Flexible type cannot be denoted in Kotlin otherwise than as ft<T1, T2>, but was: " + PsiUtilsKt.getElementTextWithContext(typeReference);
                throw new AssertionError((Object)$i$a$-assert-UpperBoundChecker$checkBounds$22);
            }
            FlexibleType flexibleType = FlexibleTypesKt.asFlexibleType(type2);
            KtTypeReference ktTypeReference = ktTypeArguments.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference, (String)"ktTypeArguments[0]");
            this.checkBounds(ktTypeReference, flexibleType.getLowerBound(), trace);
            KtTypeReference ktTypeReference2 = ktTypeArguments.get(1);
            Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference2, (String)"ktTypeArguments[1]");
            this.checkBounds(ktTypeReference2, flexibleType.getUpperBound(), trace);
            return;
        }
        if (ktTypeArguments.size() != arguments2.size()) {
            return;
        }
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(type2);
        Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor2, (String)"create(type)");
        TypeSubstitutor substitutor2 = typeSubstitutor2;
        int n = ktTypeArguments.size();
        for (int i = 0; i < n; ++i) {
            KtTypeReference ktTypeArgument;
            if (ktTypeArguments.get(i) == null) continue;
            KotlinType kotlinType = arguments2.get(i).getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"arguments[i].type");
            this.checkBounds(ktTypeArgument, kotlinType, trace);
            KotlinType kotlinType2 = arguments2.get(i).getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"arguments[i].type");
            TypeParameterDescriptor typeParameterDescriptor = parameters2.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)typeParameterDescriptor, (String)"parameters[i]");
            UpperBoundChecker.checkBounds$default(this, ktTypeArgument, kotlinType2, typeParameterDescriptor, substitutor2, trace, null, 32, null);
        }
    }

    protected final boolean checkBound(@NotNull KotlinType bound, @NotNull KotlinType argumentType, @Nullable KtTypeReference argumentReference, @NotNull TypeSubstitutor substitutor2, @Nullable KtElement typeAliasUsageElement, @NotNull UpperBoundViolatedReporter upperBoundViolatedReporter) {
        Intrinsics.checkNotNullParameter((Object)bound, (String)"bound");
        Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
        Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
        Intrinsics.checkNotNullParameter((Object)upperBoundViolatedReporter, (String)"upperBoundViolatedReporter");
        KotlinType kotlinType = substitutor2.safeSubstitute(bound, Variance.INVARIANT);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"substitutor.safeSubstitu\u2026ound, Variance.INVARIANT)");
        KotlinType substitutedBound = kotlinType;
        if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(argumentType, substitutedBound)) {
            if (argumentReference != null) {
                upperBoundViolatedReporter.report(argumentReference, substitutedBound);
            } else if (typeAliasUsageElement != null && !TypeUtilsKt.containsTypeAliasParameters(substitutedBound) && !TypeUtilsKt.containsTypeAliasParameters(argumentType)) {
                upperBoundViolatedReporter.reportForTypeAliasExpansion(typeAliasUsageElement, substitutedBound);
            }
            return false;
        }
        return true;
    }

    public static /* synthetic */ boolean checkBound$default(UpperBoundChecker upperBoundChecker, KotlinType kotlinType, KotlinType kotlinType2, KtTypeReference ktTypeReference, TypeSubstitutor typeSubstitutor2, KtElement ktElement, UpperBoundViolatedReporter upperBoundViolatedReporter, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkBound");
        }
        if ((n & 0x10) != 0) {
            ktElement = null;
        }
        return upperBoundChecker.checkBound(kotlinType, kotlinType2, ktTypeReference, typeSubstitutor2, ktElement, upperBoundViolatedReporter);
    }
}

