/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.resolve.calls.ArgumentsKt;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.ReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionStage;
import org.jetbrains.kotlin.fir.resolve.inference.ConstraintSystemCompleterKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/CheckExtensionReceiver;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionStage;", "()V", "check", "", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getReceiverType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "resolve"})
public final class CheckExtensionReceiver
extends ResolutionStage {
    @NotNull
    public static final CheckExtensionReceiver INSTANCE = new CheckExtensionReceiver();

    private CheckExtensionReceiver() {
    }

    @Override
    @Nullable
    public Object check(@NotNull Candidate candidate2, @NotNull CallInfo callInfo, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, @NotNull Continuation<? super Unit> $completion) {
        ConeKotlinType coneKotlinType = this.getReceiverType(candidate2, context2);
        if (coneKotlinType == null) {
            return Unit.INSTANCE;
        }
        ConeKotlinType expectedReceiverType = coneKotlinType;
        ReceiverValue receiverValue = candidate2.getExtensionReceiverValue();
        if (receiverValue == null) {
            return Unit.INSTANCE;
        }
        ReceiverValue argumentExtensionReceiverValue = receiverValue;
        ConeKotlinType expectedType = candidate2.getSubstitutor().substituteOrSelf(expectedReceiverType.getType());
        ConeKotlinType argumentType = ArgumentsKt.captureFromTypeParameterUpperBoundIfNeeded(argumentExtensionReceiverValue.getType(), expectedType, context2.getSession());
        ArgumentsKt.resolvePlainArgumentType$default(candidate2, ConstraintSystemCompleterKt.getCsBuilder(candidate2), argumentExtensionReceiverValue.getReceiverExpression(), argumentType, expectedType, sink, context2, true, false, false, 256, null);
        CheckerSink $this$yieldIfNeed$iv = sink;
        boolean $i$f$yieldIfNeed = false;
        if ($this$yieldIfNeed$iv.getNeedYielding()) {
            Object object = $this$yieldIfNeed$iv.yield($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
        }
        return Unit.INSTANCE;
    }

    private final ConeKotlinType getReceiverType(Candidate $this$getReceiverType, ResolutionContext context2) {
        ConeKotlinType receiverType;
        FirBasedSymbol<?> firBasedSymbol = $this$getReceiverType.getSymbol();
        FirCallableSymbol firCallableSymbol = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
        if (firCallableSymbol == null) {
            return null;
        }
        FirCallableSymbol callableSymbol = firCallableSymbol;
        FirCallableDeclaration callable = (FirCallableDeclaration)callableSymbol.getFir();
        FirTypeRef firTypeRef = callable.getReceiverTypeRef();
        ConeKotlinType coneKotlinType = receiverType = firTypeRef != null ? FirTypeUtilsKt.getConeType(firTypeRef) : null;
        if (receiverType != null) {
            return receiverType;
        }
        Object object = callable.getReturnTypeRef();
        FirResolvedTypeRef firResolvedTypeRef = object instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)object : null;
        if (firResolvedTypeRef == null) {
            return null;
        }
        FirResolvedTypeRef returnTypeRef = firResolvedTypeRef;
        if (!TypeUtilsKt.isExtensionFunctionType(returnTypeRef.getType(), context2.getSession())) {
            return null;
        }
        object = ArraysKt.firstOrNull((Object[])returnTypeRef.getType().getTypeArguments());
        ConeKotlinTypeProjection coneKotlinTypeProjection = object instanceof ConeKotlinTypeProjection ? (ConeKotlinTypeProjection)object : null;
        return coneKotlinTypeProjection != null ? coneKotlinTypeProjection.getType() : null;
    }
}

