/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.ir;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredStatementOrigin;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u000b\u001a\u00020\u0006*\u00020\f\u001a\u0014\u0010\r\u001a\u00020\u0006*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0012\u0010\u0011\u001a\u00020\u0006*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\n\u0010\u0012\u001a\u00020\u0006*\u00020\u000e\u001a\n\u0010\u0013\u001a\u00020\u0006*\u00020\u0014\u001a\n\u0010\u0015\u001a\u00020\u0006*\u00020\u000e\u001a\n\u0010\u0016\u001a\u00020\u0006*\u00020\u000e\u001a\f\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\u0019\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\"\u0018\u0010\b\u001a\u00020\u0002*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"inlineScopeVisibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getInlineScopeVisibility", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "isInPublicInlineScope", "", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Z", "original", "getOriginal", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "isEffectivelyInlineOnly", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithVisibility;", "isInlineArrayConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "isInlineFunctionCall", "isInlineOnly", "isInlineParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "isPrivateInlineSuspend", "isReifiable", "unwrapInlineLambda", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "Lorg/jetbrains/kotlin/ir/IrStatement;", "backend.jvm"})
public final class JvmIrInlineUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInlineParameter(@NotNull IrValueParameter $this$isInlineParameter) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineParameter, (String)"<this>");
        if ($this$isInlineParameter.getIndex() < 0) return false;
        if ($this$isInlineParameter.isNoinline()) return false;
        if (!IrTypeUtilsKt.isFunction($this$isInlineParameter.getType())) {
            if (!IrTypeUtilsKt.isSuspendFunction($this$isInlineParameter.getType())) return false;
        }
        if (!org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable($this$isInlineParameter.getType())) return true;
        IrExpressionBody irExpressionBody = $this$isInlineParameter.getDefaultValue();
        Object object = irExpressionBody;
        if (irExpressionBody == null) return false;
        IrExpression irExpression = ((IrExpressionBody)object).getExpression();
        object = irExpression;
        if (irExpression == null) return false;
        IrType irType = ((IrExpression)object).getType();
        object = irType;
        if (irType == null) return false;
        if (org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable((IrType)object)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final DescriptorVisibility getInlineScopeVisibility(@NotNull IrDeclaration $this$inlineScopeVisibility) {
        Intrinsics.checkNotNullParameter((Object)$this$inlineScopeVisibility, (String)"<this>");
        IrDeclaration owner = JvmIrInlineUtilsKt.getOriginal($this$inlineScopeVisibility);
        DescriptorVisibility result2 = null;
        while (owner != null) {
            if (owner instanceof IrFunction && ((IrFunction)owner).isInline()) {
                DescriptorVisibility descriptorVisibility;
                if (!DescriptorVisibilities.isPrivate(((IrFunction)owner).getVisibility())) {
                    boolean bl;
                    Object object = IrUtilsKt.getParentClassOrNull(owner);
                    if (object != null && (object = object.getVisibility()) != null) {
                        Object p0 = object;
                        boolean bl2 = false;
                        bl = DescriptorVisibilities.isPrivate((DescriptorVisibility)p0);
                    } else {
                        bl = false;
                    }
                    if (!bl) return ((IrFunction)owner).getVisibility();
                    descriptorVisibility = DescriptorVisibilities.PRIVATE;
                } else {
                    descriptorVisibility = ((IrFunction)owner).getVisibility();
                }
                result2 = descriptorVisibility;
            }
            IrDeclarationParent $this$safeAs$iv = owner.getParent();
            boolean $i$f$safeAs = false;
            IrDeclarationParent irDeclarationParent = $this$safeAs$iv;
            if (!(irDeclarationParent instanceof IrDeclaration)) {
                irDeclarationParent = null;
            }
            IrDeclaration irDeclaration2 = (IrDeclaration)((Object)irDeclarationParent);
            owner = irDeclaration2 != null ? JvmIrInlineUtilsKt.getOriginal(irDeclaration2) : null;
        }
        return result2;
    }

    public static final boolean isInPublicInlineScope(@NotNull IrDeclaration $this$isInPublicInlineScope) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isInPublicInlineScope, (String)"<this>");
        DescriptorVisibility descriptorVisibility = JvmIrInlineUtilsKt.getInlineScopeVisibility($this$isInPublicInlineScope);
        if (descriptorVisibility != null) {
            DescriptorVisibility p0 = descriptorVisibility;
            boolean bl2 = false;
            bl = !DescriptorVisibilities.isPrivate(p0);
        } else {
            bl = false;
        }
        return bl;
    }

    private static final IrDeclaration getOriginal(IrDeclaration $this$original) {
        IrAttributeContainer irAttributeContainer = $this$original instanceof IrAttributeContainer ? (IrAttributeContainer)((Object)$this$original) : null;
        IrAttributeContainer irAttributeContainer2 = irAttributeContainer != null ? irAttributeContainer.getAttributeOwnerId() : null;
        IrDeclaration irDeclaration2 = irAttributeContainer2 instanceof IrDeclaration ? (IrDeclaration)((Object)irAttributeContainer2) : null;
        if (irDeclaration2 == null) {
            irDeclaration2 = $this$original;
        }
        return irDeclaration2;
    }

    @Nullable
    public static final IrFunctionReference unwrapInlineLambda(@NotNull IrStatement $this$unwrapInlineLambda) {
        IrFunctionReference irFunctionReference;
        Intrinsics.checkNotNullParameter((Object)$this$unwrapInlineLambda, (String)"<this>");
        IrStatement irStatement = $this$unwrapInlineLambda;
        if (irStatement instanceof IrBlock) {
            IrStatement irStatement2 = (IrStatement)CollectionsKt.lastOrNull(((IrBlock)$this$unwrapInlineLambda).getStatements());
            irFunctionReference = irStatement2 != null ? JvmIrInlineUtilsKt.unwrapInlineLambda(irStatement2) : null;
        } else if (irStatement instanceof IrFunctionReference) {
            IrStatement irStatement3 = $this$unwrapInlineLambda;
            IrFunctionReference it = (IrFunctionReference)irStatement3;
            boolean bl = false;
            irFunctionReference = (IrFunctionReference)(Intrinsics.areEqual((Object)it.getOrigin(), (Object)JvmLoweredStatementOrigin.INLINE_LAMBDA.INSTANCE) ? irStatement3 : null);
        } else {
            irFunctionReference = null;
        }
        return irFunctionReference;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInlineFunctionCall(@NotNull IrFunction $this$isInlineFunctionCall, @NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineFunctionCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.getState().isInlineDisabled()) {
            IrTypeParameter it;
            Iterable $this$any$iv = $this$isInlineFunctionCall.getTypeParameters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                it = (IrTypeParameter)element$iv;
                boolean bl = false;
            } while (!it.isReified());
            boolean bl = true;
            if (!bl) return false;
        }
        if ($this$isInlineFunctionCall.isInline()) return true;
        if (!JvmIrInlineUtilsKt.isInlineArrayConstructor($this$isInlineFunctionCall, context2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isInlineArrayConstructor(IrFunction $this$isInlineArrayConstructor, JvmBackendContext context2) {
        if (!($this$isInlineArrayConstructor instanceof IrConstructor)) return false;
        if ($this$isInlineArrayConstructor.getValueParameters().size() != 2) return false;
        IrClassSymbol it = AdditionalIrUtilsKt.getConstructedClass((IrConstructor)$this$isInlineArrayConstructor).getSymbol();
        boolean bl = false;
        if (Intrinsics.areEqual((Object)it, (Object)context2.getIrBuiltIns().getArrayClass())) return true;
        if (!context2.getIrBuiltIns().getPrimitiveArraysToPrimitiveTypes().containsKey(it)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInlineOnly(@NotNull IrFunction $this$isInlineOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineOnly, (String)"<this>");
        if ($this$isInlineOnly.isInline()) {
            if (IrUtilsKt.hasAnnotation((IrAnnotationContainer)$this$isInlineOnly, InlineOnlyKt.getINLINE_ONLY_ANNOTATION_FQ_NAME())) return true;
        }
        if (!($this$isInlineOnly instanceof IrSimpleFunction)) return false;
        IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)$this$isInlineOnly).getCorrespondingPropertySymbol();
        Object object = irPropertySymbol;
        if (irPropertySymbol == null) return false;
        IrProperty irProperty2 = (IrProperty)object.getOwner();
        object = irProperty2;
        if (irProperty2 == null) return false;
        if (!IrUtilsKt.hasAnnotation((IrAnnotationContainer)object, InlineOnlyKt.getINLINE_ONLY_ANNOTATION_FQ_NAME())) return false;
        return true;
    }

    public static final boolean isEffectivelyInlineOnly(@NotNull IrDeclarationWithVisibility $this$isEffectivelyInlineOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$isEffectivelyInlineOnly, (String)"<this>");
        return $this$isEffectivelyInlineOnly instanceof IrFunction && (JvmIrInlineUtilsKt.isReifiable((IrFunction)$this$isEffectivelyInlineOnly) || JvmIrInlineUtilsKt.isInlineOnly((IrFunction)$this$isEffectivelyInlineOnly) || JvmIrInlineUtilsKt.isPrivateInlineSuspend((IrFunction)$this$isEffectivelyInlineOnly));
    }

    public static final boolean isPrivateInlineSuspend(@NotNull IrFunction $this$isPrivateInlineSuspend) {
        Intrinsics.checkNotNullParameter((Object)$this$isPrivateInlineSuspend, (String)"<this>");
        return AdditionalIrUtilsKt.isSuspend($this$isPrivateInlineSuspend) && $this$isPrivateInlineSuspend.isInline() && Intrinsics.areEqual((Object)$this$isPrivateInlineSuspend.getVisibility(), (Object)DescriptorVisibilities.PRIVATE);
    }

    public static final boolean isReifiable(@NotNull IrFunction $this$isReifiable) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isReifiable, (String)"<this>");
            Iterable $this$any$iv = $this$isReifiable.getTypeParameters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrTypeParameter it = (IrTypeParameter)element$iv;
                    boolean bl2 = false;
                    if (!it.isReified()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

