/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.buildtools.internal.compat;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.buildtools.api.CompilationService;
import org.jetbrains.kotlin.buildtools.api.KotlinLogger;
import org.jetbrains.kotlin.buildtools.api.ProjectId;
import org.jetbrains.kotlin.buildtools.api.internal.BaseOption;
import org.jetbrains.kotlin.buildtools.api.jvm.ClassSnapshotGranularity;
import org.jetbrains.kotlin.buildtools.api.jvm.ClasspathEntrySnapshot;
import org.jetbrains.kotlin.buildtools.api.jvm.operations.JvmClasspathSnapshottingOperation;
import org.jetbrains.kotlin.buildtools.internal.compat.BaseOptionWithDefault;
import org.jetbrains.kotlin.buildtools.internal.compat.BuildOperationImpl;
import org.jetbrains.kotlin.buildtools.internal.compat.ExecutionPolicyV1Adapter;
import org.jetbrains.kotlin.buildtools.internal.compat.Options;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002#$B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\"\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0013H\u0096\u0002\u00a2\u0006\u0002\u0010\u0014J*\u0010\u0015\u001a\u00020\u0016\"\u0004\b\u0000\u0010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00132\u0006\u0010\u0017\u001a\u0002H\u0011H\u0096\u0002\u00a2\u0006\u0002\u0010\u0018J\"\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0019H\u0086\u0002\u00a2\u0006\u0002\u0010\u001aJ*\u0010\u0015\u001a\u00020\u0016\"\u0004\b\u0000\u0010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00192\u0006\u0010\u0017\u001a\u0002H\u0011H\u0086\u0002\u00a2\u0006\u0002\u0010\u001bJ\"\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/compat/JvmClasspathSnapshottingOperationV1Adapter;", "Lorg/jetbrains/kotlin/buildtools/internal/compat/BuildOperationImpl;", "Lorg/jetbrains/kotlin/buildtools/api/jvm/ClasspathEntrySnapshot;", "Lorg/jetbrains/kotlin/buildtools/api/jvm/operations/JvmClasspathSnapshottingOperation;", "compilationService", "Lorg/jetbrains/kotlin/buildtools/api/CompilationService;", "classpathEntry", "Ljava/nio/file/Path;", "<init>", "(Lorg/jetbrains/kotlin/buildtools/api/CompilationService;Ljava/nio/file/Path;)V", "getCompilationService", "()Lorg/jetbrains/kotlin/buildtools/api/CompilationService;", "getClasspathEntry", "()Ljava/nio/file/Path;", "options", "Lorg/jetbrains/kotlin/buildtools/internal/compat/Options;", "get", "V", "key", "Lorg/jetbrains/kotlin/buildtools/api/jvm/operations/JvmClasspathSnapshottingOperation$Option;", "(Lorg/jetbrains/kotlin/buildtools/api/jvm/operations/JvmClasspathSnapshottingOperation$Option;)Ljava/lang/Object;", "set", "", "value", "(Lorg/jetbrains/kotlin/buildtools/api/jvm/operations/JvmClasspathSnapshottingOperation$Option;Ljava/lang/Object;)V", "Lorg/jetbrains/kotlin/buildtools/internal/compat/JvmClasspathSnapshottingOperationV1Adapter$Option;", "(Lorg/jetbrains/kotlin/buildtools/internal/compat/JvmClasspathSnapshottingOperationV1Adapter$Option;)Ljava/lang/Object;", "(Lorg/jetbrains/kotlin/buildtools/internal/compat/JvmClasspathSnapshottingOperationV1Adapter$Option;Ljava/lang/Object;)V", "execute", "projectId", "Lorg/jetbrains/kotlin/buildtools/api/ProjectId;", "executionPolicy", "Lorg/jetbrains/kotlin/buildtools/internal/compat/ExecutionPolicyV1Adapter;", "logger", "Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;", "Option", "Companion", "kotlin-build-tools-compat"})
final class JvmClasspathSnapshottingOperationV1Adapter
extends BuildOperationImpl<ClasspathEntrySnapshot>
implements JvmClasspathSnapshottingOperation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CompilationService compilationService;
    @NotNull
    private final Path classpathEntry;
    @NotNull
    private final Options options;
    @JvmField
    @NotNull
    public static final Option<ClassSnapshotGranularity> GRANULARITY = new Option<ClassSnapshotGranularity>("GRANULARITY", ClassSnapshotGranularity.CLASS_MEMBER_LEVEL);
    @JvmField
    @NotNull
    public static final Option<Boolean> PARSE_INLINED_LOCAL_CLASSES = new Option<Boolean>("PARSE_INLINED_LOCAL_CLASSES", true);

    public JvmClasspathSnapshottingOperationV1Adapter(@NotNull CompilationService compilationService, @NotNull Path classpathEntry) {
        Intrinsics.checkNotNullParameter((Object)compilationService, (String)"compilationService");
        Intrinsics.checkNotNullParameter((Object)classpathEntry, (String)"classpathEntry");
        this.compilationService = compilationService;
        this.classpathEntry = classpathEntry;
        this.options = new Options(Reflection.getOrCreateKotlinClass(JvmClasspathSnapshottingOperation.class));
    }

    @NotNull
    public final CompilationService getCompilationService() {
        return this.compilationService;
    }

    @NotNull
    public final Path getClasspathEntry() {
        return this.classpathEntry;
    }

    @Override
    public <V> V get(@NotNull JvmClasspathSnapshottingOperation.Option<V> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.options.get((BaseOption)key);
    }

    @Override
    public <V> void set(@NotNull JvmClasspathSnapshottingOperation.Option<V> key, V value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.options.set((BaseOption)key, value);
    }

    @Override
    public final <V> V get(@NotNull Option<V> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.options.get(key);
    }

    @Override
    public final <V> void set(@NotNull Option<V> key, V value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.options.set(key, value);
    }

    @Override
    @NotNull
    public ClasspathEntrySnapshot execute(@NotNull ProjectId projectId, @NotNull ExecutionPolicyV1Adapter executionPolicy, @Nullable KotlinLogger logger) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)executionPolicy, (String)"executionPolicy");
        File file = this.classpathEntry.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return this.compilationService.calculateClasspathSnapshot(file, this.get(GRANULARITY), this.get(PARSE_INLINED_LOCAL_CLASSES).booleanValue());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/compat/JvmClasspathSnapshottingOperationV1Adapter$Companion;", "", "<init>", "()V", "GRANULARITY", "Lorg/jetbrains/kotlin/buildtools/internal/compat/JvmClasspathSnapshottingOperationV1Adapter$Option;", "Lorg/jetbrains/kotlin/buildtools/api/jvm/ClassSnapshotGranularity;", "PARSE_INLINED_LOCAL_CLASSES", "", "kotlin-build-tools-compat"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/compat/JvmClasspathSnapshottingOperationV1Adapter$Option;", "V", "Lorg/jetbrains/kotlin/buildtools/internal/compat/BaseOptionWithDefault;", "id", "", "<init>", "(Ljava/lang/String;)V", "default", "(Ljava/lang/String;Ljava/lang/Object;)V", "kotlin-build-tools-compat"})
    public static final class Option<V>
    extends BaseOptionWithDefault<V> {
        public Option(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            super(id);
        }

        public Option(@NotNull String id, V v) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            super(id, v);
        }
    }
}

