/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.CompilationTransaction;
import org.jetbrains.kotlin.incremental.CompilationTransactionKt;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.TrackedLookupMap;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.BasicMapsOwner;
import org.jetbrains.kotlin.incremental.storage.FileToIdMap;
import org.jetbrains.kotlin.incremental.storage.IdToFileMap;
import org.jetbrains.kotlin.incremental.storage.LookupMap;
import org.jetbrains.kotlin.incremental.storage.LookupSymbolKey;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 92\u00020\u0001:\u00019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020'0#2\u0006\u0010(\u001a\u00020)J(\u0010*\u001a\u00020+2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020'0-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020'0\u001cJ\u0014\u0010/\u001a\u00020+2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000301J\b\u00102\u001a\u00020+H\u0016J\b\u00103\u001a\u00020+H\u0016J\u0010\u00104\u001a\u00020\u00192\u0006\u00105\u001a\u00020\u0003H\u0002J\b\u00106\u001a\u00020+H\u0002J\u0006\u00107\u001a\u00020+J\u0014\u00108\u001a\u00020'2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020)0\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001fR\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/incremental/LookupStorage;", "Lorg/jetbrains/kotlin/incremental/storage/BasicMapsOwner;", "targetDataDir", "Ljava/io/File;", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "<init>", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "trackChanges", "", "getTrackChanges", "()Z", "countersFile", "idToFile", "Lorg/jetbrains/kotlin/incremental/storage/IdToFileMap;", "fileToId", "Lorg/jetbrains/kotlin/incremental/storage/FileToIdMap;", "lookupMap", "Lorg/jetbrains/kotlin/incremental/TrackedLookupMap;", "size", "", "oldSize", "addedLookupSymbols", "", "Lorg/jetbrains/kotlin/incremental/storage/LookupSymbolKey;", "getAddedLookupSymbols", "()Ljava/util/Set;", "removedLookupSymbols", "getRemovedLookupSymbols", "lookupSymbols", "", "getLookupSymbols", "()Ljava/util/Collection;", "get", "", "lookupSymbol", "Lorg/jetbrains/kotlin/incremental/LookupSymbol;", "addAll", "", "lookups", "Lcom/intellij/util/containers/MultiMap;", "allPaths", "removeLookupsFrom", "files", "Lkotlin/sequences/Sequence;", "deleteStorageFiles", "close", "addFileIfNeeded", "file", "removeGarbageForTests", "forceGC", "dump", "Companion", "kotlin-build-common"})
@SourceDebugExtension(value={"SMAP\nLookupStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LookupStorage.kt\norg/jetbrains/kotlin/incremental/LookupStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,343:1\n1#2:344\n1#2:368\n1628#3,3:345\n774#3:348\n865#3,2:349\n1279#3,2:351\n1293#3,4:353\n1053#3:357\n1611#3,9:358\n1863#3:367\n1864#3:369\n1620#3:370\n1485#3:371\n1510#3,3:372\n1513#3,3:382\n1557#3:385\n1628#3,3:386\n1557#3:389\n1628#3,3:390\n381#4,7:375\n*S KotlinDebug\n*F\n+ 1 LookupStorage.kt\norg/jetbrains/kotlin/incremental/LookupStorage\n*L\n186#1:368\n122#1:345,3\n171#1:348\n171#1:349,2\n174#1:351,2\n174#1:353,4\n180#1:357\n186#1:358,9\n186#1:367\n186#1:369\n186#1:370\n216#1:371\n216#1:372,3\n216#1:382,3\n222#1:385\n222#1:386,3\n227#1:389\n227#1:390,3\n216#1:375,7\n*E\n"})
public class LookupStorage
extends BasicMapsOwner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IncrementalCompilationContext icContext;
    @NotNull
    private final Logger LOG;
    @NotNull
    private final File countersFile;
    @NotNull
    private final IdToFileMap idToFile;
    @NotNull
    private final FileToIdMap fileToId;
    @NotNull
    private final TrackedLookupMap lookupMap;
    private volatile int size;
    private int oldSize;
    private static final double DELETED_TO_SIZE_THRESHOLD = 0.5;
    private static final int MINIMUM_GARBAGE_COLLECTIBLE_SIZE = 10000;

    public LookupStorage(@NotNull File targetDataDir, @NotNull IncrementalCompilationContext icContext) {
        Intrinsics.checkNotNullParameter((Object)targetDataDir, (String)"targetDataDir");
        Intrinsics.checkNotNullParameter((Object)icContext, (String)"icContext");
        super(targetDataDir);
        this.icContext = icContext;
        Logger logger = Logger.getInstance((String)"#org.jetbrains.kotlin.jps.build.KotlinBuilder");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
        this.countersFile = this.getStorageFile("counters");
        this.idToFile = (IdToFileMap)this.registerMap((BasicMap)new IdToFileMap(this.getStorageFile("id-to-file"), this.icContext));
        this.fileToId = (FileToIdMap)this.registerMap((BasicMap)new FileToIdMap(this.getStorageFile("file-to-id"), this.icContext));
        this.lookupMap = new TrackedLookupMap((LookupMap)this.registerMap((BasicMap)new LookupMap(this.getStorageFile("lookups"), this.icContext)), this.getTrackChanges());
        try {
            if (this.countersFile.exists()) {
                List lines = FilesKt.readLines$default((File)this.countersFile, null, (int)1, null);
                Object object = (String)kotlin.collections.CollectionsKt.firstOrNull((List)lines);
                if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
                    throw new IOException(this.countersFile + " exists, but it is empty. Counters file is corrupted");
                }
                this.oldSize = this.size = ((Integer)object).intValue();
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Could not read " + this.countersFile, e);
        }
    }

    @NotNull
    public final Logger getLOG() {
        return this.LOG;
    }

    private final boolean getTrackChanges() {
        return this.icContext.getTrackChangesInLookupCache();
    }

    @NotNull
    public final Set<LookupSymbolKey> getAddedLookupSymbols() {
        LookupStorage $this$_get_addedLookupSymbols__u24lambda_u241 = this;
        boolean bl = false;
        if (!$this$_get_addedLookupSymbols__u24lambda_u241.getTrackChanges()) {
            boolean bl2 = false;
            String string = "trackChanges is not enabled";
            throw new IllegalStateException(string.toString());
        }
        Set<LookupSymbolKey> set = $this$_get_addedLookupSymbols__u24lambda_u241.lookupMap.getAddedKeys();
        Intrinsics.checkNotNull(set);
        return set;
    }

    @NotNull
    public final Set<LookupSymbolKey> getRemovedLookupSymbols() {
        LookupStorage $this$_get_removedLookupSymbols__u24lambda_u243 = this;
        boolean bl = false;
        if (!$this$_get_removedLookupSymbols__u24lambda_u243.getTrackChanges()) {
            boolean bl2 = false;
            String string = "trackChanges is not enabled";
            throw new IllegalStateException(string.toString());
        }
        Set<LookupSymbolKey> set = $this$_get_removedLookupSymbols__u24lambda_u243.lookupMap.getRemovedKeys();
        Intrinsics.checkNotNull(set);
        return set;
    }

    @NotNull
    public final Collection<LookupSymbolKey> getLookupSymbols() {
        return this.lookupMap.getKeys();
    }

    @NotNull
    public final synchronized Collection<String> get(@NotNull LookupSymbol lookupSymbol) {
        Intrinsics.checkNotNullParameter((Object)lookupSymbol, (String)"lookupSymbol");
        LookupSymbolKey key = new LookupSymbolKey(lookupSymbol.getName(), lookupSymbol.getScope());
        Set<Integer> set = this.lookupMap.get(key);
        if (set == null) {
            return SetsKt.emptySet();
        }
        Set<Integer> fileIds = set;
        Set paths = new LinkedHashSet();
        Set filtered = new LinkedHashSet();
        Iterator<Integer> iterator = fileIds.iterator();
        while (iterator.hasNext()) {
            int fileId = ((Number)iterator.next()).intValue();
            File file = (File)this.idToFile.get(fileId);
            String path = file != null ? file.getPath() : null;
            if (path == null) continue;
            paths.add(path);
            filtered.add(fileId);
        }
        if (this.size > 10000 && (double)filtered.size() / (double)fileIds.size() < 0.5) {
            this.lookupMap.set(key, filtered);
        }
        return paths;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void addAll(@NotNull MultiMap<LookupSymbol, String> lookups, @NotNull Set<String> allPaths) {
        Intrinsics.checkNotNullParameter(lookups, (String)"lookups");
        Intrinsics.checkNotNullParameter(allPaths, (String)"allPaths");
        Map pathToId = CollectionsKt.keysToMap((Iterable)kotlin.collections.CollectionsKt.sorted((Iterable)allPaths), arg_0 -> LookupStorage.addAll$lambda$4(this, arg_0));
        Set set = lookups.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keySet(...)");
        for (LookupSymbol lookupSymbol : kotlin.collections.CollectionsKt.sorted((Iterable)set)) {
            void $this$mapTo$iv;
            Collection paths;
            LookupSymbolKey key = new LookupSymbolKey(lookupSymbol.getName(), lookupSymbol.getScope());
            Intrinsics.checkNotNullExpressionValue((Object)lookups.get((Object)lookupSymbol), (String)"get(...)");
            Iterable iterable = paths;
            Collection destination$iv = new TreeSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                String string = (String)item$iv;
                Collection collection = destination$iv;
                boolean bl = false;
                Object v = pathToId.get(it);
                Intrinsics.checkNotNull(v);
                collection.add(((Number)v).intValue());
            }
            TreeSet fileIds = (TreeSet)destination$iv;
            this.lookupMap.append(key, fileIds);
        }
    }

    public final synchronized void removeLookupsFrom(@NotNull Sequence<? extends File> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        for (File file : files) {
            Integer n = (Integer)this.fileToId.get(file);
            if (n == null) {
                continue;
            }
            int id = n;
            this.idToFile.remove(id);
            this.fileToId.remove(file);
        }
    }

    @Override
    public synchronized void deleteStorageFiles() {
        CompilationTransaction compilationTransaction = this.icContext.getTransaction();
        Path path = this.countersFile.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        compilationTransaction.deleteFile(path);
        this.size = 0;
        super.deleteStorageFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        try {
            if (this.size != this.oldSize && this.size > 0) {
                CompilationTransaction compilationTransaction = this.icContext.getTransaction();
                Path path = this.countersFile.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                CompilationTransactionKt.writeText(compilationTransaction, path, this.size + "\n0");
            }
        }
        finally {
            super.close();
        }
    }

    private final int addFileIfNeeded(File file) {
        Integer existing = (Integer)this.fileToId.get(file);
        if (existing != null) {
            return existing;
        }
        int n = this.size;
        this.size = n + 1;
        int id = n;
        this.fileToId.set(file, id);
        this.idToFile.set(id, file);
        return id;
    }

    /*
     * WARNING - void declaration
     */
    private final void removeGarbageForTests() {
        Integer it;
        Object object;
        Object object2;
        LookupSymbolKey lookupSymbolKey;
        for (LookupSymbolKey hash : this.lookupMap.getKeys()) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Set<Integer> set = this.lookupMap.get(hash);
            Intrinsics.checkNotNull(set);
            Iterable iterable = set;
            lookupSymbolKey = hash;
            object2 = this.lookupMap;
            boolean $i$f$filter = false;
            void var5_8 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (File element$iv$iv2 : $this$filterTo$iv$iv) {
                int it2 = ((Number)((Object)element$iv$iv2)).intValue();
                boolean bl = false;
                if (!this.idToFile.contains(it2)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            object = (List)destination$iv$iv;
            ((TrackedLookupMap)object2).set(lookupSymbolKey, kotlin.collections.CollectionsKt.toSet((Iterable)((Iterable)object)));
        }
        Iterable $this$associateWith$iv = this.fileToId.getKeys();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            File element$iv$iv2;
            element$iv$iv2 = (File)element$iv$iv;
            lookupSymbolKey = element$iv$iv;
            object2 = result$iv;
            boolean bl = false;
            Object VALUE = this.fileToId.get(it);
            Intrinsics.checkNotNull(VALUE);
            object = ((Number)VALUE).intValue();
            object2.put(lookupSymbolKey, object);
        }
        Map oldFileToId = result$iv;
        HashMap oldIdToNewId = new HashMap(oldFileToId.size());
        this.idToFile.clear();
        this.fileToId.clear();
        this.size = 0;
        Object $this$sortedBy$iv2 = oldFileToId.entrySet();
        boolean $i$f$sortedBy = false;
        for (Object $this$sortedBy$iv2 : kotlin.collections.CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((File)it.getKey()).getPath());
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((File)it.getKey()).getPath())));
            }
        })) {
            File file = (File)$this$sortedBy$iv2.getKey();
            int oldId = ((Number)$this$sortedBy$iv2.getValue()).intValue();
            int newId = this.addFileIfNeeded(file);
            it = oldId;
            Integer bl = newId;
            ((Map)oldIdToNewId).put(it, bl);
        }
        for (LookupSymbolKey lookup : this.lookupMap.getKeys()) {
            void $this$mapNotNullTo$iv$iv;
            Object element$iv$iv;
            Set<Integer> set = this.lookupMap.get(lookup);
            Intrinsics.checkNotNull(set);
            Iterable $this$mapNotNull$iv = set;
            boolean $i$f$mapNotNull = false;
            element$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Integer it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv3 = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                int it3 = ((Number)element$iv$iv3).intValue();
                boolean bl2 = false;
                if ((Integer)oldIdToNewId.get(it3) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Set fileIds = kotlin.collections.CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            if (fileIds.isEmpty()) {
                this.lookupMap.remove(lookup);
                continue;
            }
            this.lookupMap.set(lookup, fileIds);
        }
    }

    public final void forceGC() {
        this.removeGarbageForTests();
        this.flush();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String dump(@NotNull Set<LookupSymbol> lookupSymbols) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(lookupSymbols, (String)"lookupSymbols");
        this.flush();
        StringBuilder sb = new StringBuilder();
        Printer p = new Printer((Appendable)sb, 0, null, 6, null);
        Object[] objectArray = new Object[]{"====== File to id map"};
        p.println(objectArray);
        objectArray = new Object[]{this.fileToId.dump()};
        p.println(objectArray);
        objectArray = new Object[]{"====== Id to file map"};
        p.println(objectArray);
        objectArray = new Object[]{this.idToFile.dump()};
        p.println(objectArray);
        Iterable $this$groupBy$iv = lookupSymbols;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            LookupSymbol it = (LookupSymbol)element$iv$iv;
            boolean bl = false;
            LookupSymbolKey key$iv$iv = new LookupSymbolKey(it.getName(), it.getScope());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map lookupsStrings = destination$iv$iv;
        for (LookupSymbolKey lookup : kotlin.collections.CollectionsKt.sorted((Iterable)this.lookupMap.getKeys())) {
            void $this$mapTo$iv$iv;
            Set<Integer> fileIds;
            String string;
            Iterable iterable2;
            Iterable destination$iv$iv2;
            Intrinsics.checkNotNull(this.lookupMap.get(lookup));
            if (lookupsStrings.containsKey(lookup)) {
                void $this$mapTo$iv$iv2;
                Object v = lookupsStrings.get(lookup);
                Intrinsics.checkNotNull(v);
                Iterable $this$map$iv = (Iterable)v;
                boolean $i$f$map = false;
                Iterable element$iv$iv = $this$map$iv;
                destination$iv$iv2 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    LookupSymbol $i$f$getOrPut = (LookupSymbol)item$iv$iv;
                    iterable2 = destination$iv$iv2;
                    boolean bl = false;
                    iterable2.add(it.getScope() + '#' + it.getName());
                }
                string = kotlin.collections.CollectionsKt.joinToString$default((Iterable)kotlin.collections.CollectionsKt.sorted((Iterable)((List)destination$iv$iv2)), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            } else {
                string = lookup.toString();
            }
            String key = string;
            Iterable $this$map$iv = fileIds;
            boolean $i$f$map = false;
            destination$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                int bl = ((Number)item$iv$iv).intValue();
                iterable2 = destination$iv$iv3;
                boolean bl3 = false;
                iterable2.add(String.valueOf((int)it));
            }
            String value = kotlin.collections.CollectionsKt.joinToString$default((Iterable)kotlin.collections.CollectionsKt.sorted((Iterable)((List)destination$iv$iv3)), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            Object[] objectArray2 = new Object[]{key + " -> " + value};
            p.println(objectArray2);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final int addAll$lambda$4(LookupStorage this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.addFileIfNeeded(new File(it));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/incremental/LookupStorage$Companion;", "", "<init>", "()V", "DELETED_TO_SIZE_THRESHOLD", "", "MINIMUM_GARBAGE_COLLECTIBLE_SIZE", "", "kotlin-build-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

