/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CompilerSystemProperties;
import org.jetbrains.kotlin.cli.common.PropertiesKt;
import org.jetbrains.kotlin.incremental.storage.LookupSymbolKey;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/LookupSymbolKeyDescriptor;", "Lcom/intellij/util/io/KeyDescriptor;", "Lorg/jetbrains/kotlin/incremental/storage/LookupSymbolKey;", "()V", "storeFullFqName", "", "getHashCode", "", "value", "isEqual", "val1", "val2", "read", "input", "Ljava/io/DataInput;", "save", "", "output", "Ljava/io/DataOutput;", "kotlin-build-common"})
public final class LookupSymbolKeyDescriptor
implements KeyDescriptor<LookupSymbolKey> {
    @NotNull
    public static final LookupSymbolKeyDescriptor INSTANCE = new LookupSymbolKeyDescriptor();
    private static final boolean storeFullFqName;

    private LookupSymbolKeyDescriptor() {
    }

    @NotNull
    public LookupSymbolKey read(@NotNull DataInput input) {
        LookupSymbolKey lookupSymbolKey;
        byte version;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        byte by = version = input.readByte();
        switch (by) {
            case 0: {
                String name = input.readUTF();
                String scope = input.readUTF();
                int n = name.hashCode();
                int n2 = scope.hashCode();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                Intrinsics.checkNotNullExpressionValue((Object)scope, (String)"scope");
                lookupSymbolKey = new LookupSymbolKey(n, n2, name, scope);
                break;
            }
            case 1: {
                int first = input.readInt();
                int second = input.readInt();
                lookupSymbolKey = new LookupSymbolKey(first, second, "", "");
                break;
            }
            default: {
                throw new RuntimeException(Intrinsics.stringPlus((String)"Unknown version of LookupSymbolKeyDescriptor=", (Object)version));
            }
        }
        return lookupSymbolKey;
    }

    public void save(@NotNull DataOutput output, @NotNull LookupSymbolKey value) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (storeFullFqName) {
            output.writeByte(0);
            output.writeUTF(value.getName());
            output.writeUTF(value.getScope());
        } else {
            output.writeByte(1);
            output.writeInt(value.getNameHash());
            output.writeInt(value.getScopeHash());
        }
    }

    public int getHashCode(@NotNull LookupSymbolKey value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return value.hashCode();
    }

    public boolean isEqual(@NotNull LookupSymbolKey val1, @NotNull LookupSymbolKey val2) {
        Intrinsics.checkNotNullParameter((Object)val1, (String)"val1");
        Intrinsics.checkNotNullParameter((Object)val2, (String)"val2");
        return Intrinsics.areEqual((Object)val1, (Object)val2);
    }

    static {
        Boolean bl = PropertiesKt.toBooleanLenient((String)CompilerSystemProperties.COMPILE_INCREMENTAL_WITH_CLASSPATH_SNAPSHOTS.getValue());
        storeFullFqName = bl == null ? false : bl;
    }
}

