/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.stream.Collector;
import org.jdbi.v3.core.collector.JdbiCollectors;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.SimpleExtensionConfigurer;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.internal.JdbiClassUtils;
import org.jdbi.v3.sqlobject.config.RegisterCollector;

public class RegisterCollectorImpl
extends SimpleExtensionConfigurer {
    private final Type resultType;
    private final Collector<?, ?, ?> collector;

    public RegisterCollectorImpl(Annotation annotation) {
        RegisterCollector registerCollector = (RegisterCollector)annotation;
        Class<? extends Collector<?, ?, ?>> klass = registerCollector.value();
        this.resultType = (Type)GenericTypes.findGenericParameter(klass, Collector.class, (int)2).orElseThrow(() -> new IllegalArgumentException("Tried to pass non-collector object to @RegisterCollector"));
        this.collector = (Collector)JdbiClassUtils.checkedCreateInstance(klass);
    }

    public void configure(ConfigRegistry config, Annotation annotation, Class<?> extensionType) {
        JdbiCollectors collectors = (JdbiCollectors)config.get(JdbiCollectors.class);
        collectors.registerCollector(this.resultType, this.collector);
    }
}

