/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.statement.internal;

import java.lang.reflect.Method;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.result.ResultIterable;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;
import org.jdbi.v3.sqlobject.statement.UseRowReducer;
import org.jdbi.v3.sqlobject.statement.internal.CustomizingStatementHandler;
import org.jdbi.v3.sqlobject.statement.internal.ResultReturner;
import org.jdbi.v3.sqlobject.statement.internal.SqlObjectStatementConfiguration;

public class SqlQueryHandler
extends CustomizingStatementHandler<Query> {
    private final ResultReturner resultReturner;
    private final UseRowMapper useRowMapper;
    private final UseRowReducer useRowReducer;

    public SqlQueryHandler(Class<?> sqlObjectType, Method method) {
        super(sqlObjectType, method);
        this.resultReturner = ResultReturner.forMethod(sqlObjectType, method);
        this.useRowMapper = method.getAnnotation(UseRowMapper.class);
        this.useRowReducer = method.getAnnotation(UseRowReducer.class);
        if (this.useRowReducer != null && this.useRowMapper != null) {
            throw new IllegalStateException("Cannot declare @UseRowMapper and @UseRowReducer on the same method.");
        }
    }

    @Override
    public void warm(ConfigRegistry config) {
        super.warm(config);
        this.resultReturner.warm(config);
    }

    @Override
    void configureReturner(Query query, SqlObjectStatementConfiguration cfg) {
        cfg.setReturner(() -> {
            StatementContext ctx = query.getContext();
            QualifiedType<?> elementType = this.resultReturner.elementType(ctx.getConfig());
            if (this.useRowReducer != null) {
                return this.resultReturner.reducedResult(query.reduceRows(SqlQueryHandler.rowReducerFor(this.useRowReducer)), ctx);
            }
            ResultIterable iterable = this.useRowMapper == null ? query.mapTo(elementType) : query.map(SqlQueryHandler.rowMapperFor(this.useRowMapper));
            return this.resultReturner.mappedResult(iterable, ctx);
        });
    }

    @Override
    Query createStatement(Handle handle, String locatedSql) {
        return handle.createQuery(locatedSql);
    }
}

