/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jdbi.v3.core.internal.exceptions.Unchecked;
import org.jdbi.v3.sqlobject.DefaultMethodHandler;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.HandlerFactory;
import org.jdbi.v3.sqlobject.UnableToCreateSqlObjectException;

class BridgeMethodHandlerFactory
implements HandlerFactory {
    BridgeMethodHandlerFactory() {
    }

    @Override
    public Optional<Handler> buildHandler(Class<?> sqlObjectType, Method method) {
        if (!method.isBridge()) {
            return Optional.empty();
        }
        return Stream.of(sqlObjectType.getMethods()).filter(candidate -> !candidate.isBridge() && Objects.equals(candidate.getName(), method.getName()) && candidate.getParameterCount() == method.getParameterCount()).filter(candidate -> {
            Class[] candidateParamTypes = candidate.getParameterTypes();
            Class[] methodParamTypes = method.getParameterTypes();
            return IntStream.range(0, method.getParameterCount()).allMatch(i -> methodParamTypes[i].isAssignableFrom(candidateParamTypes[i]));
        }).map(m -> {
            MethodHandle mh = BridgeMethodHandlerFactory.unreflect(sqlObjectType, m);
            return (target, args, handleSupplier) -> Unchecked.function(mh.bindTo(target)::invokeWithArguments).apply(args);
        }).findFirst();
    }

    private static MethodHandle unreflect(Class<?> sqlObjectType, Method m) {
        try {
            return DefaultMethodHandler.lookupFor(sqlObjectType).unreflect(m);
        }
        catch (IllegalAccessException e) {
            throw new UnableToCreateSqlObjectException("Bridge handler couldn't unreflect " + sqlObjectType + " " + m, e);
        }
    }
}

