/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core.factory;

import org.jbpm.process.instance.impl.Action;
import org.jbpm.ruleflow.core.factory.DialectConverter;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.ActionNode;
import org.kie.api.fluent.ActionNodeBuilder;
import org.kie.api.fluent.Dialect;
import org.kie.api.fluent.NodeContainerBuilder;

public class ActionNodeFactory<T extends NodeContainerBuilder<T, ?>>
extends NodeFactory<ActionNodeBuilder<T>, T>
implements ActionNodeBuilder<T> {
    public ActionNodeFactory(T nodeContainerFactory, NodeContainer nodeContainer, long id) {
        super(nodeContainerFactory, nodeContainer, new ActionNode(), id);
    }

    protected ActionNode getActionNode() {
        return (ActionNode)this.getNode();
    }

    @Override
    public ActionNodeFactory<T> name(String name) {
        this.getNode().setName(name);
        return this;
    }

    public ActionNodeFactory<T> action(String dialect, String action) {
        return this.action(dialect, action, false);
    }

    public ActionNodeFactory<T> action(String dialect, String action, boolean isDroolsAction) {
        if (isDroolsAction) {
            DroolsAction droolsAction = new DroolsAction();
            droolsAction.setMetaData("Action", action);
            this.getActionNode().setAction(droolsAction);
        } else {
            this.getActionNode().setAction(new DroolsConsequenceAction(dialect, action));
        }
        return this;
    }

    public ActionNodeFactory<T> action(Action action) {
        DroolsAction droolsAction = new DroolsAction();
        droolsAction.setMetaData("Action", action);
        this.getActionNode().setAction(droolsAction);
        return this;
    }

    public ActionNodeFactory<T> action(Dialect dialect, String code) {
        this.getActionNode().setAction(new DroolsConsequenceAction(DialectConverter.fromDialect(dialect), code));
        return this;
    }
}

