/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.io.Serializable;
import java.util.UUID;
import org.jbpm.process.core.async.AsyncSignalEventCommand;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.AsyncEventNode;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.CompositeNodeInstance;
import org.jbpm.workflow.instance.node.EventNodeInstance;
import org.kie.api.definition.process.Node;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutorService;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncEventNodeInstance
extends EventNodeInstance {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AsyncEventNodeInstance.class);
    private String eventType = UUID.randomUUID().toString();
    private EventListener listener = new AsyncExternalEventListener();

    @Override
    public void internalTrigger(org.kie.api.runtime.process.NodeInstance from, String type) {
        super.internalTrigger(from, type);
        ExecutorService executorService = (ExecutorService)this.getProcessInstance().getKnowledgeRuntime().getEnvironment().get("ExecutorService");
        if (executorService != null) {
            RuntimeManager runtimeManager = (RuntimeManager)this.getProcessInstance().getKnowledgeRuntime().getEnvironment().get("RuntimeManager");
            CommandContext ctx = new CommandContext();
            ctx.setData("deploymentId", (Object)runtimeManager.getIdentifier());
            ctx.setData("processInstanceId", (Object)this.getProcessInstance().getId());
            ctx.setData("Signal", (Object)this.getEventType());
            ctx.setData("Event", null);
            executorService.scheduleRequest(AsyncSignalEventCommand.class.getName(), ctx);
            Node node = this.getNode();
            if (node != null) {
                String uniqueId = (String)node.getMetaData().get("UniqueId");
                if (uniqueId == null) {
                    uniqueId = ((NodeImpl)node).getUniqueId();
                }
                ((WorkflowProcessInstanceImpl)this.getProcessInstance()).getIterationLevels().remove(this.getNode().getMetaData().get("UniqueId"));
            }
        } else {
            logger.warn("No async executor service found continuing as sync operation...");
            this.triggerCompleted();
        }
    }

    @Override
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @Override
    public Node getNode() {
        return new AsyncEventNode(super.getNode());
    }

    @Override
    protected org.kie.api.runtime.process.NodeInstance getFrom() {
        AsyncEventNode node = (AsyncEventNode)this.getNode();
        int level = this.getLevel();
        NodeInstance instance = ((NodeInstanceContainer)this.getNodeInstanceContainer()).getNodeInstance(node.getPreviousNode());
        ((NodeInstanceContainer)this.getNodeInstanceContainer()).removeNodeInstance(instance);
        ((NodeInstanceImpl)instance).setLevel(level);
        return instance;
    }

    @Override
    public void triggerCompleted() {
        this.getProcessInstance().removeEventListener(this.getEventType(), this.getEventListener(), true);
        ((NodeInstanceContainer)this.getNodeInstanceContainer()).setCurrentLevel(this.getLevel());
        ((NodeInstanceContainer)this.getNodeInstanceContainer()).removeNodeInstance(this);
        NodeInstance instance = ((NodeInstanceContainer)this.getNodeInstanceContainer()).getNodeInstance(this.getNode());
        if (this.getNodeInstanceContainer() instanceof CompositeNodeInstance) {
            CompositeNodeInstance composite = (CompositeNodeInstance)this.getNodeInstanceContainer();
            composite.getIterationLevels().put(this.getNode().getNodeUniqueId(), this.getLevel());
        } else if (this.getNodeInstanceContainer() instanceof WorkflowProcessInstanceImpl) {
            WorkflowProcessInstanceImpl composite = (WorkflowProcessInstanceImpl)this.getNodeInstanceContainer();
            composite.getIterationLevels().put(this.getNode().getNodeUniqueId(), this.getLevel());
        }
        ((NodeInstanceImpl)instance).setLevel(this.getLevel());
        this.triggerNodeInstance(instance, "DROOLS_DEFAULT");
    }

    @Override
    protected EventListener getEventListener() {
        return this.listener;
    }

    private class AsyncExternalEventListener
    implements EventListener,
    Serializable {
        private static final long serialVersionUID = 5L;

        private AsyncExternalEventListener() {
        }

        public String[] getEventTypes() {
            return null;
        }

        public void signalEvent(String type, Object event) {
            AsyncEventNodeInstance.this.triggerCompleted();
        }
    }
}

