/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.HashMap;
import java.util.Map;
import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.bpmn2.core.ItemDefinition;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.bpmn2.xml.elements.DataAssociationFactory;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.process.core.Work;
import org.jbpm.process.core.impl.WorkImpl;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.ExtendedNodeImpl;
import org.jbpm.workflow.core.node.ForEachNode;
import org.jbpm.workflow.core.node.MilestoneNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TaskHandler
extends AbstractNodeHandler {
    private Map<String, ItemDefinition> itemDefinitions;
    Map<String, String> dataTypeInputs = new HashMap<String, String>();
    Map<String, String> dataTypeOutputs = new HashMap<String, String>();

    @Override
    protected Node createNode(Attributes attrs) {
        return new WorkItemNode();
    }

    public Class<?> generateNodeFor() {
        return Node.class;
    }

    @Override
    protected void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        boolean isForCompensation;
        super.handleNode(node, element, uri, localName, parser);
        this.itemDefinitions = (Map)((ProcessBuildData)parser.getData()).getMetaData("ItemDefinitions");
        this.dataTypeInputs.clear();
        this.dataTypeOutputs.clear();
        WorkItemNode workItemNode = (WorkItemNode)node;
        String name = this.getTaskName(element);
        WorkImpl work = new WorkImpl();
        work.setName(name);
        workItemNode.setWork((Work)work);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("ioSpecification".equals(nodeName)) {
                this.readIoSpecification(xmlNode, this.dataInputs, this.dataOutputs);
                continue;
            }
            if ("dataInputAssociation".equals(nodeName)) {
                this.readDataInputAssociation(xmlNode, workItemNode, this.dataInputs);
                continue;
            }
            if (!"dataOutputAssociation".equals(nodeName)) continue;
            this.readDataOutputAssociation(xmlNode, workItemNode, this.dataOutputs);
        }
        workItemNode.setMetaData("DataInputs", new HashMap<String, String>(this.dataTypeInputs));
        workItemNode.setMetaData("DataOutputs", new HashMap<String, String>(this.dataTypeOutputs));
        this.handleScript((ExtendedNodeImpl)workItemNode, element, "onEntry");
        this.handleScript((ExtendedNodeImpl)workItemNode, element, "onExit");
        String compensation = element.getAttribute("isForCompensation");
        if (compensation != null && (isForCompensation = Boolean.parseBoolean(compensation))) {
            workItemNode.setMetaData("isForCompensation", (Object)isForCompensation);
        }
    }

    protected String getTaskName(Element element) {
        return element.getAttribute("taskName");
    }

    @Override
    protected void readIoSpecification(org.w3c.dom.Node xmlNode, Map<String, String> dataInputs, Map<String, String> dataOutputs) {
        this.dataTypeInputs.clear();
        this.dataTypeOutputs.clear();
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        while (subNode instanceof Element) {
            String dataType;
            String itemSubjectRef;
            String id;
            String subNodeName = subNode.getNodeName();
            if ("dataInput".equals(subNodeName)) {
                id = ((Element)subNode).getAttribute("id");
                String inputName = ((Element)subNode).getAttribute("name");
                dataInputs.put(id, inputName);
                itemSubjectRef = ((Element)subNode).getAttribute("itemSubjectRef");
                if (itemSubjectRef == null || itemSubjectRef.isEmpty()) {
                    dataType = ((Element)subNode).getAttribute("dtype");
                    if (dataType == null || dataType.isEmpty()) {
                        dataType = "java.lang.String";
                    }
                    this.dataTypeInputs.put(inputName, dataType);
                } else if (this.itemDefinitions.get(itemSubjectRef) != null) {
                    this.dataTypeInputs.put(inputName, this.itemDefinitions.get(itemSubjectRef).getStructureRef());
                } else {
                    this.dataTypeInputs.put(inputName, "java.lang.Object");
                }
            }
            if ("dataOutput".equals(subNodeName)) {
                id = ((Element)subNode).getAttribute("id");
                String outputName = ((Element)subNode).getAttribute("name");
                dataOutputs.put(id, outputName);
                itemSubjectRef = ((Element)subNode).getAttribute("itemSubjectRef");
                if (itemSubjectRef == null || itemSubjectRef.isEmpty()) {
                    dataType = ((Element)subNode).getAttribute("dtype");
                    if (dataType == null || dataType.isEmpty()) {
                        dataType = "java.lang.String";
                    }
                    this.dataTypeOutputs.put(outputName, dataType);
                } else if (this.itemDefinitions.get(itemSubjectRef) != null) {
                    this.dataTypeOutputs.put(outputName, this.itemDefinitions.get(itemSubjectRef).getStructureRef());
                } else {
                    this.dataTypeOutputs.put(outputName, "java.lang.Object");
                }
            }
            subNode = subNode.getNextSibling();
        }
    }

    protected void readDataInputAssociation(org.w3c.dom.Node xmlNode, WorkItemNode workItemNode, Map<String, String> dataInputs) {
        DataAssociationFactory.readDataInputAssociation(xmlNode, dataInputs, DataAssociationFactory::isLegacyAssignment, arg_0 -> ((WorkItemNode)workItemNode).addInAssociation(arg_0), (name, value) -> workItemNode.getWork().setParameter(name, value));
    }

    protected void readDataOutputAssociation(org.w3c.dom.Node xmlNode, WorkItemNode workItemNode, Map<String, String> dataOutputs) {
        workItemNode.addOutAssociation(DataAssociationFactory.readDataOutputAssociation(xmlNode, dataOutputs));
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        throw new IllegalArgumentException("Writing out should be handled by the WorkItemNodeHandler");
    }

    @Override
    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        Node node = (Node)parser.getCurrent();
        this.handleNode(node, element, uri, localName, parser);
        int uniqueIdGen = 1;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"multiInstanceLoopCharacteristics".equals(nodeName)) continue;
            ForEachNode forEachNode = new ForEachNode();
            forEachNode.setId(node.getId());
            String uniqueId = (String)node.getMetaData().get("UniqueId");
            forEachNode.setMetaData("UniqueId", (Object)uniqueId);
            node.setMetaData("UniqueId", (Object)(uniqueId + ":" + uniqueIdGen++));
            forEachNode.addNode((org.kie.api.definition.process.Node)node);
            forEachNode.linkIncomingConnections("DROOLS_DEFAULT", node.getId(), "DROOLS_DEFAULT");
            forEachNode.linkOutgoingConnections(node.getId(), "DROOLS_DEFAULT", "DROOLS_DEFAULT");
            forEachNode.setSequential(Boolean.parseBoolean(((Element)xmlNode).getAttribute("isSequential")));
            Node orignalNode = node;
            node = forEachNode;
            this.handleForEachNode(node, element, uri, localName, parser);
            if (!(orignalNode instanceof WorkItemNode) || forEachNode.getOutputCollectionExpression() == null) break;
            ((WorkItemNode)orignalNode).adjustOutMapping(forEachNode.getOutputCollectionExpression());
            break;
        }
        if (node instanceof WorkItemNode && ((WorkItemNode)node).getWork().getName().equals("Milestone")) {
            WorkItemNode workItemNode = (WorkItemNode)node;
            String milestoneCondition = (String)((WorkItemNode)node).getWork().getParameter("Condition");
            if (milestoneCondition == null) {
                milestoneCondition = "";
            }
            MilestoneNode milestoneNode = new MilestoneNode();
            milestoneNode.setId(workItemNode.getId());
            milestoneNode.setConstraint(milestoneCondition);
            milestoneNode.setMatchVariable((String)((WorkItemNode)node).getWork().getParameter("MatchVariable"));
            milestoneNode.setMetaData(workItemNode.getMetaData());
            milestoneNode.setName(workItemNode.getName());
            milestoneNode.setNodeContainer(workItemNode.getNodeContainer());
            node = milestoneNode;
        }
        NodeContainer nodeContainer = (NodeContainer)parser.getParent();
        nodeContainer.addNode((org.kie.api.definition.process.Node)node);
        ((ProcessBuildData)parser.getData()).addNode(node);
        return node;
    }

    protected void handleForEachNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        ForEachNode forEachNode = (ForEachNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("dataInputAssociation".equals(nodeName)) {
                this.readDataInputAssociation(xmlNode, this.inputAssociation);
                continue;
            }
            if ("dataOutputAssociation".equals(nodeName)) {
                this.readDataOutputAssociation(xmlNode, this.outputAssociation);
                continue;
            }
            if (!"multiInstanceLoopCharacteristics".equals(nodeName)) continue;
            this.readMultiInstanceLoopCharacteristics(xmlNode, forEachNode, parser);
        }
    }
}

