/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.utils;

import jakarta.jws.WebService;
import java.util.StringTokenizer;
import org.jboss.ws.api.annotation.WebContext;
import org.jboss.wsf.spi.metadata.webservices.JBossPortComponentMetaData;

public class UrlPatternUtils {
    public static String getUrlPatternByClassname(Class<?> beanClass) {
        return beanClass.getSimpleName();
    }

    public static String getUrlPatternByWebServiceProvider(Class<?> beanClass) {
        return null;
    }

    public static String getUrlPatternByWebService(Class<?> beanClass) {
        String urlPattern = null;
        WebService webServiceAnnotation = beanClass.getAnnotation(WebService.class);
        if (webServiceAnnotation != null) {
            String name = webServiceAnnotation.name();
            urlPattern = !UrlPatternUtils.isEmpty(name) ? name : beanClass.getSimpleName();
            String serviceName = webServiceAnnotation.serviceName();
            if (!UrlPatternUtils.isEmpty(serviceName)) {
                urlPattern = serviceName + "/" + urlPattern;
            }
        }
        return urlPattern;
    }

    public static String getUrlPatternByWebContext(Class<?> beanClass) {
        WebContext anWebContext = beanClass.getAnnotation(WebContext.class);
        if (anWebContext != null && anWebContext.urlPattern().length() > 0) {
            return anWebContext.urlPattern();
        }
        return null;
    }

    public static String getUrlPatternByPortComponentURI(String urlPattern, String contextRoot) {
        if (urlPattern != null) {
            StringTokenizer st;
            urlPattern = UrlPatternUtils.getUrlPattern(urlPattern);
            if (contextRoot != null && (st = new StringTokenizer(urlPattern, "/")).countTokens() > 1 && urlPattern.startsWith(contextRoot + "/")) {
                urlPattern = urlPattern.substring(contextRoot.length());
            }
        }
        return urlPattern;
    }

    public static String getUrlPatternByPortComponentURI(JBossPortComponentMetaData portComponent) {
        String portComponentURI;
        String urlPattern = null;
        if (portComponent != null && (portComponentURI = portComponent.getPortComponentURI()) != null && portComponentURI.length() > 0) {
            urlPattern = portComponentURI;
        }
        return urlPattern;
    }

    public static String getUrlPattern(String classBasename, String serviceName, String name) {
        String urlPattern;
        String string = urlPattern = !UrlPatternUtils.isEmpty(name) ? name : classBasename;
        if (!UrlPatternUtils.isEmpty(serviceName)) {
            urlPattern = serviceName + "/" + urlPattern;
        }
        return urlPattern;
    }

    public static String getUrlPattern(String classBasename, String serviceName) {
        return "/" + (!serviceName.equals("") ? serviceName : classBasename);
    }

    public static String getUrlPattern(String urlPattern) {
        if (!urlPattern.startsWith("/")) {
            urlPattern = "/" + urlPattern;
        }
        return urlPattern;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }
}

