/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.inject.build.compatible.spi.MethodConfig;
import jakarta.enterprise.inject.build.compatible.spi.ParameterConfig;
import jakarta.enterprise.inject.spi.AnnotatedCallable;
import jakarta.enterprise.inject.spi.configurator.AnnotatedMethodConfigurator;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.declarations.MethodInfo;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.weld.lite.extension.translator.AnnotationInfoImpl;
import org.jboss.weld.lite.extension.translator.AnnotationProxy;
import org.jboss.weld.lite.extension.translator.MethodInfoImpl;
import org.jboss.weld.lite.extension.translator.ParameterConfigImpl;

class MethodConfigImpl
implements MethodConfig {
    private final AnnotatedMethodConfigurator<?> configurator;

    MethodConfigImpl(AnnotatedMethodConfigurator<?> configurator) {
        this.configurator = configurator;
    }

    public MethodInfo info() {
        return new MethodInfoImpl((AnnotatedCallable<?>)this.configurator.getAnnotated());
    }

    public MethodConfig addAnnotation(Class<? extends Annotation> annotationType) {
        this.configurator.add(AnnotationProxy.create(annotationType, Collections.emptyMap()));
        return this;
    }

    public MethodConfig addAnnotation(AnnotationInfo annotation) {
        this.configurator.add(((AnnotationInfoImpl)annotation).annotation);
        return this;
    }

    public MethodConfig addAnnotation(Annotation annotation) {
        this.configurator.add(annotation);
        return this;
    }

    public MethodConfig removeAnnotation(Predicate<AnnotationInfo> predicate) {
        this.configurator.remove(annotation -> predicate.test(new AnnotationInfoImpl((Annotation)annotation)));
        return this;
    }

    public MethodConfig removeAllAnnotations() {
        this.configurator.removeAll();
        return this;
    }

    public List<ParameterConfig> parameters() {
        return this.configurator.params().stream().map(ParameterConfigImpl::new).collect(Collectors.toList());
    }
}

