/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.logging;

import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.WeldLogger;

@MessageLogger(projectCode="WELD-")
public interface XmlLogger
extends WeldLogger {
    public static final XmlLogger LOG = Logger.getMessageLogger(XmlLogger.class, Category.BOOTSTRAP.getName());

    @Message(id=1200, value="Error configuring XML parser")
    public IllegalStateException configurationError(@Cause Throwable var1);

    @Message(id=1201, value="Error loading beans.xml {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException loadError(Object var1, @Cause Throwable var2);

    @Message(id=1202, value="Error parsing {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException parsingError(Object var1, @Cause Throwable var2);

    @Message(id=1203, value="<alternatives> can only be specified once, but appears multiple times:  {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException multipleAlternatives(Object var1);

    @Message(id=1204, value="<decorators> can only be specified once, but is specified multiple times:  {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException multipleDecorators(Object var1);

    @Message(id=1205, value="<interceptors> can only be specified once, but it is specified multiple times:  {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException multipleInterceptors(Object var1);

    @Deprecated
    @Message(id=1206, value="Could not load class {0}", format=Message.Format.MESSAGE_FORMAT)
    public String cannotLoadClass(Object var1);

    @Message(id=1207, value="<scan> can only be specified once, but it is specified multiple times:  {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException multipleScanning(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1208, value="Error when validating {0}@{1} against xsd. {2}", format=Message.Format.MESSAGE_FORMAT)
    public void xsdValidationError(Object var1, Object var2, Object var3);

    @Deprecated
    @Message(id=1209, value="Exception opening InputStream for {0}", format=Message.Format.MESSAGE_FORMAT)
    public String exceptionOpeningInputStream(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1210, value="Warning when validating {0}@{1} against xsd. {2}", format=Message.Format.MESSAGE_FORMAT)
    public void xsdValidationWarning(Object var1, Object var2, Object var3);
}

