/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.callback;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.SerializableStore;

public class BlockingCallbackStore
implements SerializableStore {
    private Object lockObject = new Object();
    private List callbacks = new ArrayList();
    private static final Logger log = Logger.getLogger((Class)BlockingCallbackStore.class);

    public int size() {
        return this.callbacks.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNext() throws IOException {
        Object callback = null;
        Object object = this.lockObject;
        synchronized (object) {
            if (this.callbacks.size() > 0) {
                callback = this.callbacks.remove(0);
            }
            this.lockObject.notify();
        }
        return callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Serializable object) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Adding " + object + " to blocking callback store.  Calling thread " + Thread.currentThread() + " will be held until getNext() is called"));
        }
        Object object2 = this.lockObject;
        synchronized (object2) {
            try {
                this.callbacks.add(object);
                this.lockObject.wait();
            }
            catch (InterruptedException e) {
                log.debug((Object)("InterruptedException received while waiting for thread (" + Thread.currentThread() + ") to be released from BlockingCallbackStore.add(Serializable) call."));
            }
        }
    }

    public void setConfig(Map config) {
    }

    public void start() throws Exception {
    }

    public void stop() {
    }

    public void create() throws Exception {
    }

    public void destroy() {
    }

    public void setPurgeOnShutdown(boolean purgeOnShutdown) {
    }

    public boolean getPurgeOnShutdown() {
        return false;
    }

    public void purgeFiles() {
    }
}

