/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mwlabs.wscf.model.twophase.arjunacore.subordinate;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.RecordList;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.mw.wsas.activity.Outcome;
import com.arjuna.mw.wsas.completionstatus.CompletionStatus;
import com.arjuna.mw.wsas.exceptions.ProtocolViolationException;
import com.arjuna.mw.wsas.exceptions.SystemException;
import com.arjuna.mw.wsas.exceptions.WrongStateException;
import com.arjuna.mwlabs.wscf.model.twophase.arjunacore.ATCoordinator;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;

public class SubordinateATCoordinator
extends ATCoordinator {
    public static final String TRANSACTION_TYPE = "/StateManager/BasicAction/AtomicAction/TwoPhaseCoordinator/TwoPhase/SubordinateATCoordinator";
    public static String PARTICIPANT_PREFIX = "org.jboss.jbossts.xts.at.subordinate.participant.";
    public static final String SUBORDINATE_TX_TYPE_AT_AT = "org.jboss.jbossts.xts.at.at.subordinate";
    private int finalStatus = 8;
    private boolean activated;
    private boolean isReadonly;
    private String subordinateType;
    private static final HashMap<String, SubordinateATCoordinator> recoveredCoordinators = new HashMap();
    private static final HashMap<String, Boolean> activeProxies = new HashMap();
    private static final HashMap<String, SubordinateCallback> callbacks = new HashMap();

    public SubordinateATCoordinator() {
        this.subordinate = true;
        this.activated = true;
        this.isReadonly = false;
    }

    public SubordinateATCoordinator(String subordinateType) {
        this.subordinate = true;
        this.activated = true;
        this.isReadonly = false;
        this.subordinateType = subordinateType;
    }

    public SubordinateATCoordinator(Uid recovery) {
        super(recovery);
        this.subordinate = true;
        this.activated = false;
        this.isReadonly = false;
        this.subordinateType = null;
    }

    @Override
    public Outcome coordinate(CompletionStatus cs) throws WrongStateException, ProtocolViolationException, SystemException {
        throw new ProtocolViolationException();
    }

    public int end(boolean reportHeuristics) {
        return 9;
    }

    public int cancel() {
        return 9;
    }

    public boolean prepareVolatile() {
        return super.beforeCompletion();
    }

    public int prepare() {
        int status = super.prepare(true);
        this.isReadonly = status == 2;
        return status;
    }

    public void commitVolatile() {
        if (this.isReadonly) {
            super.afterCompletion(7);
        } else {
            super.afterCompletion(this.finalStatus);
        }
    }

    public void commit() {
        int status;
        super.phase2Commit(true);
        switch (super.getHeuristicDecision()) {
            case 0: 
            case 7: {
                status = super.status();
                break;
            }
            case 3: {
                status = 11;
                break;
            }
            case 4: {
                status = 12;
                break;
            }
            case 5: {
                status = 13;
                break;
            }
            default: {
                status = 14;
            }
        }
        this.finalStatus = status;
        if (status != 6) {
            SubordinateATCoordinator.removeRecoveredCoordinator(this);
        }
        this.runCallback(this.get_uid().stringForm());
    }

    public void rollbackVolatile() {
        if (this.isReadonly) {
            super.afterCompletion(4);
        } else {
            super.afterCompletion(this.finalStatus);
        }
    }

    public void rollback() {
        int status;
        if (this.heuristicList == null) {
            this.heuristicList = new RecordList();
        }
        super.phase2Abort(true);
        switch (super.getHeuristicDecision()) {
            case 0: 
            case 7: {
                status = super.status();
                break;
            }
            case 3: {
                status = 11;
                break;
            }
            case 4: {
                status = 12;
                break;
            }
            case 5: {
                status = 13;
                break;
            }
            default: {
                status = 14;
            }
        }
        SubordinateATCoordinator.removeRecoveredCoordinator(this);
        this.runCallback(this.get_uid().stringForm());
        this.finalStatus = status;
    }

    public void unknown() {
    }

    public void error() {
    }

    @Override
    public String type() {
        return TRANSACTION_TYPE;
    }

    public String getVolatile2PhaseId() {
        return PARTICIPANT_PREFIX + this.get_uid().stringForm() + "_V";
    }

    public String getDurable2PhaseId() {
        return PARTICIPANT_PREFIX + this.get_uid().stringForm() + "_D";
    }

    protected static synchronized void addRecoveredCoordinator(SubordinateATCoordinator coordinator) {
        recoveredCoordinators.put(coordinator.get_uid().stringForm(), coordinator);
    }

    protected static synchronized void removeRecoveredCoordinator(SubordinateATCoordinator coordinator) {
        recoveredCoordinators.remove(coordinator.get_uid().stringForm());
    }

    public static synchronized void addActiveProxy(String id) {
        activeProxies.put(id, Boolean.TRUE);
    }

    public static synchronized void removeActiveProxy(String id) {
        activeProxies.remove(id);
    }

    protected void setActivated() {
        this.activated = true;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public boolean isOrphaned() {
        String id = this.get_uid().stringForm();
        if (SubordinateATCoordinator.isActiveProxy(id)) {
            return false;
        }
        return SubordinateATCoordinator.getRecoveredCoordinator(id) != null;
    }

    private static synchronized boolean isActiveProxy(String proxyId) {
        return activeProxies.get(proxyId) == Boolean.TRUE;
    }

    public static synchronized SubordinateATCoordinator getRecoveredCoordinator(String coordinatorId) {
        return recoveredCoordinators.get(coordinatorId);
    }

    public static synchronized SubordinateATCoordinator[] listRecoveredCoordinators() {
        Collection<SubordinateATCoordinator> values = recoveredCoordinators.values();
        int length = values.size();
        return values.toArray(new SubordinateATCoordinator[length]);
    }

    public String getSubordinateType() {
        return this.subordinateType;
    }

    public boolean save_state(OutputObjectState os, int ot) {
        if (super.save_state(os, ot)) {
            try {
                os.packString(this.subordinateType);
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean restore_state(InputObjectState os, int ot) {
        if (super.restore_state(os, ot)) {
            try {
                this.subordinateType = os.unpackString();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static void addCallback(String key, SubordinateCallback callback) {
        SubordinateCallback old;
        callback.next = old = callbacks.put(key, callback);
    }

    private void runCallback(String key) {
        SubordinateCallback callback = callbacks.get(key);
        while (callback != null) {
            callback.run();
            callback = callback.next;
        }
    }

    public static abstract class SubordinateCallback {
        private SubordinateCallback next;

        public abstract void run();
    }
}

