/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.xts.bridge.at;

import com.arjuna.mw.wst.TxContext;
import com.arjuna.mwlabs.wscf.model.twophase.arjunacore.subordinate.SubordinateATCoordinator;
import com.arjuna.mwlabs.wst11.at.ContextFactoryImple;
import com.arjuna.mwlabs.wst11.at.context.TxContextImple;
import com.arjuna.wsc11.ContextFactoryMapper;
import com.arjuna.wst.UnknownTransactionException;
import org.jboss.jbossts.xts.recovery.participant.at.XTSATRecoveryManager;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.CoordinationContextType;

public class BridgeWrapper {
    private static ContextFactoryImple contextFactory = (ContextFactoryImple)ContextFactoryMapper.getMapper().getContextFactory("http://docs.oasis-open.org/ws-tx/wsat/2006/06");
    public static final String SUBORDINATE_TX_TYPE_AT_AT = "org.jboss.jbossts.xts.at.at.subordinate";
    private SubordinateATCoordinator coordinator;
    private TxContext context;
    private String id;
    private String subordinateType;
    private static final BridgeWrapper[] EMPTY_SCAN = new BridgeWrapper[0];

    private BridgeWrapper() {
    }

    public static BridgeWrapper create(String subordinateType, long expires, boolean isSecure) {
        ContextFactoryImple.BridgeTxData bridgeTxData = contextFactory.createBridgedTransaction(subordinateType, Long.valueOf(expires), isSecure);
        if (bridgeTxData != null) {
            BridgeWrapper bridgeWrapper = new BridgeWrapper();
            bridgeWrapper.context = new TxContextImple((CoordinationContextType)bridgeTxData.context);
            bridgeWrapper.coordinator = bridgeTxData.coordinator;
            bridgeWrapper.id = bridgeTxData.identifier;
            bridgeWrapper.subordinateType = subordinateType;
            return bridgeWrapper;
        }
        return null;
    }

    public static BridgeWrapper recover(String identifier) throws UnknownTransactionException {
        SubordinateATCoordinator coordinator = SubordinateATCoordinator.getRecoveredCoordinator((String)identifier);
        if (coordinator != null) {
            BridgeWrapper bridgeWrapper = new BridgeWrapper();
            bridgeWrapper.context = null;
            bridgeWrapper.coordinator = coordinator;
            bridgeWrapper.id = identifier;
            bridgeWrapper.subordinateType = coordinator.getSubordinateType();
            return bridgeWrapper;
        }
        XTSATRecoveryManager recoveryManager = XTSATRecoveryManager.getRecoveryManager();
        if (recoveryManager != null && recoveryManager.isCoordinatorRecoveryStarted()) {
            throw new UnknownTransactionException();
        }
        return null;
    }

    public static BridgeWrapper[] scan(String subordinateType) {
        XTSATRecoveryManager recoveryManager = XTSATRecoveryManager.getRecoveryManager();
        if (!recoveryManager.isCoordinatorRecoveryStarted()) {
            return null;
        }
        if (subordinateType == null || subordinateType.equals(SUBORDINATE_TX_TYPE_AT_AT)) {
            return EMPTY_SCAN;
        }
        SubordinateATCoordinator[] coordinators = SubordinateATCoordinator.listRecoveredCoordinators();
        int count = 0;
        for (int i = 0; i < coordinators.length; ++i) {
            if (!coordinators[i].getSubordinateType().equals(subordinateType)) continue;
            ++count;
        }
        if (count == 0) {
            return EMPTY_SCAN;
        }
        BridgeWrapper[] result = new BridgeWrapper[count];
        count = 0;
        for (int i = 0; i < coordinators.length; ++i) {
            SubordinateATCoordinator coordinator = coordinators[i];
            if (!coordinator.getSubordinateType().equals(subordinateType)) continue;
            BridgeWrapper bridgeWrapper = new BridgeWrapper();
            bridgeWrapper.context = null;
            bridgeWrapper.coordinator = coordinator;
            bridgeWrapper.id = coordinator.get_uid().stringForm();
            bridgeWrapper.subordinateType = coordinator.getSubordinateType();
            result[count++] = bridgeWrapper;
        }
        return result;
    }

    public String getIdentifier() {
        return this.id;
    }

    public TxContext getContext() throws UnknownTransactionException {
        if (this.context != null) {
            return this.context;
        }
        throw new UnknownTransactionException();
    }

    public String getSubordinateType() {
        return this.subordinateType;
    }

    public boolean prepareVolatile() {
        return this.coordinator.prepareVolatile();
    }

    public int prepare() {
        return this.coordinator.prepare();
    }

    public void commitVolatile() {
        this.coordinator.commitVolatile();
    }

    public void commit() {
        this.coordinator.commit();
    }

    public void rollbackVolatile() {
        this.coordinator.rollbackVolatile();
    }

    public void rollback() {
        this.coordinator.rollback();
    }

    public String toString() {
        return String.format("XTS WS-AT bridge (%s) id %s of subordinate type %s managed by coordinator %s of context %s", super.toString(), this.id, this.subordinateType, this.coordinator, this.context);
    }
}

