/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mwlabs.wsas.activity;

import com.arjuna.mw.wsas.activity.ActivityHandle;
import com.arjuna.mw.wsas.activity.ActivityHierarchy;
import com.arjuna.mwlabs.wsas.activity.ActivityHandleImple;
import com.arjuna.mwlabs.wsas.activity.ActivityImple;
import java.util.Stack;

public class ActivityHierarchyImple
implements ActivityHierarchy {
    private Stack _hierarchy;
    private boolean _valid;

    public ActivityHierarchyImple(ActivityImple current) {
        this._hierarchy = new Stack();
        if (current != null) {
            ActivityImple[] hierarchy = current.hierarchy();
            for (int i = 0; i < hierarchy.length; ++i) {
                this._hierarchy.push(new ActivityHandleImple(hierarchy[i]));
            }
            this._valid = true;
        } else {
            this._valid = false;
        }
    }

    @Override
    public int size() {
        return this._hierarchy.size();
    }

    @Override
    public boolean valid() {
        return this._valid;
    }

    @Override
    public ActivityHandle activity(int index) throws IndexOutOfBoundsException {
        try {
            return (ActivityHandle)this._hierarchy.elementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public ActivityHandle current() {
        try {
            return (ActivityHandle)this._hierarchy.peek();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public ActivityHierarchy copy() {
        return new ActivityHierarchyImple(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ActivityHierarchyImple) {
                ActivityHierarchyImple compare = (ActivityHierarchyImple)obj;
                if (this._hierarchy.size() == compare._hierarchy.size()) {
                    for (int i = 0; i < this._hierarchy.size(); ++i) {
                        if (this._hierarchy.elementAt(i).equals(compare._hierarchy.elementAt(i))) continue;
                        return false;
                    }
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this._hierarchy.hashCode();
    }

    public String toString() {
        Object toReturn = "Activity context:";
        if (this._hierarchy == null || this._hierarchy.isEmpty()) {
            toReturn = (String)toReturn + " null";
        } else {
            for (int i = 0; i < this._hierarchy.size(); ++i) {
                toReturn = (String)toReturn + " " + this._hierarchy.elementAt(i);
            }
        }
        return toReturn;
    }

    protected ActivityHierarchyImple(ActivityHierarchyImple toCopy) {
        int copySize;
        this._hierarchy = null;
        this._valid = false;
        if (toCopy != null && (copySize = toCopy._hierarchy.size()) > 0) {
            this._hierarchy = new Stack();
            for (int i = 0; i < copySize; ++i) {
                this._hierarchy.push(toCopy._hierarchy.elementAt(i));
            }
            this._valid = true;
        }
    }
}

