/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mwlabs.wst11.at.participants;

import com.arjuna.mw.wsas.activity.ActivityHierarchy;
import com.arjuna.mw.wsas.exceptions.InvalidActivityException;
import com.arjuna.mw.wsas.exceptions.NoPermissionException;
import com.arjuna.mw.wsas.exceptions.ProtocolViolationException;
import com.arjuna.mw.wsas.exceptions.SystemException;
import com.arjuna.mw.wsas.exceptions.WrongStateException;
import com.arjuna.mw.wscf.exceptions.NoCoordinatorException;
import com.arjuna.mw.wscf.model.twophase.api.CoordinatorManager;
import com.arjuna.mw.wscf.model.twophase.exceptions.CoordinatorCancelledException;
import com.arjuna.mw.wscf.model.twophase.exceptions.CoordinatorConfirmedException;
import com.arjuna.mw.wscf.model.twophase.exceptions.HeuristicHazardException;
import com.arjuna.mw.wscf.model.twophase.exceptions.HeuristicMixedException;
import com.arjuna.webservices11.wsat.processors.CompletionCoordinatorProcessor;
import com.arjuna.wst.TransactionRolledBackException;
import com.arjuna.wst.UnknownTransactionException;
import com.arjuna.wst11.CompletionCoordinatorParticipant;
import jakarta.xml.ws.wsaddressing.W3CEndpointReference;

public class CompletionCoordinatorImple
implements CompletionCoordinatorParticipant {
    private CoordinatorManager _cm;
    private ActivityHierarchy _hier;
    private final boolean deactivate;
    private W3CEndpointReference participant;

    public CompletionCoordinatorImple(CoordinatorManager cm, ActivityHierarchy hier, boolean deactivate, W3CEndpointReference participant) {
        this._cm = cm;
        this._hier = hier;
        this.deactivate = deactivate;
        this.participant = participant;
    }

    @Override
    public void commit() throws TransactionRolledBackException, UnknownTransactionException, com.arjuna.wst.SystemException {
        try {
            if (this._hier != null) {
                this._cm.resume(this._hier);
            }
            this._cm.confirm();
        }
        catch (InvalidActivityException | NoCoordinatorException ex) {
            UnknownTransactionException ute = new UnknownTransactionException();
            ute.addSuppressed(ex);
            throw ute;
        }
        catch (CoordinatorCancelledException ex) {
            TransactionRolledBackException tre = new TransactionRolledBackException();
            tre.addSuppressed(ex);
            throw tre;
        }
        catch (NoPermissionException | ProtocolViolationException | WrongStateException | HeuristicHazardException | HeuristicMixedException ex) {
            com.arjuna.wst.SystemException se = new com.arjuna.wst.SystemException(ex.toString());
            se.addSuppressed(ex);
            throw se;
        }
        catch (SystemException ex) {
            com.arjuna.wst.SystemException se = new com.arjuna.wst.SystemException(ex.toString());
            se.addSuppressed(ex);
            throw se;
        }
        finally {
            if (this.deactivate) {
                CompletionCoordinatorProcessor.getProcessor().deactivateParticipant(this);
            }
        }
    }

    @Override
    public void rollback() throws UnknownTransactionException, com.arjuna.wst.SystemException {
        try {
            if (this._hier != null) {
                this._cm.resume(this._hier);
            }
            this._cm.cancel();
        }
        catch (InvalidActivityException | NoCoordinatorException ex) {
            UnknownTransactionException ute = new UnknownTransactionException();
            ute.addSuppressed(ex);
            throw ute;
        }
        catch (NoPermissionException | ProtocolViolationException | WrongStateException | CoordinatorConfirmedException | HeuristicHazardException | HeuristicMixedException ex) {
            com.arjuna.wst.SystemException se = new com.arjuna.wst.SystemException(ex.toString());
            se.addSuppressed(ex);
            throw se;
        }
        catch (SystemException ex) {
            com.arjuna.wst.SystemException se = new com.arjuna.wst.SystemException(ex.toString());
            se.addSuppressed(ex);
            throw se;
        }
        finally {
            if (this.deactivate) {
                CompletionCoordinatorProcessor.getProcessor().deactivateParticipant(this);
            }
        }
    }

    @Override
    public W3CEndpointReference getParticipant() {
        return this.participant;
    }
}

