/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.jta.jms;

import com.arjuna.ats.jta.logging.jtaLogger;
import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import javax.jms.XAConnectionFactory;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.narayana.jta.jms.ConnectionManager;

public class JmsXAResourceRecoveryHelper
implements XAResourceRecoveryHelper,
XAResource {
    private final ConnectionManager connectionManager;

    public JmsXAResourceRecoveryHelper(XAConnectionFactory xaConnectionFactory) {
        this(xaConnectionFactory, null, null);
    }

    public JmsXAResourceRecoveryHelper(XAConnectionFactory xaConnectionFactory, String user, String pass) {
        this(new ConnectionManager(xaConnectionFactory, user, pass));
    }

    public JmsXAResourceRecoveryHelper(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public boolean initialise(String properties) {
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)("Initialise with properties=" + properties));
        }
        return true;
    }

    public XAResource[] getXAResources() {
        if (!this.connectionManager.isConnected()) {
            try {
                this.connectionManager.connect();
            }
            catch (XAException ignored) {
                return new XAResource[0];
            }
        }
        return new XAResource[]{this};
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        try {
            Xid[] xidArray = this.connectionManager.connectAndApply(delegate -> delegate.recover(flag));
            return xidArray;
        }
        finally {
            if (flag == 0x800000) {
                this.connectionManager.disconnect();
            }
        }
    }

    @Override
    public void start(Xid xid, int flag) throws XAException {
        this.connectionManager.connectAndAccept(delegate -> delegate.start(xid, flag));
    }

    @Override
    public void end(Xid xid, int flag) throws XAException {
        this.connectionManager.connectAndAccept(delegate -> delegate.end(xid, flag));
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        return this.connectionManager.connectAndApply(delegate -> delegate.prepare(xid));
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.connectionManager.connectAndAccept(delegate -> delegate.commit(xid, onePhase));
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.connectionManager.connectAndAccept(delegate -> delegate.rollback(xid));
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        return this.connectionManager.connectAndApply(delegate -> delegate.isSameRM(xaResource));
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.connectionManager.connectAndAccept(delegate -> delegate.forget(xid));
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.connectionManager.connectAndApply(XAResource::getTransactionTimeout);
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.connectionManager.connectAndApply(delegate -> delegate.setTransactionTimeout(seconds));
    }
}

