/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jdbc.recovery;

import com.arjuna.ats.jdbc.common.jdbcPropertyManager;
import com.arjuna.ats.jdbc.logging.jdbcLogger;
import com.arjuna.ats.jta.recovery.XAResourceRecovery;
import com.arjuna.common.util.propertyservice.PropertiesFactory;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;

public class JDBCXARecovery
implements XAResourceRecovery {
    public static final String DATABASE_JNDI_NAME = "DatabaseJNDIName";
    public static final String USER_NAME = "UserName";
    public static final String PASSWORD = "Password";
    private XAConnection _connection;
    private XADataSource _dataSource;
    private LocalConnectionEventListener _connectionEventListener;
    private Properties _props;
    private String _dbName;
    private String _user;
    private String _password;
    private boolean _hasMoreResources;

    public JDBCXARecovery() throws SQLException {
        if (jdbcLogger.logger.isDebugEnabled()) {
            jdbcLogger.logger.debug((Object)"JDBCXARecovery()");
        }
        this._props = null;
        this._hasMoreResources = false;
        this._connectionEventListener = new LocalConnectionEventListener();
    }

    public boolean initialise(String parameter) throws SQLException {
        if (jdbcLogger.logger.isDebugEnabled()) {
            jdbcLogger.logger.debug((Object)("JDBCXARecovery.initialise(" + parameter + ")"));
        }
        if (parameter == null) {
            return false;
        }
        try {
            this._props = PropertiesFactory.getPropertiesFromFile((String)parameter, (ClassLoader)JDBCXARecovery.class.getClassLoader());
            this._dbName = this._props.getProperty(DATABASE_JNDI_NAME);
            this._user = this._props.getProperty(USER_NAME);
            this._password = this._props.getProperty(PASSWORD);
        }
        catch (Exception e) {
            jdbcLogger.i18NLogger.warn_recovery_xa_initexp(e);
            return false;
        }
        return true;
    }

    public synchronized XAResource getXAResource() throws SQLException {
        this.createConnection();
        return this._connection.getXAResource();
    }

    public boolean hasMoreResources() {
        if (this._dataSource == null) {
            try {
                this.createDataSource();
            }
            catch (SQLException sqlException) {
                return false;
            }
        }
        if (this._dataSource != null) {
            this._hasMoreResources = !this._hasMoreResources;
            return this._hasMoreResources;
        }
        return false;
    }

    private final void createDataSource() throws SQLException {
        try {
            if (this._dataSource == null) {
                Hashtable env = jdbcPropertyManager.getJDBCEnvironmentBean().getJndiProperties();
                InitialContext context = new InitialContext(env);
                this._dataSource = (XADataSource)context.lookup(this._dbName);
                if (this._dataSource == null) {
                    throw new SQLException(jdbcLogger.i18NLogger.get_cant_resolve_ds_jndi_lookup(this._dbName, env));
                }
            }
        }
        catch (SQLException ex) {
            jdbcLogger.i18NLogger.error_cannot_create_datasource(this._dbName, ex);
            throw ex;
        }
        catch (Exception e) {
            jdbcLogger.i18NLogger.error_cannot_create_datasource(this._dbName, e);
            SQLException sqlException = new SQLException(e.toString());
            sqlException.initCause(e);
            throw sqlException;
        }
    }

    private final void createConnection() throws SQLException {
        if (this._dataSource == null) {
            this.createDataSource();
        }
        try {
            if (this._connection == null) {
                this._connection = this._user == null && this._password == null ? this._dataSource.getXAConnection() : this._dataSource.getXAConnection(this._user, this._password);
                this._connection.addConnectionEventListener(this._connectionEventListener);
            }
        }
        catch (SQLException ex) {
            jdbcLogger.i18NLogger.error_cannot_create_connection(this._dataSource, this._user, this._password, ex);
            throw ex;
        }
        catch (Exception e) {
            jdbcLogger.i18NLogger.error_cannot_create_connection(this._dataSource, this._user, this._password, e);
            SQLException sqlException = new SQLException(e.toString());
            sqlException.initCause(e);
            throw sqlException;
        }
    }

    private class LocalConnectionEventListener
    implements ConnectionEventListener {
        private LocalConnectionEventListener() {
        }

        @Override
        public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            JDBCXARecovery.this._connection.removeConnectionEventListener(JDBCXARecovery.this._connectionEventListener);
            JDBCXARecovery.this._connection = null;
        }

        @Override
        public void connectionClosed(ConnectionEvent connectionEvent) {
            JDBCXARecovery.this._connection.removeConnectionEventListener(JDBCXARecovery.this._connectionEventListener);
            JDBCXARecovery.this._connection = null;
        }
    }
}

