/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jdbc.recovery;

import com.arjuna.ats.internal.jdbc.recovery.JDBC2RecoveryConnection;
import com.arjuna.ats.jdbc.logging.jdbcLogger;
import com.arjuna.ats.jta.recovery.XAResourceRecovery;
import com.arjuna.common.util.propertyservice.PropertiesFactory;
import java.sql.SQLException;
import java.util.Properties;
import javax.transaction.xa.XAResource;

public class BasicXARecovery
implements XAResourceRecovery {
    private int numberOfConnections;
    private int connectionIndex;
    private Properties props;
    private static final String dbTag = "DB_";
    private static final String urlTag = "_DatabaseURL";
    private static final String passwordTag = "_DatabasePassword";
    private static final String userTag = "_DatabaseUser";
    private static final String dynamicClassTag = "_DatabaseDynamicClass";
    private static final char BREAKCHARACTER = ';';
    private JDBC2RecoveryConnection[] connections;

    public BasicXARecovery() throws SQLException {
        if (jdbcLogger.logger.isDebugEnabled()) {
            jdbcLogger.logger.debug((Object)"BasicXARecovery ()");
        }
        this.numberOfConnections = 1;
        this.connectionIndex = 0;
        this.props = null;
    }

    public boolean initialise(String parameter) throws SQLException {
        if (jdbcLogger.logger.isDebugEnabled()) {
            jdbcLogger.logger.debug((Object)("BasicXARecovery.setDetail(" + parameter + ")"));
        }
        if (parameter == null) {
            return true;
        }
        int breakPosition = parameter.indexOf(59);
        String fileName = parameter;
        if (breakPosition != -1) {
            fileName = parameter.substring(0, breakPosition - 1);
            try {
                this.numberOfConnections = Integer.parseInt(parameter.substring(breakPosition + 1));
            }
            catch (NumberFormatException e) {
                jdbcLogger.i18NLogger.warn_recovery_basic_initexp(e);
                return false;
            }
        }
        try {
            this.props = PropertiesFactory.getPropertiesFromFile((String)fileName, (ClassLoader)BasicXARecovery.class.getClassLoader());
        }
        catch (Exception e) {
            jdbcLogger.i18NLogger.warn_recovery_basic_initexp(e);
            return false;
        }
        if (jdbcLogger.logger.isDebugEnabled()) {
            jdbcLogger.logger.debug((Object)("BasicXARecovery properties file = " + parameter));
        }
        return true;
    }

    public synchronized XAResource getXAResource() throws SQLException {
        if (this.connections == null) {
            this.connections = new JDBC2RecoveryConnection[this.numberOfConnections];
        }
        try {
            XAResource xAResource = this.getConnection().recoveryConnection().getResource();
            return xAResource;
        }
        finally {
            ++this.connectionIndex;
        }
    }

    public synchronized boolean hasMoreResources() {
        if (this.connectionIndex == this.numberOfConnections) {
            this.connectionIndex = 0;
            return false;
        }
        return true;
    }

    private final JDBC2RecoveryConnection getConnection() throws SQLException {
        if (this.connections[this.connectionIndex] == null) {
            String number = new String("" + (this.connectionIndex + 1));
            String url = new String(dbTag + number + urlTag);
            String password = new String(dbTag + number + passwordTag);
            String user = new String(dbTag + number + userTag);
            String dynamicClass = new String(dbTag + number + dynamicClassTag);
            Properties dbProperties = new Properties();
            String theUser = this.props.getProperty(user);
            String thePassword = this.props.getProperty(password);
            String theURL = this.props.getProperty(url);
            if (theUser != null) {
                JDBC2RecoveryConnection connection;
                dbProperties.put("user", theUser);
                dbProperties.put("password", thePassword);
                String dc = this.props.getProperty(dynamicClass);
                if (dc != null) {
                    dbProperties.put("DYNAMIC_CLASS", dc);
                }
                this.connections[this.connectionIndex] = connection = new JDBC2RecoveryConnection(theURL, dbProperties);
                return connection;
            }
            jdbcLogger.i18NLogger.warn_recovery_basic_xarec("BasicXARecovery.getConnection -");
            throw new SQLException(jdbcLogger.i18NLogger.insufficientConnectionInformation());
        }
        return this.connections[this.connectionIndex];
    }
}

