/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.javaee.jboss;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlType(propOrder={"principalName", "roleName", "runAsRoles"})
public class RunAsIdentityMetaData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String principalName;
    private String roleName;
    private HashSet<String> runAsRoles = new HashSet();
    private static final String ANOYMOUS_PRINCIPAL = "anonymous";

    public RunAsIdentityMetaData(String roleName, String principalName) {
        if (principalName == null) {
            principalName = ANOYMOUS_PRINCIPAL;
        }
        if (roleName == null) {
            throw new IllegalArgumentException("The run-as identity must have at least one role");
        }
        this.principalName = principalName;
        this.roleName = roleName;
        this.runAsRoles.add(roleName);
    }

    public RunAsIdentityMetaData(String roleName, String principalName, Set<String> extraRoleNames) {
        this(roleName, principalName);
        if (extraRoleNames != null) {
            for (String extraRoleName : extraRoleNames) {
                this.runAsRoles.add(extraRoleName);
            }
        }
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public Set<String> getRunAsRoles() {
        return new HashSet<String>(this.runAsRoles);
    }

    public boolean doesUserHaveRole(String role) {
        return this.runAsRoles.contains(role);
    }

    public boolean doesUserHaveRole(Set<String> methodRoles) {
        if (methodRoles != null) {
            for (String role : methodRoles) {
                if (!this.doesUserHaveRole(role)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "[roles=" + this.runAsRoles + ",principal=" + this.getPrincipalName() + "]";
    }
}

