/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import javax.ejb.Stateful;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.creator.ejb.AbstractSessionBeanProcessor;
import org.jboss.metadata.annotation.creator.ejb.PostActivateMethodProcessor;
import org.jboss.metadata.annotation.creator.ejb.PrePassivateMethodProcessor;
import org.jboss.metadata.annotation.creator.ejb.RemoveProcessor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
import org.jboss.metadata.ejb.spec.SessionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulProcessor
extends AbstractSessionBeanProcessor {
    public StatefulProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
        this.addMethodProcessor(new RemoveProcessor(finder));
        this.addMethodProcessor(new PostActivateMethodProcessor(finder));
        this.addMethodProcessor(new PrePassivateMethodProcessor(finder));
    }

    @Override
    public SessionBeanMetaData create(Class<?> beanClass) {
        Stateful annotation = this.finder.getAnnotation(beanClass, Stateful.class);
        if (annotation == null) {
            return null;
        }
        SessionBeanMetaData beanMetaData = this.create(beanClass, annotation);
        beanMetaData.setSessionType(SessionType.Stateful);
        return beanMetaData;
    }

    protected SessionBeanMetaData create(Class<?> beanClass, Stateful annotation) {
        return this.create(beanClass, annotation.name(), annotation.mappedName(), annotation.description());
    }

    @Override
    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(Stateful.class);
    }
}

