/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.javaee.support;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.metadata.javaee.support.IdMetaDataImpl;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.javaee.support.MappedMetaData;
import org.jboss.metadata.javaee.support.NonNullLinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMappedMetaData<T extends MappableMetaData>
extends IdMetaDataImpl
implements MappedMetaData<T> {
    private static final long serialVersionUID = 5696461894017065337L;
    private String keyName;
    private Map<String, T> map;

    public static <T extends MappableMetaData> T getByName(String name, MappedMetaData<T> map) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (map == null) {
            return null;
        }
        return map.get(name);
    }

    protected AbstractMappedMetaData(String keyName) {
        if (keyName == null) {
            throw new IllegalArgumentException("Null keyName");
        }
        this.keyName = keyName;
    }

    @Override
    public boolean containsKey(String key) {
        boolean containsKey = false;
        if (this.map != null) {
            containsKey = this.map.containsKey(key);
        }
        return containsKey;
    }

    @Override
    public Set<String> keySet() {
        if (this.map == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public T get(String key) {
        if (key == null) {
            throw new IllegalArgumentException(this.keyName + " (/key) is null");
        }
        if (this.map == null) {
            return null;
        }
        return (T)((MappableMetaData)this.map.get(key));
    }

    @Override
    public boolean add(T o) {
        MappableMetaData result;
        if (o == null) {
            throw new IllegalArgumentException("Null object");
        }
        String key = o.getKey();
        if (key == null) {
            throw new IllegalArgumentException(this.keyName + " (/key) is null");
        }
        if (this.map == null) {
            this.map = new NonNullLinkedHashMap<String, T>();
        }
        if ((result = (MappableMetaData)this.map.put(key, o)) != null) {
            this.removeNotification(result);
        }
        this.addNotification(o);
        return true;
    }

    @Override
    public void clear() {
        if (this.map != null) {
            for (MappableMetaData t : this.map.values()) {
                this.removeNotification(t);
            }
        }
        this.map = null;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Null object");
        }
        if (this.map == null) {
            return false;
        }
        return this.map.containsValue(o);
    }

    @Override
    public Iterator<T> iterator() {
        if (this.map == null) {
            List result = Collections.emptyList();
            return result.iterator();
        }
        return Collections.unmodifiableCollection(this.map.values()).iterator();
    }

    @Override
    public boolean remove(Object o) {
        MappableMetaData result;
        if (o == null) {
            throw new IllegalArgumentException("Null object");
        }
        if (o instanceof MappableMetaData) {
            return false;
        }
        if (this.map == null) {
            return false;
        }
        MappableMetaData m = (MappableMetaData)o;
        String key = m.getKey();
        MappableMetaData v = (MappableMetaData)this.map.get(key);
        if (m.equals(v) && (result = (MappableMetaData)this.map.remove(key)) != null) {
            this.removeNotification(result);
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        if (this.map == null) {
            return 0;
        }
        return this.map.size();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean result = false;
        for (MappableMetaData object : c) {
            if (!this.add((T)object)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (this.map == null) {
            return c.isEmpty();
        }
        for (Object object : c) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        if (this.map == null) {
            return true;
        }
        return this.size() == 0;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.map == null) {
            return false;
        }
        boolean result = false;
        for (Object object : c) {
            if (!this.remove(object)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.map == null) {
            return false;
        }
        boolean result = false;
        for (MappableMetaData o : this.map.values()) {
            if (!c.contains(o) || !this.remove(o)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public Object[] toArray() {
        if (this.map == null) {
            return new Object[0];
        }
        return this.map.values().toArray();
    }

    @Override
    public <X> X[] toArray(X[] a) {
        if (this.map == null) {
            return new Object[0];
        }
        return this.map.values().toArray(a);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Collection)) {
            return false;
        }
        Collection other = (Collection)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.map == null) {
            return true;
        }
        return other.containsAll(this.map.values());
    }

    @Override
    public int hashCode() {
        if (this.map == null) {
            return 0;
        }
        return ((Object)this.map.values()).hashCode();
    }

    public String toString() {
        if (this.map == null) {
            return "[]";
        }
        return this.map.values().toString();
    }

    protected void addNotification(T added) {
    }

    protected void removeNotification(T removed) {
    }
}

